/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.HashMap;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.NonNullUpgrader;

public abstract class StoreUpgraderPhase
extends NonNullUpgrader {
    private final String _fromVersion;
    private final String _toVersion;
    private final String _versionAttributeName;

    public StoreUpgraderPhase(String versionAttributeName, String fromVersion, String toVersion) {
        this._toVersion = toVersion;
        this._fromVersion = fromVersion;
        this._versionAttributeName = versionAttributeName;
    }

    protected ConfiguredObjectRecord upgradeRootRecord(ConfiguredObjectRecord record) {
        HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(record.getAttributes());
        updatedAttributes.put(this._versionAttributeName, this._toVersion);
        record = new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
        this.getUpdateMap().put(record.getId(), record);
        return record;
    }

    public String getFromVersion() {
        return this._fromVersion;
    }

    public String getToVersion() {
        return this._toVersion;
    }
}

