/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractTrustStore;
import org.apache.qpid.server.security.CertificateDetails;
import org.apache.qpid.server.security.CertificateDetailsImpl;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.server.transport.network.security.ssl.QpidPeersOnlyTrustManager;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.StringUtil;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;

public class FileTrustStoreImpl
extends AbstractTrustStore<FileTrustStoreImpl>
implements FileTrustStore<FileTrustStoreImpl> {
    @ManagedAttributeField
    private volatile String _trustStoreType;
    @ManagedAttributeField
    private volatile String _trustManagerFactoryAlgorithm;
    @ManagedAttributeField(afterSet="postSetStoreUrl")
    private volatile String _storeUrl;
    private volatile String _path;
    @ManagedAttributeField
    private volatile boolean _peersOnly;
    @ManagedAttributeField
    private volatile String _password;
    private volatile TrustManager[] _trustManagers;
    private volatile Map<String, Certificate> _certificates = Collections.emptyMap();

    @ManagedObjectFactoryConstructor
    public FileTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        FileTrustStoreImpl.validateTrustStore(this);
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        this.initializeExpiryChecking();
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        FileTrustStore updated = (FileTrustStore)proxyForValidation;
        if (changedAttributes.contains("desiredState") && updated.getDesiredState() == State.DELETED) {
            return;
        }
        FileTrustStoreImpl.validateTrustStore(updated);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.initialize();
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        super.changeAttributes(attributes);
        if (attributes.containsKey("storeUrl") || attributes.containsKey("password") || attributes.containsKey("trustStoreType") || attributes.containsKey("trustManagerFactoryAlgorithm") || attributes.containsKey("peersOnly")) {
            this.initialize();
        }
    }

    private static KeyStore initializeKeyStore(FileTrustStore trustStore) throws GeneralSecurityException, IOException {
        URL trustStoreUrl = FileTrustStoreImpl.getUrlFromString(trustStore.getStoreUrl());
        return SSLUtil.getInitializedKeyStore(trustStoreUrl, trustStore.getPassword(), trustStore.getTrustStoreType());
    }

    private static void validateTrustStore(FileTrustStore trustStore) {
        String loggableStoreUrl = StringUtil.elideDataUrl(trustStore.getStoreUrl());
        try {
            KeyStore keyStore = FileTrustStoreImpl.initializeKeyStore(trustStore);
            Enumeration<String> aliasesEnum = keyStore.aliases();
            boolean certificateFound = false;
            while (aliasesEnum.hasMoreElements()) {
                String alias = aliasesEnum.nextElement();
                if (!keyStore.isCertificateEntry(alias)) continue;
                certificateFound = true;
                break;
            }
            if (!certificateFound) {
                throw new IllegalConfigurationException(String.format("Trust store '%s' must contain at least one certificate.", loggableStoreUrl));
            }
        }
        catch (UnrecoverableKeyException e) {
            String message = String.format("Check trust store password. Cannot instantiate trust store from '%s'.", loggableStoreUrl);
            throw new IllegalConfigurationException(message, e);
        }
        catch (IOException | GeneralSecurityException e) {
            String message = String.format("Cannot instantiate trust store from '%s'.", loggableStoreUrl);
            throw new IllegalConfigurationException(message, e);
        }
        try {
            TrustManagerFactory.getInstance(trustStore.getTrustManagerFactoryAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException(String.format("Unknown trustManagerFactoryAlgorithm '%s'", trustStore.getTrustManagerFactoryAlgorithm()));
        }
    }

    @Override
    public String getStoreUrl() {
        return this._storeUrl;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public String getTrustManagerFactoryAlgorithm() {
        return this._trustManagerFactoryAlgorithm;
    }

    @Override
    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    @Override
    public boolean isPeersOnly() {
        return this._peersOnly;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public void reload() {
        this.initialize();
    }

    @Override
    protected TrustManager[] getTrustManagersInternal() {
        TrustManager[] trustManagers = this._trustManagers;
        if (trustManagers == null || trustManagers.length == 0) {
            throw new IllegalStateException("Truststore " + this + " defines no trust managers");
        }
        return Arrays.copyOf(trustManagers, trustManagers.length);
    }

    @Override
    public Certificate[] getCertificates() {
        return this._certificates.values().toArray(new Certificate[0]);
    }

    @Override
    public List<CertificateDetails> getCertificateDetails() {
        if (this._certificates.isEmpty()) {
            return Collections.emptyList();
        }
        return this._certificates.entrySet().stream().filter(entry -> entry.getValue() instanceof X509Certificate).map(entry -> new CertificateDetailsImpl((X509Certificate)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
    }

    private void postSetStoreUrl() {
        this._path = this._storeUrl != null && !this._storeUrl.startsWith("data:") ? this._storeUrl : null;
    }

    @Override
    protected void initialize() {
        Map<String, Certificate> certificates;
        TrustManager[] trustManagers;
        try {
            KeyStore ts = FileTrustStoreImpl.initializeKeyStore(this);
            trustManagers = this.createTrustManagers(ts);
            certificates = Collections.unmodifiableMap(SSLUtil.getCertificatesAsMap(ts));
        }
        catch (Exception e) {
            throw new IllegalConfigurationException(String.format("Cannot instantiate trust store '%s'", this.getName()), e);
        }
        this._trustManagers = trustManagers;
        this._certificates = certificates;
    }

    private TrustManager[] createTrustManagers(KeyStore ts) throws KeyStoreException {
        TrustManager[] delegateManagers = this.getTrustManagers(ts);
        if (delegateManagers.length == 0) {
            throw new IllegalStateException("Truststore " + this + " defines no trust managers");
        }
        if (delegateManagers.length == 1) {
            if (this._peersOnly && delegateManagers[0] instanceof X509TrustManager) {
                return new TrustManager[]{new QpidPeersOnlyTrustManager(ts, (X509TrustManager)delegateManagers[0])};
            }
            return delegateManagers;
        }
        ArrayList<TrustManager> trustManagersCol = new ArrayList<TrustManager>();
        QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
        for (TrustManager tm : delegateManagers) {
            if (tm instanceof X509TrustManager) {
                if (this._peersOnly) {
                    mulTrustManager.addTrustManager(new QpidPeersOnlyTrustManager(ts, (X509TrustManager)tm));
                    continue;
                }
                mulTrustManager.addTrustManager((X509TrustManager)tm);
                continue;
            }
            trustManagersCol.add(tm);
        }
        if (!mulTrustManager.isEmpty()) {
            trustManagersCol.add(mulTrustManager);
        }
        return trustManagersCol.toArray(new TrustManager[trustManagersCol.size()]);
    }

    static {
        Handler.register();
    }
}

