/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import org.apache.qpid.server.logging.messages.AccessControlMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.AllowAllAccessControlProvider;

public class AllowAllAccessControlProviderImpl
extends AbstractConfiguredObject<AllowAllAccessControlProviderImpl>
implements AllowAllAccessControlProvider<AllowAllAccessControlProviderImpl> {
    private final Broker _broker;
    @ManagedAttributeField
    private int _priority;

    @ManagedObjectFactoryConstructor
    public AllowAllAccessControlProviderImpl(Map<String, Object> attributes, Broker broker) {
        super(broker, attributes);
        this._broker = broker;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public AccessControl getController() {
        return AccessControl.ALWAYS_ALLOWED;
    }

    @Override
    protected void logOperation(String operation) {
        this._broker.getEventLogger().message(AccessControlMessages.OPERATION(operation));
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        this.setState(this._broker.isManagementMode() ? State.QUIESCED : State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private ListenableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return Futures.immediateFuture(null);
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        this._broker.getEventLogger().message(AccessControlMessages.DELETE(this.getName()));
        return super.onDelete();
    }

    @Override
    public int compareTo(AccessControlProvider<?> o) {
        return ACCESS_CONTROL_PROVIDER_COMPARATOR.compare(this, o);
    }
}

