/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.RejectType;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingResult<M extends ServerMessage<? extends StorableMessageMetaData>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingResult.class);
    private final M _message;
    private final Set<BaseQueue> _queues = new HashSet<BaseQueue>();
    private final Map<BaseQueue, RejectReason> _rejectingRoutableQueues = new HashMap<BaseQueue, RejectReason>();

    public RoutingResult(M message) {
        this._message = message;
    }

    public void addQueue(BaseQueue q) {
        if (q.isDeleted()) {
            LOGGER.debug("Attempt to enqueue message onto deleted queue {}", (Object)q.getName());
        } else {
            this._queues.add(q);
        }
    }

    private void addQueues(Collection<? extends BaseQueue> queues) {
        boolean deletedQueues = false;
        for (BaseQueue baseQueue : queues) {
            if (!baseQueue.isDeleted()) continue;
            if (!deletedQueues) {
                deletedQueues = true;
                queues = new ArrayList<BaseQueue>(queues);
            }
            LOGGER.debug("Attempt to enqueue message onto deleted queue {}", (Object)baseQueue.getName());
            queues.remove(baseQueue);
        }
        this._queues.addAll(queues);
    }

    public void add(RoutingResult<M> result) {
        this.addQueues(result._queues);
        for (Map.Entry<BaseQueue, RejectReason> e : result._rejectingRoutableQueues.entrySet()) {
            if (e.getKey().isDeleted()) continue;
            this._rejectingRoutableQueues.put(e.getKey(), e.getValue());
        }
    }

    public void filter(Predicate<BaseQueue> predicate) {
        Iterator<BaseQueue> iter = this._queues.iterator();
        while (iter.hasNext()) {
            BaseQueue queue = iter.next();
            if (predicate.test(queue)) continue;
            iter.remove();
            this._rejectingRoutableQueues.remove(queue);
        }
    }

    public int send(ServerTransaction txn, final Action<? super MessageInstance> postEnqueueAction) {
        if (this.containsReject(RejectType.LIMIT_EXCEEDED, RejectType.PRECONDITION_FAILED)) {
            return 0;
        }
        final BaseQueue[] queues = this._queues.toArray(new BaseQueue[this._queues.size()]);
        txn.enqueue((Collection<? extends BaseQueue>)this._queues, (EnqueueableMessage)this._message, new ServerTransaction.EnqueueAction(){
            MessageReference _reference;
            {
                this._reference = RoutingResult.this._message.newReference();
            }

            @Override
            public void postCommit(MessageEnqueueRecord ... records) {
                try {
                    for (int i = 0; i < queues.length; ++i) {
                        queues[i].enqueue(RoutingResult.this._message, postEnqueueAction, records[i]);
                    }
                }
                finally {
                    this._reference.release();
                }
            }

            @Override
            public void onRollback() {
                this._reference.release();
            }
        });
        return this._queues.size();
    }

    public boolean hasRoutes() {
        return !this._queues.isEmpty();
    }

    public void addRejectReason(BaseQueue q, RejectType rejectType, String reason) {
        this._rejectingRoutableQueues.put(q, new RejectReason(rejectType, reason));
    }

    public boolean isRejected() {
        return !this._rejectingRoutableQueues.isEmpty();
    }

    public boolean containsReject(RejectType ... type) {
        for (RejectReason reason : this._rejectingRoutableQueues.values()) {
            for (RejectType t : type) {
                if (reason.getRejectType() != t) continue;
                return true;
            }
        }
        return false;
    }

    public String getRejectReason() {
        StringBuilder refusalMessages = new StringBuilder();
        for (RejectReason reason : this._rejectingRoutableQueues.values()) {
            if (refusalMessages.length() > 0) {
                refusalMessages.append(";");
            }
            refusalMessages.append(reason.getReason());
        }
        return refusalMessages.toString();
    }

    public int getNumberOfRoutes() {
        return this._queues.size();
    }

    public Collection<BaseQueue> getRoutes() {
        return Collections.unmodifiableCollection(this._queues);
    }

    private static class RejectReason {
        private final RejectType _rejectType;
        private final String _reason;

        private RejectReason(RejectType rejectType, String reason) {
            this._rejectType = rejectType;
            this._reason = reason;
        }

        private RejectType getRejectType() {
            return this._rejectType;
        }

        public String getReason() {
            return this._reason;
        }
    }
}

