/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.FanoutExchange;
import org.apache.qpid.server.exchange.FilterManagerReplacementRoutingKeyTuple;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FanoutExchangeImpl
extends AbstractExchange<FanoutExchangeImpl>
implements FanoutExchange<FanoutExchangeImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FanoutExchangeImpl.class);
    private volatile BindingSet _bindingSet = new BindingSet();

    @ManagedObjectFactoryConstructor
    public FanoutExchangeImpl(Map<String, Object> attributes, QueueManagingVirtualHost<?> vhost) {
        super(attributes, vhost);
    }

    @Override
    protected <M extends ServerMessage<? extends StorableMessageMetaData>> void doRoute(M message, String routingAddress, InstanceProperties instanceProperties, RoutingResult<M> result) {
        Map filteredDestinations;
        BindingSet bindingSet = this._bindingSet;
        if (!bindingSet._unfilteredDestinations.isEmpty()) {
            for (MessageDestination destination : bindingSet._unfilteredDestinations.keySet()) {
                HashSet replacementRoutingKeys = new HashSet(((Map)bindingSet._unfilteredDestinations.get(destination)).values());
                replacementRoutingKeys.forEach(replacementRoutingKey -> result.add(destination.route(message, replacementRoutingKey == null ? routingAddress : replacementRoutingKey, instanceProperties)));
            }
        }
        if (!(filteredDestinations = bindingSet._filteredDestinations).isEmpty()) {
            for (Map.Entry entry : filteredDestinations.entrySet()) {
                MessageDestination destination = (MessageDestination)entry.getKey();
                Map bindingMessageFilterMap = (Map)entry.getValue();
                for (FilterManagerReplacementRoutingKeyTuple tuple : bindingMessageFilterMap.values()) {
                    FilterManager filter = tuple.getFilterManager();
                    if (!filter.allAllow(Filterable.Factory.newInstance(message, instanceProperties))) continue;
                    String routingKey = tuple.getReplacementRoutingKey() == null ? routingAddress : tuple.getReplacementRoutingKey();
                    result.add(destination.route(message, routingKey, instanceProperties));
                }
            }
        }
    }

    @Override
    protected void onBindingUpdated(AbstractExchange.BindingIdentifier binding, Map<String, Object> newArguments) throws AMQInvalidArgumentException {
        this._bindingSet = this._bindingSet.updateBinding(binding, newArguments);
    }

    @Override
    protected void onBind(AbstractExchange.BindingIdentifier binding, Map<String, Object> arguments) throws AMQInvalidArgumentException {
        this._bindingSet = this._bindingSet.addBinding(binding, arguments);
    }

    @Override
    protected void onUnbind(AbstractExchange.BindingIdentifier binding) {
        this._bindingSet = this._bindingSet.removeBinding(binding);
    }

    private final class BindingSet {
        private final Map<MessageDestination, Map<AbstractExchange.BindingIdentifier, String>> _unfilteredDestinations;
        private final Map<MessageDestination, Map<AbstractExchange.BindingIdentifier, FilterManagerReplacementRoutingKeyTuple>> _filteredDestinations;

        BindingSet(Map<MessageDestination, Map<AbstractExchange.BindingIdentifier, String>> unfilteredDestinations, Map<MessageDestination, Map<AbstractExchange.BindingIdentifier, FilterManagerReplacementRoutingKeyTuple>> filteredDestinations) {
            this._unfilteredDestinations = unfilteredDestinations;
            this._filteredDestinations = filteredDestinations;
        }

        BindingSet() {
            this._unfilteredDestinations = Collections.emptyMap();
            this._filteredDestinations = Collections.emptyMap();
        }

        BindingSet addBinding(AbstractExchange.BindingIdentifier binding, Map<String, Object> arguments) throws AMQInvalidArgumentException {
            MessageDestination destination = binding.getDestination();
            if (FilterSupport.argumentsContainFilter(arguments)) {
                HashMap<MessageDestination, Map<AbstractExchange.BindingIdentifier, FilterManagerReplacementRoutingKeyTuple>> filteredDestinations = new HashMap<MessageDestination, Map<AbstractExchange.BindingIdentifier, FilterManagerReplacementRoutingKeyTuple>>(this._filteredDestinations);
                filteredDestinations.computeIfAbsent(destination, messageDestination -> new HashMap());
                HashMap<AbstractExchange.BindingIdentifier, FilterManagerReplacementRoutingKeyTuple> bindingsForDestination = new HashMap<AbstractExchange.BindingIdentifier, FilterManagerReplacementRoutingKeyTuple>((Map)filteredDestinations.get(destination));
                FilterManager filterManager = FilterSupport.createMessageFilter(arguments, destination);
                String replacementRoutingKey = arguments.get("x-replacement-routing-key") != null ? String.valueOf(arguments.get("x-replacement-routing-key")) : null;
                bindingsForDestination.put(binding, new FilterManagerReplacementRoutingKeyTuple(filterManager, replacementRoutingKey));
                filteredDestinations.put(destination, Collections.unmodifiableMap(bindingsForDestination));
                return new BindingSet(this._unfilteredDestinations, Collections.unmodifiableMap(filteredDestinations));
            }
            HashMap<MessageDestination, Map<AbstractExchange.BindingIdentifier, String>> unfilteredDestinations = new HashMap<MessageDestination, Map<AbstractExchange.BindingIdentifier, String>>(this._unfilteredDestinations);
            unfilteredDestinations.computeIfAbsent(destination, messageDestination -> new HashMap());
            String replacementRoutingKey = null;
            if (arguments != null && arguments.get("x-replacement-routing-key") != null) {
                replacementRoutingKey = String.valueOf(arguments.get("x-replacement-routing-key"));
            }
            HashMap<AbstractExchange.BindingIdentifier, String> replacementRoutingKeysForDestination = new HashMap<AbstractExchange.BindingIdentifier, String>((Map)unfilteredDestinations.get(destination));
            replacementRoutingKeysForDestination.put(binding, replacementRoutingKey);
            unfilteredDestinations.put(destination, Collections.unmodifiableMap(replacementRoutingKeysForDestination));
            return new BindingSet(Collections.unmodifiableMap(unfilteredDestinations), this._filteredDestinations);
        }

        BindingSet updateBinding(AbstractExchange.BindingIdentifier binding, Map<String, Object> newArguments) throws AMQInvalidArgumentException {
            return this.removeBinding(binding).addBinding(binding, newArguments);
        }

        BindingSet removeBinding(AbstractExchange.BindingIdentifier binding) {
            MessageDestination destination = binding.getDestination();
            if (this._filteredDestinations.containsKey(destination) && this._filteredDestinations.get(destination).containsKey(binding)) {
                HashMap<MessageDestination, Map<AbstractExchange.BindingIdentifier, FilterManagerReplacementRoutingKeyTuple>> filteredDestinations = new HashMap<MessageDestination, Map<AbstractExchange.BindingIdentifier, FilterManagerReplacementRoutingKeyTuple>>(this._filteredDestinations);
                HashMap bindingsForDestination = new HashMap((Map)filteredDestinations.get(destination));
                bindingsForDestination.remove(binding);
                if (bindingsForDestination.isEmpty()) {
                    filteredDestinations.remove(destination);
                } else {
                    filteredDestinations.put(destination, Collections.unmodifiableMap(bindingsForDestination));
                }
                return new BindingSet(this._unfilteredDestinations, Collections.unmodifiableMap(filteredDestinations));
            }
            if (this._unfilteredDestinations.containsKey(destination) && this._unfilteredDestinations.get(destination).containsKey(binding)) {
                HashMap<MessageDestination, Map<AbstractExchange.BindingIdentifier, String>> unfilteredDestinations = new HashMap<MessageDestination, Map<AbstractExchange.BindingIdentifier, String>>(this._unfilteredDestinations);
                HashMap bindingsForDestination = new HashMap((Map)unfilteredDestinations.get(destination));
                bindingsForDestination.remove(binding);
                if (bindingsForDestination.isEmpty()) {
                    unfilteredDestinations.remove(destination);
                } else {
                    unfilteredDestinations.put(destination, Collections.unmodifiableMap(bindingsForDestination));
                }
                return new BindingSet(Collections.unmodifiableMap(unfilteredDestinations), this._filteredDestinations);
            }
            return this;
        }
    }
}

