/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.DefaultConnectionProviderFactory;
import org.apache.qpid.server.store.jdbc.JDBCConnectionProviderFactory;
import org.apache.qpid.server.store.jdbc.JDBCSettings;
import org.slf4j.Logger;

public class JdbcUtils {
    public static void closeConnection(Connection conn, Logger logger) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error("Problem closing connection", (Throwable)e);
            }
        }
    }

    public static void closePreparedStatement(PreparedStatement stmt, Logger logger) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.error("Problem closing prepared statement", (Throwable)e);
            }
        }
    }

    public static boolean tableExists(String tableName, Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        return JdbcUtils.tableExistsCase(tableName.toUpperCase(), metaData) || JdbcUtils.tableExistsCase(tableName.toLowerCase(), metaData) || !tableName.equals(tableName.toUpperCase()) && !tableName.equals(tableName.toLowerCase()) && JdbcUtils.tableExistsCase(tableName, metaData);
    }

    public static ConnectionProvider createConnectionProvider(ConfiguredObject<?> parent, JDBCSettings settings, Logger logger) throws SQLException {
        String connectionPoolType = settings.getConnectionPoolType() == null ? "NONE" : settings.getConnectionPoolType();
        JDBCConnectionProviderFactory connectionProviderFactory = JDBCConnectionProviderFactory.FACTORIES.get(connectionPoolType);
        if (connectionProviderFactory == null) {
            logger.warn("Unknown connection pool type: {}.  No connection pooling will be used", (Object)connectionPoolType);
            connectionProviderFactory = new DefaultConnectionProviderFactory();
        }
        HashMap<String, String> providerAttributes = new HashMap<String, String>();
        HashSet<String> providerAttributeNames = new HashSet<String>(connectionProviderFactory.getProviderAttributeNames());
        providerAttributeNames.retainAll(parent.getContextKeys(false));
        for (String attr : providerAttributeNames) {
            providerAttributes.put(attr, (String)parent.getContextValue(String.class, attr));
        }
        return connectionProviderFactory.getConnectionProvider(settings.getConnectionUrl(), settings.getUsername(), settings.getPassword(), providerAttributes);
    }

    static ConnectionProvider createConnectionProvider(ConfiguredObject<?> parent, Logger logger) {
        JDBCSettings settings = (JDBCSettings)parent;
        try {
            return JdbcUtils.createConnectionProvider(parent, settings, logger);
        }
        catch (SQLException e) {
            throw new StoreException(String.format("Failed to create connection provider for connectionUrl: '%s' and username: '%s'", settings.getConnectionUrl(), settings.getUsername()), (Throwable)e);
        }
    }

    public static void dropTables(Connection connection, Logger logger, Collection<String> tableNames) {
        for (String tableName : tableNames) {
            try {
                Statement statement = connection.createStatement();
                Throwable throwable = null;
                try {
                    statement.execute(String.format("DROP TABLE %s", tableName));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException e) {
                logger.warn("Failed to drop table '" + tableName + "' :" + e);
            }
        }
    }

    private static boolean tableExistsCase(String tableName, DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getTables(null, null, tableName, null);){
            boolean bl = rs.next();
            return bl;
        }
    }
}

