/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHostAccessControlProvider;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.plugins.AbstractCommonRuleBasedAccessControlProvider;
import org.apache.qpid.server.security.access.plugins.AclRule;
import org.apache.qpid.server.security.access.plugins.RuleBasedVirtualHostAccessControlProvider;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public class RuleBasedVirtualHostAccessControlProviderImpl
extends AbstractCommonRuleBasedAccessControlProvider<RuleBasedVirtualHostAccessControlProviderImpl, QueueManagingVirtualHost<?>, VirtualHostAccessControlProvider<?>>
implements RuleBasedVirtualHostAccessControlProvider<RuleBasedVirtualHostAccessControlProviderImpl> {
    private static final EnumSet<ObjectType> ALLOWED_OBJECT_TYPES = EnumSet.of(ObjectType.ALL, ObjectType.QUEUE, ObjectType.EXCHANGE, ObjectType.VIRTUALHOST, ObjectType.METHOD);

    @ManagedObjectFactoryConstructor
    public RuleBasedVirtualHostAccessControlProviderImpl(Map<String, Object> attributes, QueueManagingVirtualHost<?> virtualHost) {
        super(attributes, virtualHost);
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("rules")) {
            for (AclRule rule : ((RuleBasedVirtualHostAccessControlProvider)proxyForValidation).getRules()) {
                if (ALLOWED_OBJECT_TYPES.contains((Object)rule.getObjectType())) continue;
                throw new IllegalArgumentException("Cannot use the object type " + (Object)((Object)rule.getObjectType()) + " only the following object types are allowed: " + ALLOWED_OBJECT_TYPES);
            }
        }
    }

    static {
        Handler.register();
    }
}

