/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Map;
import org.apache.qpid.server.security.access.config.AclAction;
import org.apache.qpid.server.security.access.config.Action;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.plugins.RuleOutcome;

public class Rule {
    public static final String ALL = "all";
    public static final String OWNER = "owner";
    private final String _identity;
    private final AclAction _action;
    private final RuleOutcome _ruleOutcome;

    public Rule(String identity, AclAction action, RuleOutcome ruleOutcome) {
        this._identity = identity;
        this._action = action;
        this._ruleOutcome = ruleOutcome;
    }

    public String getIdentity() {
        return this._identity;
    }

    public Action getAction() {
        return this._action.getAction();
    }

    public AclAction getAclAction() {
        return this._action;
    }

    public RuleOutcome getRuleOutcome() {
        return this._ruleOutcome;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this.getIdentity() != null ? !this.getIdentity().equals(rule.getIdentity()) : rule.getIdentity() != null) {
            return false;
        }
        if (this.getAction() != null ? !this.getAction().equals(rule.getAction()) : rule.getAction() != null) {
            return false;
        }
        return this.getRuleOutcome() == rule.getRuleOutcome();
    }

    public int hashCode() {
        int result = this.getIdentity() != null ? this.getIdentity().hashCode() : 0;
        result = 31 * result + (this.getAction() != null ? this.getAction().hashCode() : 0);
        result = 31 * result + (this.getRuleOutcome() != null ? this.getRuleOutcome().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Rule[identity='" + this._identity + '\'' + ", action=" + this._action + ", permission=" + (Object)((Object)this._ruleOutcome) + ']';
    }

    public Map<ObjectProperties.Property, String> getAttributes() {
        return this._action.getAttributes();
    }
}

