/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.qpid.server.security.access.config.DynamicRule;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.connection.ConnectionPrincipalFrequencyLimitRule;
import org.apache.qpid.server.security.access.config.connection.ConnectionPrincipalLimitRule;
import org.apache.qpid.server.security.access.firewall.FirewallRuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclRulePredicates {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclRulePredicates.class);
    private static final String SEPARATOR = ",";
    private final ObjectProperties _properties = new ObjectProperties();
    private final Map<ObjectProperties.Property, String> _parsedProperties = new HashMap<ObjectProperties.Property, String>();
    private volatile DynamicRule _dynamicRule = s -> true;
    private volatile FirewallRuleFactory _firewallRuleFactory = new FirewallRuleFactory();

    public AclRulePredicates() {
    }

    public AclRulePredicates(Map<ObjectProperties.Property, String> values) {
        if (values != null) {
            for (Map.Entry<ObjectProperties.Property, String> entry : values.entrySet()) {
                this.addPropertyValue(entry.getKey(), entry.getValue());
            }
        }
    }

    public void parse(String key, String value) {
        ObjectProperties.Property property = ObjectProperties.Property.parse(key);
        this.addPropertyValue(property, value);
        this._parsedProperties.put(property, value);
        LOGGER.debug("Parsed {} with value {}", (Object)property, (Object)value);
    }

    private void addPropertyValue(ObjectProperties.Property property, String value) {
        DynamicRule dynamicRule = this._dynamicRule;
        if (property == ObjectProperties.Property.FROM_HOSTNAME) {
            this.checkFirewallRuleNotAlreadyDefined(property, value, ObjectProperties.Property.FROM_NETWORK);
            this._dynamicRule = dynamicRule.and(this._firewallRuleFactory.createForHostname(value.split(SEPARATOR)));
        } else if (property == ObjectProperties.Property.FROM_NETWORK) {
            this.checkFirewallRuleNotAlreadyDefined(property, value, ObjectProperties.Property.FROM_HOSTNAME);
            this._dynamicRule = dynamicRule.and(this._firewallRuleFactory.createForNetwork(value.split(SEPARATOR)));
        } else if (property == ObjectProperties.Property.ATTRIBUTES) {
            this._properties.setAttributeNames(Sets.newHashSet((Object[])value.split(SEPARATOR)));
        } else if (property == ObjectProperties.Property.CONNECTION_LIMIT) {
            this.checkPropertyAlreadyDefined(property);
            int limit = this.getLimit(property, value);
            this._dynamicRule = dynamicRule.and(new ConnectionPrincipalLimitRule(limit));
        } else if (property == ObjectProperties.Property.CONNECTION_FREQUENCY_LIMIT) {
            this.checkPropertyAlreadyDefined(property);
            int limit = this.getLimit(property, value);
            this._dynamicRule = dynamicRule.and(new ConnectionPrincipalFrequencyLimitRule(limit));
        } else {
            this._properties.put(property, value);
        }
    }

    private int getLimit(ObjectProperties.Property property, String value) {
        int limit;
        try {
            limit = Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Property '%s' value '%s' is not integer", new Object[]{property, value}));
        }
        return limit;
    }

    private void checkFirewallRuleNotAlreadyDefined(ObjectProperties.Property property, String value, ObjectProperties.Property ... exclusiveProperty) {
        this.checkPropertyAlreadyDefined(property);
        for (ObjectProperties.Property p : exclusiveProperty) {
            if (!this._parsedProperties.containsKey((Object)p)) continue;
            throw new IllegalStateException(String.format("Cannot parse '%s=%s' because property '%s' has already been defined", new Object[]{property.toString().toLowerCase(), value, p}));
        }
    }

    private void checkPropertyAlreadyDefined(ObjectProperties.Property property) {
        if (this._parsedProperties.containsKey((Object)property)) {
            throw new IllegalStateException(String.format("Property '%s' has already been defined", property.toString().toLowerCase()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AclRulePredicates that = (AclRulePredicates)o;
        return this._parsedProperties.equals(that._parsedProperties);
    }

    public int hashCode() {
        return this._parsedProperties.hashCode();
    }

    public String toString() {
        return String.format("AclRulePredicates[%s]", this._parsedProperties.entrySet().stream().map(e -> e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(" ")));
    }

    DynamicRule getDynamicRule() {
        return this._dynamicRule;
    }

    ObjectProperties getObjectProperties() {
        return this._properties;
    }

    Map<ObjectProperties.Property, String> getParsedProperties() {
        return Collections.unmodifiableMap(this._parsedProperties);
    }

    void setFirewallRuleFactory(FirewallRuleFactory firewallRuleFactory) {
        this._firewallRuleFactory = firewallRuleFactory;
    }
}

