/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.SocketAddress;
import java.security.AccessControlContext;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.Deletable;
import org.apache.qpid.server.virtualhost.ConnectionPrincipalStatistics;

public interface AMQPConnection<C extends AMQPConnection<C>>
extends Connection<C>,
Deletable<C>,
EventLoggerProvider {
    public Broker<?> getBroker();

    public long getConnectionId();

    public AccessControlContext getAccessControlContextFromSubject(Subject var1);

    public Subject getSubject();

    public int getMessageCompressionThreshold();

    public Principal getAuthorizedPrincipal();

    public String getRemoteAddressString();

    public String getAddressSpaceName();

    public void notifyWork();

    public String getRemoteContainerName();

    public boolean isConnectionStopped();

    public void registerMessageReceived(long var1);

    public void registerMessageDelivered(long var1);

    public void registerTransactedMessageReceived();

    public void registerTransactedMessageDelivered();

    public void closeSessionAsync(AMQPSession<?, ?> var1, CloseReason var2, String var3);

    public SocketAddress getRemoteSocketAddress();

    public void block();

    public void unblock();

    public void updateLastMessageInboundTime();

    public void updateLastMessageOutboundTime();

    public void pushScheduler(NetworkConnectionScheduler var1);

    public NetworkConnectionScheduler popScheduler();

    public boolean hasSessionWithName(byte[] var1);

    public AggregateTicker getAggregateTicker();

    public LocalTransaction createLocalTransaction();

    public void incrementTransactionRollbackCounter();

    public void decrementTransactionOpenCounter();

    public void incrementTransactionOpenCounter();

    public void incrementTransactionBeginCounter();

    public Iterator<ServerTransaction> getOpenTransactions();

    public void registerTransactionTickers(ServerTransaction var1, Action<String> var2, long var3);

    public void unregisterTransactionTickers(ServerTransaction var1);

    public void sendConnectionCloseAsync(CloseReason var1, String var2);

    public boolean isIOThread();

    public ListenableFuture<Void> doOnIOThreadAsync(Runnable var1);

    public void checkAuthorizedMessagePrincipal(String var1);

    public void stopConnection();

    public Collection<? extends AMQPSession<?, ?>> getSessionModels();

    public void notifyWork(AMQPSession<?, ?> var1);

    public boolean isTransportBlockedForWriting();

    public boolean isClosing();

    public long getMaxMessageSize();

    @Override
    public AmqpPort<?> getPort();

    public void registered(ConnectionPrincipalStatistics var1);

    public int getAuthenticatedPrincipalConnectionCount();

    public int getAuthenticatedPrincipalConnectionFrequency();

    public static enum CloseReason {
        MANAGEMENT,
        TRANSACTION_TIMEOUT;

    }
}

