/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.ContainerType;
import org.apache.qpid.server.model.DynamicModel;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.AbstractJsonFileStore;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordConverter;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileConfigStore
extends AbstractJsonFileStore
implements DurableConfigurationStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonFileConfigStore.class);
    private static final Comparator<Class<? extends ConfiguredObject>> CATEGORY_CLASS_COMPARATOR = new Comparator<Class<? extends ConfiguredObject>>(){

        @Override
        public int compare(Class<? extends ConfiguredObject> left, Class<? extends ConfiguredObject> right) {
            return left.getSimpleName().compareTo(right.getSimpleName());
        }
    };
    private static final Comparator<ConfiguredObjectRecord> CONFIGURED_OBJECT_RECORD_COMPARATOR = new Comparator<ConfiguredObjectRecord>(){

        @Override
        public int compare(ConfiguredObjectRecord left, ConfiguredObjectRecord right) {
            String leftName = (String)left.getAttributes().get("name");
            String rightName = (String)right.getAttributes().get("name");
            return leftName.compareTo(rightName);
        }
    };
    private final Map<UUID, ConfiguredObjectRecord> _objectsById = new HashMap<UUID, ConfiguredObjectRecord>();
    private final Map<String, List<UUID>> _idsByType = new HashMap<String, List<UUID>>();
    private volatile Class<? extends ConfiguredObject> _rootClass;
    private final ObjectMapper _objectMapper;
    private volatile Map<String, Class<? extends ConfiguredObject>> _classNameMapping;
    private ConfiguredObject<?> _parent;
    private State _state = State.CLOSED;
    private final Object _lock = new Object();

    public JsonFileConfigStore(Class<? extends ConfiguredObject> rootClass) {
        this._objectMapper = ConfiguredObjectJacksonModule.newObjectMapper(true).enable(SerializationFeature.INDENT_OUTPUT);
        this._rootClass = rootClass;
    }

    @Override
    public void upgradeStoreStructure() throws StoreException {
    }

    @Override
    public void init(ConfiguredObject<?> parent) {
        this.assertState(State.CLOSED);
        this._parent = parent;
        this._classNameMapping = JsonFileConfigStore.generateClassNameMap(this._parent.getModel(), this._rootClass);
        FileBasedSettings fileBasedSettings = (FileBasedSettings)((Object)this._parent);
        this.setup(parent.getName(), fileBasedSettings.getStorePath(), parent.getContextValue(String.class, "qpid.default_posix_file_permissions"), Collections.emptyMap());
        this.changeState(State.CLOSED, State.CONFIGURED);
    }

    @Override
    public boolean openConfigurationStore(ConfiguredObjectRecordHandler handler, ConfiguredObjectRecord ... initialRecords) {
        this.changeState(State.CONFIGURED, State.OPEN);
        boolean isNew = this.load(initialRecords);
        ArrayList<ConfiguredObjectRecord> records = new ArrayList<ConfiguredObjectRecord>(this._objectsById.values());
        for (ConfiguredObjectRecord record : records) {
            handler.handle(record);
        }
        return isNew;
    }

    @Override
    public void reload(ConfiguredObjectRecordHandler handler) {
        this.assertState(State.OPEN);
        this._idsByType.clear();
        this._objectsById.clear();
        this.load(new ConfiguredObjectRecord[0]);
        ArrayList<ConfiguredObjectRecord> records = new ArrayList<ConfiguredObjectRecord>(this._objectsById.values());
        for (ConfiguredObjectRecord record : records) {
            handler.handle(record);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean load(ConfiguredObjectRecord ... initialRecords) {
        File configFile = this.getConfigFile();
        try {
            LOGGER.debug("Loading file {}", (Object)configFile.getCanonicalPath());
            boolean updated = false;
            Collection<Object> records = Collections.emptyList();
            ConfiguredObjectRecordConverter configuredObjectRecordConverter = new ConfiguredObjectRecordConverter(this._parent.getModel());
            records = configuredObjectRecordConverter.readFromJson(this._rootClass, this._parent, new FileReader(configFile));
            if (this._rootClass == null) {
                this._rootClass = configuredObjectRecordConverter.getRootClass();
                this._classNameMapping = JsonFileConfigStore.generateClassNameMap(configuredObjectRecordConverter.getModel(), this._rootClass);
            }
            if (records.isEmpty()) {
                LOGGER.debug("File contains no records - using initial configuration");
                records = Arrays.asList(initialRecords);
                updated = true;
                if (this._rootClass == null) {
                    QpidServiceLoader loader;
                    ContainerType containerType;
                    void var7_10;
                    String containerTypeName = ((DynamicModel)((Object)this._parent)).getDefaultContainerType();
                    Object var7_8 = null;
                    for (ConfiguredObjectRecord configuredObjectRecord : records) {
                        if (configuredObjectRecord.getParents() != null && !configuredObjectRecord.getParents().isEmpty()) continue;
                        ConfiguredObjectRecord configuredObjectRecord2 = configuredObjectRecord;
                        break;
                    }
                    if (var7_10 != null && var7_10.getAttributes().get("type") instanceof String) {
                        containerTypeName = var7_10.getAttributes().get("type").toString();
                    }
                    if ((containerType = (loader = new QpidServiceLoader()).getInstancesByType(ContainerType.class).get(containerTypeName)) != null) {
                        this._rootClass = containerType.getCategoryClass();
                        this._classNameMapping = JsonFileConfigStore.generateClassNameMap(containerType.getModel(), containerType.getCategoryClass());
                    }
                }
            }
            for (ConfiguredObjectRecord configuredObjectRecord : records) {
                LOGGER.debug("Loading record (Category: {} \t Name: {} \t ID: {}", new Object[]{configuredObjectRecord.getType(), configuredObjectRecord.getAttributes().get("name"), configuredObjectRecord.getId()});
                this._objectsById.put(configuredObjectRecord.getId(), configuredObjectRecord);
                List<UUID> idsForType = this._idsByType.get(configuredObjectRecord.getType());
                if (idsForType == null) {
                    idsForType = new ArrayList<UUID>();
                    this._idsByType.put(configuredObjectRecord.getType(), idsForType);
                }
                if (idsForType.contains(configuredObjectRecord.getId())) {
                    throw new IllegalArgumentException("Duplicate id for record " + configuredObjectRecord);
                }
                idsForType.add(configuredObjectRecord.getId());
            }
            if (updated) {
                this.save();
            }
            return updated;
        }
        catch (IOException e) {
            throw new StoreException("Cannot construct configuration from the configuration file " + configFile, e);
        }
    }

    @Override
    public synchronized void create(ConfiguredObjectRecord record) throws StoreException {
        this.assertState(State.OPEN);
        if (this._objectsById.containsKey(record.getId())) {
            throw new StoreException("Object with id " + record.getId() + " already exists");
        }
        if (!this._classNameMapping.containsKey(record.getType())) {
            throw new StoreException("Cannot create object of unknown type " + record.getType());
        }
        if (record.getAttributes() == null || !(record.getAttributes().get("name") instanceof String)) {
            throw new StoreException("The record " + record.getId() + " of type " + record.getType() + " does not have an attribute '" + "name" + "' of type String");
        }
        record = new ConfiguredObjectRecordImpl(record);
        this._objectsById.put(record.getId(), record);
        List<UUID> idsForType = this._idsByType.get(record.getType());
        if (idsForType == null) {
            idsForType = new ArrayList<UUID>();
            this._idsByType.put(record.getType(), idsForType);
        }
        if (this._rootClass.getSimpleName().equals(record.getType()) && idsForType.size() > 0) {
            throw new IllegalStateException("Only a single root entry of type " + this._rootClass.getSimpleName() + " can exist in the store.");
        }
        if (idsForType.contains(record.getId())) {
            throw new IllegalArgumentException("Duplicate id for record " + record);
        }
        idsForType.add(record.getId());
        this.save();
    }

    private UUID getRootId() {
        List<UUID> ids = this._idsByType.get(this._rootClass.getSimpleName());
        if (ids == null) {
            return null;
        }
        if (ids.size() == 0) {
            return null;
        }
        return ids.get(0);
    }

    private void save() {
        UUID rootId = this.getRootId();
        Map<Object, Object> data = rootId == null ? Collections.emptyMap() : this.build(this._rootClass, rootId, this.createChildMap());
        this.save(data);
    }

    private Map<UUID, Map<String, SortedSet<ConfiguredObjectRecord>>> createChildMap() {
        Model model = this._parent.getModel();
        HashMap<UUID, Map<String, SortedSet<ConfiguredObjectRecord>>> map = new HashMap<UUID, Map<String, SortedSet<ConfiguredObjectRecord>>>();
        for (ConfiguredObjectRecord record : this._objectsById.values()) {
            TreeSet<ConfiguredObjectRecord> children;
            Class<? extends ConfiguredObject> parentType;
            int parentCount = record.getParents().size();
            if (parentCount == 0 || (parentType = model.getParentType(this._classNameMapping.get(record.getType()))) == null) continue;
            String parentCategoryName = parentType.getSimpleName();
            UUID parentId = record.getParents().get(parentCategoryName);
            if (parentId == null) continue;
            TreeMap<String, TreeSet<ConfiguredObjectRecord>> childMap = (TreeMap<String, TreeSet<ConfiguredObjectRecord>>)map.get(parentId);
            if (childMap == null) {
                childMap = new TreeMap<String, TreeSet<ConfiguredObjectRecord>>();
                map.put(parentId, childMap);
            }
            if ((children = (TreeSet<ConfiguredObjectRecord>)childMap.get(record.getType())) == null) {
                children = new TreeSet<ConfiguredObjectRecord>(CONFIGURED_OBJECT_RECORD_COMPARATOR);
                childMap.put(record.getType(), children);
            }
            children.add(record);
        }
        return map;
    }

    private Map<String, Object> build(Class<? extends ConfiguredObject> type, UUID id, Map<UUID, Map<String, SortedSet<ConfiguredObjectRecord>>> childMap) {
        ConfiguredObjectRecord record = this._objectsById.get(id);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", id);
        map.putAll(record.getAttributes());
        ArrayList<Class<? extends ConfiguredObject>> childClasses = new ArrayList<Class<? extends ConfiguredObject>>(this._parent.getModel().getChildTypes(type));
        Collections.sort(childClasses, CATEGORY_CLASS_COMPARATOR);
        Map<String, SortedSet<ConfiguredObjectRecord>> allChildren = childMap.get(id);
        if (allChildren != null && !allChildren.isEmpty()) {
            for (Map.Entry<String, SortedSet<ConfiguredObjectRecord>> entry : allChildren.entrySet()) {
                String singularName = entry.getKey().toLowerCase();
                String attrName = singularName + (singularName.endsWith("s") ? "es" : "s");
                SortedSet<ConfiguredObjectRecord> sortedChildren = entry.getValue();
                ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
                for (ConfiguredObjectRecord childRecord : sortedChildren) {
                    entities.add(this.build(this._classNameMapping.get(entry.getKey()), childRecord.getId(), childMap));
                }
                if (entities.isEmpty()) continue;
                map.put(attrName, entities);
            }
        }
        return map;
    }

    @Override
    public synchronized UUID[] remove(ConfiguredObjectRecord ... objects) throws StoreException {
        this.assertState(State.OPEN);
        if (objects.length == 0) {
            return new UUID[0];
        }
        ArrayList<UUID> removedIds = new ArrayList<UUID>();
        for (ConfiguredObjectRecord requestedRecord : objects) {
            ConfiguredObjectRecord record = this._objectsById.remove(requestedRecord.getId());
            if (record == null) continue;
            removedIds.add(record.getId());
            this._idsByType.get(record.getType()).remove(record.getId());
        }
        this.save();
        return removedIds.toArray(new UUID[removedIds.size()]);
    }

    @Override
    public synchronized void update(boolean createIfNecessary, ConfiguredObjectRecord ... records) throws StoreException {
        String type;
        UUID id;
        this.assertState(State.OPEN);
        if (records.length == 0) {
            return;
        }
        for (ConfiguredObjectRecord record : records) {
            id = record.getId();
            type = record.getType();
            if (record.getAttributes() == null || !(record.getAttributes().get("name") instanceof String)) {
                throw new StoreException("The record " + id + " of type " + type + " does not have an attribute '" + "name" + "' of type String");
            }
            if (this._objectsById.containsKey(id)) {
                ConfiguredObjectRecord existingRecord = this._objectsById.get(id);
                if (type.equals(existingRecord.getType())) continue;
                throw new StoreException("Cannot change the type of record " + id + " from type " + existingRecord.getType() + " to type " + type);
            }
            if (!createIfNecessary) {
                throw new StoreException("Cannot update record with id " + id + " of type " + type + " as it does not exist");
            }
            if (this._classNameMapping.containsKey(type)) continue;
            throw new StoreException("Cannot update record of unknown type " + type);
        }
        for (ConfiguredObjectRecord record : records) {
            record = new ConfiguredObjectRecordImpl(record);
            id = record.getId();
            type = record.getType();
            if (this._objectsById.put(id, record) != null) continue;
            List<UUID> idsForType = this._idsByType.get(type);
            if (idsForType == null) {
                idsForType = new ArrayList<UUID>();
                this._idsByType.put(type, idsForType);
            }
            if (idsForType.contains(record.getId())) {
                throw new IllegalArgumentException("Duplicate id for record " + record);
            }
            idsForType.add(id);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConfigurationStore() {
        try {
            this.cleanup();
        }
        finally {
            this._idsByType.clear();
            this._objectsById.clear();
            Object object = this._lock;
            synchronized (object) {
                this._state = State.CLOSED;
            }
        }
    }

    @Override
    public void onDelete(ConfiguredObject<?> parent) {
        FileBasedSettings fileBasedSettings = (FileBasedSettings)((Object)parent);
        this.delete(fileBasedSettings.getStorePath());
    }

    private static Map<String, Class<? extends ConfiguredObject>> generateClassNameMap(Model model, Class<? extends ConfiguredObject> clazz) {
        HashMap<String, Class<? extends ConfiguredObject>> map = new HashMap<String, Class<? extends ConfiguredObject>>();
        if (clazz != null) {
            map.put(clazz.getSimpleName(), clazz);
            Collection<Class<? extends ConfiguredObject>> childClasses = model.getChildTypes(clazz);
            if (childClasses != null) {
                for (Class<? extends ConfiguredObject> childClass : childClasses) {
                    map.putAll(JsonFileConfigStore.generateClassNameMap(model, childClass));
                }
            }
        }
        return map;
    }

    @Override
    protected ObjectMapper getSerialisationObjectMapper() {
        return this._objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertState(State state) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != state) {
                throw new IllegalStateException("The store must be in state " + (Object)((Object)state) + " to perform this operation, but it is in state " + (Object)((Object)this._state) + " instead");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State oldState, State newState) {
        Object object = this._lock;
        synchronized (object) {
            this.assertState(oldState);
            this._state = newState;
        }
    }

    private static enum State {
        CLOSED,
        CONFIGURED,
        OPEN;

    }
}

