/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.oauth2.microsoftlive;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.oauth2.IdentityResolverException;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2AuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2IdentityResolverService;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2Utils;
import org.apache.qpid.server.util.ConnectionBuilder;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class MicrosoftLiveOAuth2IdentityResolverService
implements OAuth2IdentityResolverService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrosoftLiveOAuth2IdentityResolverService.class);
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    public static final String TYPE = "MicrosoftLive";
    private final ObjectMapper _objectMapper = new ObjectMapper();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate(OAuth2AuthenticationProvider<?> authProvider) throws IllegalConfigurationException {
    }

    @Override
    public Principal getUserPrincipal(OAuth2AuthenticationProvider<?> authenticationProvider, String accessToken, NamedAddressSpace addressSpace) throws IOException, IdentityResolverException {
        URL userInfoEndpoint = authenticationProvider.getIdentityResolverEndpointURI(addressSpace).toURL();
        TrustStore trustStore = authenticationProvider.getTrustStore();
        ConnectionBuilder connectionBuilder = new ConnectionBuilder(userInfoEndpoint);
        connectionBuilder.setConnectTimeout(authenticationProvider.getConnectTimeout()).setReadTimeout(authenticationProvider.getReadTimeout());
        if (trustStore != null) {
            try {
                connectionBuilder.setTrustMangers(trustStore.getTrustManagers());
            }
            catch (GeneralSecurityException e) {
                throw new ServerScopedRuntimeException("Cannot initialise TLS", e);
            }
        }
        connectionBuilder.setTlsProtocolWhiteList(authenticationProvider.getTlsProtocolWhiteList()).setTlsProtocolBlackList(authenticationProvider.getTlsProtocolBlackList()).setTlsCipherSuiteWhiteList(authenticationProvider.getTlsCipherSuiteWhiteList()).setTlsCipherSuiteBlackList(authenticationProvider.getTlsCipherSuiteBlackList());
        LOGGER.debug("About to call identity service '{}'", (Object)userInfoEndpoint);
        HttpURLConnection connection = connectionBuilder.build();
        connection.setRequestProperty("Accept-Charset", UTF8);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Authorization", "Bearer " + accessToken);
        connection.connect();
        try (InputStream input = OAuth2Utils.getResponseStream(connection);){
            Map responseMap;
            int responseCode = connection.getResponseCode();
            LOGGER.debug("Call to identity service '{}' complete, response code : {}", (Object)userInfoEndpoint, (Object)responseCode);
            try {
                responseMap = (Map)this._objectMapper.readValue(input, Map.class);
            }
            catch (JsonProcessingException e) {
                throw new IOException(String.format("Identity resolver '%s' did not return json", userInfoEndpoint), e);
            }
            if (responseCode != 200) {
                throw new IdentityResolverException(String.format("Identity resolver '%s' failed, response code %d", userInfoEndpoint, responseCode));
            }
            String liveId = (String)responseMap.get("id");
            if (liveId == null) {
                throw new IdentityResolverException(String.format("Identity resolver '%s' failed, response did not include 'id'", userInfoEndpoint));
            }
            UsernamePrincipal usernamePrincipal = new UsernamePrincipal(liveId, authenticationProvider);
            return usernamePrincipal;
        }
    }

    @Override
    public URI getDefaultAuthorizationEndpointURI(OAuth2AuthenticationProvider<?> oAuth2AuthenticationProvider) {
        try {
            return new URI("https://login.live.com/oauth20_authorize.srf");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public URI getDefaultTokenEndpointURI(OAuth2AuthenticationProvider<?> oAuth2AuthenticationProvider) {
        try {
            return new URI("https://login.live.com/oauth20_token.srf");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public URI getDefaultIdentityResolverEndpointURI(OAuth2AuthenticationProvider<?> oAuth2AuthenticationProvider) {
        try {
            return new URI("https://apis.live.net/v5.0/me");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String getDefaultScope(OAuth2AuthenticationProvider<?> oAuth2AuthenticationProvider) {
        return "wl.basic";
    }
}

