/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.filter.selector.ParseException;
import org.apache.qpid.server.filter.selector.TokenMgrError;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.messages.QueueMessages;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.ServerMessageMutator;
import org.apache.qpid.server.message.ServerMessageMutatorFactory;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.queue.OutOfOrderQueue;
import org.apache.qpid.server.queue.PriorityQueue;
import org.apache.qpid.server.queue.PriorityQueueList;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public class PriorityQueueImpl
extends OutOfOrderQueue<PriorityQueueImpl>
implements PriorityQueue<PriorityQueueImpl> {
    private PriorityQueueList _entries;
    @ManagedAttributeField
    private int _priorities;

    @ManagedObjectFactoryConstructor
    public PriorityQueueImpl(Map<String, Object> attributes, QueueManagingVirtualHost<?> virtualHost) {
        super(attributes, virtualHost);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._entries = PriorityQueueList.newInstance(this);
    }

    @Override
    public int getPriorities() {
        return this._priorities;
    }

    @Override
    PriorityQueueList getEntries() {
        return this._entries;
    }

    @Override
    protected LogMessage getCreatedLogMessage() {
        String ownerString = this.getOwner();
        return QueueMessages.CREATED(this.getId().toString(), ownerString, this.getPriorities(), ownerString != null, this.getLifetimePolicy() != LifetimePolicy.PERMANENT, this.isDurable(), !this.isDurable(), true);
    }

    @Override
    public long reenqueueMessageForPriorityChange(long messageId, int newPriority) {
        ServerMessage message;
        QueueEntry entry = this.getMessageOnTheQueue(messageId);
        if (entry != null && (message = entry.getMessage()) != null && message.getMessageHeader().getPriority() != newPriority && entry.acquire()) {
            MessageStore store = this.getVirtualHost().getMessageStore();
            LocalTransaction txn = new LocalTransaction(store);
            long newMessageId = this.reenqueueEntryWithPriority(entry, txn, (byte)newPriority);
            txn.commit();
            return newMessageId;
        }
        return -1L;
    }

    @Override
    public List<Long> reenqueueMessagesForPriorityChange(String selector, int newPriority) {
        JMSSelectorFilter filter;
        try {
            filter = selector == null ? null : new JMSSelectorFilter(selector);
        }
        catch (SelectorParsingException | ParseException | TokenMgrError e) {
            throw new IllegalArgumentException("Cannot parse selector \"" + selector + "\"", e);
        }
        List<Long> messageIds = this.reenqueueEntriesForPriorityChange(entry -> filter == null || filter.matches(entry.asFilterable()), newPriority);
        return Collections.unmodifiableList(messageIds);
    }

    private List<Long> reenqueueEntriesForPriorityChange(Predicate<QueueEntry> condition, int newPriority) {
        Predicate<QueueEntry> isNotNullMessageAndPriorityDiffers = entry -> {
            ServerMessage message = entry.getMessage();
            return message != null && message.getMessageHeader().getPriority() != newPriority;
        };
        return this.handleMessagesWithinStoreTransaction(isNotNullMessageAndPriorityDiffers.and(condition), (txn, entry) -> this.reenqueueEntryWithPriority((QueueEntry)entry, (ServerTransaction)txn, (byte)newPriority));
    }

    private long reenqueueEntryWithPriority(final QueueEntry entry, ServerTransaction txn, byte newPriority) {
        txn.dequeue(entry.getEnqueueRecord(), new ServerTransaction.Action(){

            @Override
            public void postCommit() {
                entry.delete();
            }

            @Override
            public void onRollback() {
                entry.release();
            }
        });
        final ServerMessage newMessage = this.createMessageWithPriority(entry.getMessage(), newPriority);
        txn.enqueue(this, (EnqueueableMessage)newMessage, new ServerTransaction.EnqueueAction(){

            @Override
            public void postCommit(MessageEnqueueRecord ... records) {
                PriorityQueueImpl.this.enqueue(newMessage, null, records[0]);
            }

            @Override
            public void onRollback() {
            }
        });
        return newMessage.getMessageNumber();
    }

    private List<Long> handleMessagesWithinStoreTransaction(Predicate<QueueEntry> entryMatchCondition, BiFunction<ServerTransaction, QueueEntry, Long> handle) {
        MessageStore store = this.getVirtualHost().getMessageStore();
        LocalTransaction txn = new LocalTransaction(store);
        ArrayList<Long> result = new ArrayList<Long>();
        this.visit(entry -> {
            if (entryMatchCondition.test(entry) && entry.acquire()) {
                result.add((Long)handle.apply(txn, entry));
            }
            return false;
        });
        txn.commit();
        return result;
    }

    private ServerMessage createMessageWithPriority(ServerMessage message, byte newPriority) {
        ServerMessageMutator<ServerMessage> messageMutator = ServerMessageMutatorFactory.createMutator(message, this.getVirtualHost().getMessageStore());
        messageMutator.setPriority(newPriority);
        return messageMutator.create();
    }
}

