/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.message.MessageInfo;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.LastValueQueueImpl;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

final class LastValueQueueImplWithAccessChecking
extends LastValueQueueImpl {
    private static final FixedKeyMapCreator MOVE_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("destination", "messageIds", "selector", "limit");
    private static final FixedKeyMapCreator COPY_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("destination", "messageIds", "selector", "limit");
    private static final FixedKeyMapCreator DELETE_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("messageIds", "selector", "limit");
    private static final FixedKeyMapCreator GET_MESSAGE_CONTENT_MAP_CREATOR = new FixedKeyMapCreator("messageId", "limit", "returnJson", "decompressBeforeLimiting");
    private static final FixedKeyMapCreator GET_MESSAGE_INFO_MAP_CREATOR = new FixedKeyMapCreator("first", "last", "includeHeaders");
    private static final FixedKeyMapCreator GET_MESSAGE_INFO_BY_ID_MAP_CREATOR = new FixedKeyMapCreator("messageId", "includeHeaders");

    LastValueQueueImplWithAccessChecking(Map<String, Object> attributes, QueueManagingVirtualHost<?> queuemanagingvirtualhost) {
        super(attributes, queuemanagingvirtualhost);
    }

    @Override
    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    @Override
    public String setContextVariable(final String name, final String value) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)LastValueQueueImplWithAccessChecking.super.setContextVariable(name, value));
            }

            @Override
            public String getObject() {
                return LastValueQueueImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "setContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    @Override
    public String removeContextVariable(final String name) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)LastValueQueueImplWithAccessChecking.super.removeContextVariable(name));
            }

            @Override
            public String getObject() {
                return LastValueQueueImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public Collection<PublishingLink> getPublishingLinks() {
        return super.getPublishingLinks();
    }

    @Override
    public Collection<QueueConsumer<?, ?>> getConsumers() {
        return super.getConsumers();
    }

    @Override
    public List<Long> moveMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.INVOKE_METHOD("moveMessages"), MOVE_MESSAGES_MAP_CREATOR.createMap(destination, messageIds, selector, limit));
        return super.moveMessages(destination, messageIds, selector, limit);
    }

    @Override
    public List<Long> copyMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.INVOKE_METHOD("copyMessages"), COPY_MESSAGES_MAP_CREATOR.createMap(destination, messageIds, selector, limit));
        return super.copyMessages(destination, messageIds, selector, limit);
    }

    @Override
    public List<Long> deleteMessages(List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.INVOKE_METHOD("deleteMessages"), DELETE_MESSAGES_MAP_CREATOR.createMap(messageIds, selector, limit));
        return super.deleteMessages(messageIds, selector, limit);
    }

    @Override
    public long clearQueue() {
        this.authorise(Operation.INVOKE_METHOD("clearQueue"));
        return super.clearQueue();
    }

    @Override
    public Content getMessageContent(long messageId, long limit, boolean returnJson, boolean decompressBeforeLimiting) {
        this.authorise(Operation.INVOKE_METHOD("getMessageContent"), GET_MESSAGE_CONTENT_MAP_CREATOR.createMap(messageId, limit, returnJson, decompressBeforeLimiting));
        return super.getMessageContent(messageId, limit, returnJson, decompressBeforeLimiting);
    }

    @Override
    public List<MessageInfo> getMessageInfo(int first, int last, boolean includeHeaders) {
        this.authorise(Operation.INVOKE_METHOD("getMessageInfo"), GET_MESSAGE_INFO_MAP_CREATOR.createMap(first, last, includeHeaders));
        return super.getMessageInfo(first, last, includeHeaders);
    }

    @Override
    public MessageInfo getMessageInfoById(long messageId, boolean includeHeaders) {
        this.authorise(Operation.INVOKE_METHOD("getMessageInfoById"), GET_MESSAGE_INFO_BY_ID_MAP_CREATOR.createMap(messageId, includeHeaders));
        return super.getMessageInfoById(messageId, includeHeaders);
    }
}

