/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.net.SocketAddress;
import java.util.List;
import java.util.Set;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPortImpl;
import org.apache.qpid.server.plugin.ConnectionPropertyEnricher;

@ManagedObject(category=false, type="AMQP", amqpName="org.apache.qpid.AmqpPort")
public interface AmqpPort<X extends AmqpPort<X>>
extends Port<X> {
    public static final String DEFAULT_AMQP_TCP_NO_DELAY = "true";
    public static final String DEFAULT_AMQP_NEED_CLIENT_AUTH = "false";
    public static final String DEFAULT_AMQP_WANT_CLIENT_AUTH = "false";
    public static final String MAX_OPEN_CONNECTIONS = "maxOpenConnections";
    public static final String THREAD_POOL_SIZE = "threadPoolSize";
    public static final String NUMBER_OF_SELECTORS = "numberOfSelectors";
    public static final String DEFAULT_AMQP_PROTOCOLS = "qpid.port.default_amqp_protocols";
    public static final String PORT_AMQP_THREAD_POOL_SIZE = "qpid.port.amqp.threadPool.size";
    public static final String PORT_AMQP_THREAD_POOL_KEEP_ALIVE_TIMEOUT = "qpid.port.amqp.threadPool.keep_alive_timeout";
    public static final String PORT_AMQP_NUMBER_OF_SELECTORS = "qpid.port.amqp.threadPool.numberOfSelectors";
    public static final String PORT_AMQP_ACCEPT_BACKLOG = "qpid.port.amqp.acceptBacklog";
    @ManagedContextDefault(name="qpid.port.default_amqp_protocols")
    public static final String INSTALLED_PROTOCOLS = AmqpPortImpl.getInstalledProtocolsAsString();
    public static final String PORT_MAX_OPEN_CONNECTIONS = "qpid.port.max_open_connections";
    @ManagedContextDefault(name="qpid.port.max_open_connections")
    public static final int DEFAULT_MAX_OPEN_CONNECTIONS = -1;
    public static final String PORT_IGNORE_INVALID_SNI = "qpid.port.amqp.ignoreInvalidSni";
    @ManagedContextDefault(name="qpid.port.amqp.ignoreInvalidSni")
    public static final boolean DEFAULT_PORT_IGNORE_INVALID_SNI = false;
    @ManagedContextDefault(name="qpid.port.amqp.threadPool.size")
    public static final long DEFAULT_PORT_AMQP_THREAD_POOL_SIZE = 8L;
    @ManagedContextDefault(name="qpid.port.amqp.threadPool.keep_alive_timeout")
    public static final long DEFAULT_PORT_AMQP_THREAD_POOL_KEEP_ALIVE_TIMEOUT = 60L;
    @ManagedContextDefault(name="qpid.port.amqp.threadPool.numberOfSelectors")
    public static final long DEFAULT_PORT_AMQP_NUMBER_OF_SELECTORS = Math.max(1L, 1L);
    @ManagedContextDefault(name="qpid.port.amqp.acceptBacklog")
    public static final int DEFAULT_PORT_AMQP_ACCEPT_BACKLOG = 1024;
    public static final String OPEN_CONNECTIONS_WARN_PERCENT = "qpid.port.open_connections_warn_percent";
    @ManagedContextDefault(name="qpid.port.open_connections_warn_percent")
    public static final int DEFAULT_OPEN_CONNECTIONS_WARN_PERCENT = 80;
    public static final String PROTOCOL_HANDSHAKE_TIMEOUT = "qpid.port.protocol_handshake_timeout";
    @ManagedContextDefault(name="qpid.port.protocol_handshake_timeout", description="Maximum time allowed for a new connection to send a protocol header. If the connection does not send a protocol header within this time, the connection will be aborted.")
    public static final long DEFAULT_PROTOCOL_HANDSHAKE_TIMEOUT = 2000L;
    public static final String PROPERTY_DEFAULT_SUPPORTED_PROTOCOL_REPLY = "qpid.broker_default_supported_protocol_version_reply";
    public static final String CLOSE_WHEN_NO_ROUTE = "qpid.port.closeWhenNoRoute";
    @ManagedContextDefault(name="qpid.port.closeWhenNoRoute")
    public static final boolean DEFAULT_CONNECTION_CLOSE_WHEN_NO_ROUTE = true;
    public static final String SESSION_COUNT_LIMIT = "qpid.port.sessionCountLimit";
    @ManagedContextDefault(name="qpid.port.sessionCountLimit")
    public static final int DEFAULT_SESSION_COUNT_LIMIT = 256;
    public static final String HEART_BEAT_DELAY = "qpid.port.heartbeatDelay";
    @ManagedContextDefault(name="qpid.port.heartbeatDelay")
    public static final int DEFAULT_HEART_BEAT_DELAY = 0;
    public static final String TLS_SESSION_TIMEOUT = "qpid.port.amqp.tlsSessionTimeout";
    @ManagedContextDefault(name="qpid.port.amqp.tlsSessionTimeout", description="TLS session timeout for AMQP ports (seconds).")
    public static final int DEFAULT_TLS_SESSION_TIMEOUT = 300;
    public static final String TLS_SESSION_CACHE_SIZE = "qpid.port.amqp.tlsSessionCacheSize";
    @ManagedContextDefault(name="qpid.port.amqp.tlsSessionCacheSize", description="TLS session cache size for AMQP ports.")
    public static final int DEFAULT_TLS_SESSION_CACHE_SIZE = 100;
    public static final String CONNECTION_PROPERTY_ENRICHERS = "qpid.port.connection_property_enrichers";
    @ManagedContextDefault(name="qpid.port.connection_property_enrichers", description="The connection property enrichers to apply to connections created on this port.")
    public static final String DEFAULT_CONNECTION_PROTOCOL_ENRICHERS = "[ \"STANDARD\" ] ";

    @ManagedAttribute(defaultValue="true")
    public boolean isTcpNoDelay();

    @ManagedAttribute(defaultValue="${qpid.port.amqp.threadPool.size}")
    public int getThreadPoolSize();

    @ManagedAttribute(defaultValue="${qpid.port.amqp.threadPool.numberOfSelectors}")
    public int getNumberOfSelectors();

    @Override
    @ManagedAttribute(defaultValue="false")
    public boolean getNeedClientAuth();

    @Override
    @ManagedAttribute(defaultValue="false")
    public boolean getWantClientAuth();

    @Override
    @ManagedAttribute(defaultValue="TCP", validValues={"org.apache.qpid.server.model.port.AmqpPortImpl#getAllAvailableTransportCombinations()"})
    public Set<Transport> getTransports();

    @Override
    @ManagedAttribute(defaultValue="${qpid.port.default_amqp_protocols}", validValues={"org.apache.qpid.server.model.port.AmqpPortImpl#getAllAvailableProtocolCombinations()"})
    public Set<Protocol> getProtocols();

    @ManagedAttribute(defaultValue="${qpid.port.max_open_connections}")
    public int getMaxOpenConnections();

    @DerivedAttribute
    public boolean isIgnoreInvalidSni();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Open Connections", description="Current number of connections made through this port", metricName="open_connections_total")
    public int getConnectionCount();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.COUNT, label="Total Connections", description="Total number of connections made through this port since broker startup", metricName="aggregate_connection_count")
    public long getTotalConnectionCount();

    @DerivedAttribute(description="Maximum time allowed for a new connection to send a protocol header. If the connection does not send a protocol header within this time, the connection will be aborted.")
    public long getProtocolHandshakeTimeout();

    @DerivedAttribute(description="Controls behaviour when the Broker receives a message for which no destination exists or is otherwise rejected by the destination. For AMQP 0-8..0-91 the connection will be closed only if transactionally publishing a message with the mandatory flag set and the Publisher Confirms extension is disabled. For 0-10, the session will be closed if publishing a message (without the discard unroutable flag).  In all other cases, this flag has no effect.")
    public boolean getCloseWhenNoRoute();

    @DerivedAttribute(description="The maximum number of sessions which can exist concurrently on a connection.")
    public int getSessionCountLimit();

    @DerivedAttribute(description="For AMQP 0-8..0-10 the default period with which Broker and client will exchange heartbeat messages (in seconds). Clients may negotiate a different heartbeat frequency or disable it altogether. For AMQP 1.0 this setting controls the incoming idle timeout only.  A value of 0 disables.")
    public int getHeartbeatDelay();

    public boolean canAcceptNewConnection(SocketAddress var1);

    public int incrementConnectionCount();

    public int decrementConnectionCount();

    public int getNetworkBufferSize();

    public List<ConnectionPropertyEnricher> getConnectionPropertyEnrichers();
}

