/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectMethodAttributeOrStatistic;

public abstract class ConfiguredObjectMethodAttribute<C extends ConfiguredObject, T>
extends ConfiguredObjectMethodAttributeOrStatistic<C, T>
implements ConfiguredObjectAttribute<C, T> {
    ConfiguredObjectMethodAttribute(Class<C> clazz, Method getter) {
        super(getter);
        if (getter.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("ManagedAttribute annotation should only be added to no-arg getters");
        }
    }

    @Override
    public boolean isSecureValue(Object value) {
        if (this.isSecure()) {
            Pattern filter = this.getSecureValueFilter();
            if (filter == null) {
                return true;
            }
            return filter.matcher(String.valueOf(value)).matches();
        }
        return false;
    }
}

