/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectInjectedAttribute;
import org.apache.qpid.server.model.ConfiguredObjectInjectedAttributeOrStatistic;
import org.apache.qpid.server.model.InjectedAttributeStatisticOrOperation;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredDerivedInjectedAttribute<C extends ConfiguredObject, T>
extends ConfiguredObjectInjectedAttributeOrStatistic<C, T>
implements ConfiguredObjectInjectedAttribute<C, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredDerivedInjectedAttribute.class);
    private final Pattern _secureValuePattern;
    private final boolean _secure;
    private final boolean _persisted;
    private final boolean _oversized;
    private final String _oversizedAltText;
    private final String _description;
    private final Method _method;
    private final Object[] _staticParams;

    public ConfiguredDerivedInjectedAttribute(String name, Method method, Object[] staticParams, boolean secure, boolean persisted, String secureValueFilter, boolean oversized, String oversizedAltText, String description, InjectedAttributeStatisticOrOperation.TypeValidator typeValidator) {
        super(name, AttributeValueConverter.getTypeFromMethod(method), method.getGenericReturnType(), typeValidator);
        Object[] objectArray = this._staticParams = staticParams == null ? new Object[]{} : staticParams;
        if (method.getParameterTypes().length != 1 + this._staticParams.length || !ConfiguredObject.class.isAssignableFrom(method.getParameterTypes()[0]) || !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Injected derived attribute method must be static, and have an initial argument which inherits from ConfiguredObject");
        }
        this._method = method;
        method.setAccessible(true);
        Class<?>[] methodParamTypes = method.getParameterTypes();
        for (int i = 0; i < this._staticParams.length; ++i) {
            if (methodParamTypes[i + 1].isPrimitive() && this._staticParams[i] == null) {
                throw new IllegalArgumentException("Static parameter has null value, but the " + methodParamTypes[i + 1].getSimpleName() + " type is a primitive");
            }
            if (AttributeValueConverter.convertPrimitiveToBoxed(methodParamTypes[i + 1]).isAssignableFrom(this._staticParams[i].getClass())) continue;
            throw new IllegalArgumentException("Static parameter cannot be assigned value as it is of incompatible type");
        }
        this._secure = secure;
        this._persisted = persisted;
        this._oversized = oversized;
        this._oversizedAltText = oversizedAltText;
        this._description = description;
        this._secureValuePattern = secureValueFilter == null || "".equals(secureValueFilter) ? null : Pattern.compile(secureValueFilter);
    }

    @Override
    public boolean isAutomated() {
        return false;
    }

    @Override
    public boolean isDerived() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return this._secure;
    }

    @Override
    public boolean isPersisted() {
        return this._persisted;
    }

    @Override
    public boolean isOversized() {
        return this._oversized;
    }

    @Override
    public boolean updateAttributeDespiteUnchangedValue() {
        return false;
    }

    @Override
    public String getOversizedAltText() {
        return this._oversizedAltText;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public Pattern getSecureValueFilter() {
        return this._secureValuePattern;
    }

    @Override
    public boolean isSecureValue(Object value) {
        Pattern filter;
        return this.isSecure() && ((filter = this.getSecureValueFilter()) == null || filter.matcher(String.valueOf(value)).matches());
    }

    @Override
    public T getValue(C configuredObject) {
        try {
            Object[] params = new Object[1 + this._staticParams.length];
            params[0] = configuredObject;
            for (int i = 0; i < this._staticParams.length; ++i) {
                params[i + 1] = this._staticParams[i];
            }
            return (T)this._method.invoke(null, params);
        }
        catch (IllegalAccessException e) {
            throw new ServerScopedRuntimeException("Unable to get value for '" + this.getName() + "' from configured object of category " + configuredObject.getCategoryClass().getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new ServerScopedRuntimeException("Unable to get value for '" + this.getName() + "' from configured object of category " + configuredObject.getCategoryClass().getSimpleName(), e);
        }
    }
}

