/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessageMetaData;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

@PluggableService
public class InternalMessageMetaDataType
implements MessageMetaDataType<InternalMessageMetaData> {
    public static final int INTERNAL_ORDINAL = 255;
    public static final String TYPE = "INTERNAL";
    public static final InternalMessageMetaDataType INSTANCE = new InternalMessageMetaDataType();

    @Override
    public int ordinal() {
        return 255;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InternalMessageMetaData createMetaData(QpidByteBuffer buf) {
        try (ObjectInputStream is = new ObjectInputStream(buf.asInputStream());){
            int contentSize = is.readInt();
            InternalMessageHeader header = (InternalMessageHeader)is.readObject();
            InternalMessageMetaData internalMessageMetaData = new InternalMessageMetaData(true, header, contentSize);
            return internalMessageMetaData;
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException("Unexpected IO Exception on operation in memory", e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionScopedRuntimeException("Unexpected exception when reading meta data, check classpath", e);
        }
    }

    @Override
    public ServerMessage<InternalMessageMetaData> createMessage(StoredMessage<InternalMessageMetaData> msg) {
        return new InternalMessage(msg, null);
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

