/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessageMetaData;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

public class InternalMessage
extends AbstractServerMessageImpl<InternalMessage, InternalMessageMetaData> {
    private static final String NON_AMQP_MESSAGE = "Non-AMQP Message";
    private final Object _messageBody;
    private InternalMessageHeader _header;
    private String _initialRoutingAddress;
    private final String _destinationName;

    public InternalMessage(StoredMessage<InternalMessageMetaData> handle, InternalMessageHeader header, Object messageBody, String destinationName) {
        super(handle, null);
        this._initialRoutingAddress = "";
        this._header = header;
        this._messageBody = messageBody;
        this._destinationName = destinationName;
    }

    InternalMessage(StoredMessage<InternalMessageMetaData> msg, String destinationName) {
        block28: {
            super(msg, null);
            this._initialRoutingAddress = "";
            this._header = msg.getMetaData().getHeader();
            long contentSize = this.getSize();
            if (contentSize > 0L) {
                try (QpidByteBuffer buf = msg.getContent(0, (int)contentSize);
                     ObjectInputStream is = new ObjectInputStream(buf.asInputStream());){
                    this._messageBody = is.readObject();
                    break block28;
                }
                catch (IOException e) {
                    throw new ConnectionScopedRuntimeException("Unexpected IO Exception in operation in memory", e);
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectionScopedRuntimeException("Object message contained an object which could not be deserialized", e);
                }
            }
            this._messageBody = null;
        }
        this._destinationName = destinationName;
    }

    @Override
    public String getInitialRoutingAddress() {
        return this._initialRoutingAddress;
    }

    @Override
    public String getTo() {
        return this._destinationName;
    }

    @Override
    public InternalMessageHeader getMessageHeader() {
        return this._header;
    }

    @Override
    public long getExpiration() {
        return this._header.getExpiration();
    }

    @Override
    public String getMessageType() {
        return NON_AMQP_MESSAGE;
    }

    @Override
    public long getArrivalTime() {
        return this._header.getArrivalTime();
    }

    @Override
    public boolean isResourceAcceptable(TransactionLogResource resource) {
        return true;
    }

    public Object getMessageBody() {
        return this._messageBody;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InternalMessage createMessage(MessageStore store, AMQMessageHeader header, Serializable bodyObject, boolean persistent, String destinationName) {
        InternalMessageHeader internalHeader = header instanceof InternalMessageHeader ? (InternalMessageHeader)header : new InternalMessageHeader(header);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (ObjectOutputStream os = new ObjectOutputStream(bytesOut);){
            os.writeObject(bodyObject);
            os.close();
            byte[] bytes = bytesOut.toByteArray();
            InternalMessageMetaData metaData = InternalMessageMetaData.create(persistent, internalHeader, bytes.length);
            MessageHandle<InternalMessageMetaData> handle = store.addMessage(metaData);
            try (QpidByteBuffer wrap = QpidByteBuffer.wrap(bytes);){
                handle.addContent(wrap);
            }
            StoredMessage<InternalMessageMetaData> storedMessage = handle.allContentAdded();
            InternalMessage internalMessage = new InternalMessage(storedMessage, internalHeader, bodyObject, destinationName);
            return internalMessage;
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException("Unexpected IO Exception on operation in memory", e);
        }
    }

    public static InternalMessage createStringMessage(MessageStore store, AMQMessageHeader header, String messageBody) {
        return InternalMessage.createStringMessage(store, header, messageBody, false);
    }

    public static InternalMessage createStringMessage(MessageStore store, AMQMessageHeader header, String messageBody, boolean persistent) {
        return InternalMessage.createMessage(store, header, (Serializable)((Object)messageBody), persistent, null);
    }

    public static InternalMessage createMapMessage(MessageStore store, AMQMessageHeader header, Map<? extends Object, ? extends Object> messageBody) {
        return InternalMessage.createMessage(store, header, new LinkedHashMap<Object, Object>(messageBody), false, null);
    }

    public static InternalMessage createListMessage(MessageStore store, AMQMessageHeader header, List<? extends Object> messageBody) {
        return InternalMessage.createMessage(store, header, new ArrayList<Object>(messageBody), false, null);
    }

    public static InternalMessage createBytesMessage(MessageStore store, AMQMessageHeader header, byte[] messageBody) {
        return InternalMessage.createBytesMessage(store, header, messageBody, false);
    }

    public static InternalMessage createBytesMessage(MessageStore store, AMQMessageHeader header, byte[] messageBody, boolean persist) {
        return InternalMessage.createMessage(store, header, (Serializable)messageBody, persist, null);
    }

    public static InternalMessage convert(ServerMessage serverMessage, AMQMessageHeader header, Object messageBody) {
        long messageNumber = serverMessage.getMessageNumber();
        boolean persistent = serverMessage.isPersistent();
        String destinationName = serverMessage.getTo();
        InternalMessageHeader convertedHeader = new InternalMessageHeader(header, serverMessage.getArrivalTime());
        StoredMessage<InternalMessageMetaData> handle = InternalMessage.createReadOnlyHandle(messageNumber, persistent, convertedHeader, messageBody);
        InternalMessage internalMessage = new InternalMessage(handle, convertedHeader, messageBody, destinationName);
        internalMessage.setInitialRoutingAddress(serverMessage.getInitialRoutingAddress());
        return internalMessage;
    }

    /*
     * Exception decompiling
     */
    private static StoredMessage<InternalMessageMetaData> createReadOnlyHandle(long messageNumber, boolean persistent, InternalMessageHeader header, Object messageBody) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setInitialRoutingAddress(String initialRoutingAddress) {
        this._initialRoutingAddress = initialRoutingAddress == null ? "" : initialRoutingAddress;
    }
}

