/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.connection;

import java.net.SocketAddress;
import java.util.UUID;
import org.apache.qpid.server.connection.AmqpConnectionMetaData;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.security.auth.SocketConnectionPrincipal;
import org.apache.qpid.server.transport.AMQPConnection;

public class ConnectionPrincipal
implements SocketConnectionPrincipal {
    private static final long serialVersionUID = 1L;
    private final AMQPConnection<?> _connection;
    private AmqpConnectionMetaData _metadata;

    public ConnectionPrincipal(AMQPConnection<?> connection) {
        this._connection = connection;
        this._metadata = new ConnectionMetaData(connection);
    }

    @Override
    public String getName() {
        return this._connection.getRemoteAddressString();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._connection.getRemoteSocketAddress();
    }

    @Override
    public AmqpConnectionMetaData getConnectionMetaData() {
        return this._metadata;
    }

    public AMQPConnection<?> getConnection() {
        return this._connection;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPrincipal that = (ConnectionPrincipal)o;
        return this._connection.equals(that._connection);
    }

    @Override
    public int hashCode() {
        return this._connection.hashCode();
    }

    private static class ConnectionMetaData
    implements AmqpConnectionMetaData {
        private final AMQPConnection<?> _connection;

        ConnectionMetaData(AMQPConnection<?> connection) {
            this._connection = connection;
        }

        @Override
        public UUID getConnectionId() {
            return this._connection.getId();
        }

        @Override
        public Port getPort() {
            return this._connection.getPort();
        }

        @Override
        public String getLocalAddress() {
            return this._connection.getLocalAddress();
        }

        @Override
        public String getRemoteAddress() {
            return this._connection.getRemoteAddress();
        }

        @Override
        public Protocol getProtocol() {
            return this._connection.getProtocol();
        }

        @Override
        public Transport getTransport() {
            return this._connection.getTransport();
        }

        @Override
        public String getClientId() {
            return this._connection.getClientId();
        }

        @Override
        public String getClientVersion() {
            return this._connection.getClientVersion();
        }

        @Override
        public String getClientProduct() {
            return this._connection.getClientProduct();
        }
    }
}

