/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.server.bytebuffer.ByteBufferRef;
import org.apache.qpid.server.bytebuffer.MultiQpidByteBuffer;
import org.apache.qpid.server.bytebuffer.PooledByteBufferRef;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.bytebuffer.QpidByteBufferFactory;
import org.apache.qpid.server.bytebuffer.QpidByteBufferInputStream;

class SingleQpidByteBuffer
implements QpidByteBuffer {
    private static final AtomicIntegerFieldUpdater<SingleQpidByteBuffer> DISPOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleQpidByteBuffer.class, "_disposed");
    private final int _offset;
    private final ByteBufferRef _ref;
    private volatile ByteBuffer _buffer;
    private volatile int _disposed;

    SingleQpidByteBuffer(ByteBufferRef ref) {
        this(ref, ref.getBuffer(), 0);
    }

    private SingleQpidByteBuffer(ByteBufferRef ref, ByteBuffer buffer, int offset) {
        this._ref = ref;
        this._buffer = buffer;
        this._offset = offset;
        this._ref.incrementRef(this.capacity());
    }

    @Override
    public final boolean isDirect() {
        return this._buffer.isDirect();
    }

    @Override
    public final short getUnsignedByte() {
        return (short)((short)this.get() & 0xFF);
    }

    @Override
    public final int getUnsignedShort() {
        return this.getShort() & 0xFFFF;
    }

    @Override
    public final int getUnsignedShort(int pos) {
        return this.getShort(pos) & 0xFFFF;
    }

    @Override
    public final long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public final SingleQpidByteBuffer putUnsignedByte(short s) {
        this.put((byte)s);
        return this;
    }

    @Override
    public final SingleQpidByteBuffer putUnsignedShort(int i) {
        this.putShort((short)i);
        return this;
    }

    @Override
    public final SingleQpidByteBuffer putUnsignedInt(long value) {
        this.putInt((int)value);
        return this;
    }

    @Override
    public final void close() {
        this.dispose();
    }

    @Override
    public final void dispose() {
        if (DISPOSED_UPDATER.compareAndSet(this, 0, 1)) {
            this._ref.decrementRef(this.capacity());
        }
        this._buffer = null;
    }

    @Override
    public final InputStream asInputStream() {
        SingleQpidByteBuffer buffer = this;
        return new QpidByteBufferInputStream(buffer);
    }

    @Override
    public final long read(ScatteringByteChannel channel) throws IOException {
        return channel.read(this.getUnderlyingBuffer());
    }

    public String toString() {
        return "SingleQpidByteBuffer{_buffer=" + this._buffer + ", _disposed=" + this._disposed + '}';
    }

    @Override
    public final boolean hasRemaining() {
        return this._buffer.hasRemaining();
    }

    @Override
    public boolean hasRemaining(int atLeast) {
        return this._buffer.remaining() >= atLeast;
    }

    @Override
    public SingleQpidByteBuffer putInt(int index, int value) {
        this._buffer.putInt(index, value);
        return this;
    }

    @Override
    public SingleQpidByteBuffer putShort(int index, short value) {
        this._buffer.putShort(index, value);
        return this;
    }

    @Override
    public SingleQpidByteBuffer putChar(int index, char value) {
        this._buffer.putChar(index, value);
        return this;
    }

    @Override
    public final SingleQpidByteBuffer put(byte b) {
        this._buffer.put(b);
        return this;
    }

    @Override
    public SingleQpidByteBuffer put(int index, byte b) {
        this._buffer.put(index, b);
        return this;
    }

    @Override
    public short getShort(int index) {
        return this._buffer.getShort(index);
    }

    @Override
    public final SingleQpidByteBuffer mark() {
        this._buffer.mark();
        return this;
    }

    @Override
    public final long getLong() {
        return this._buffer.getLong();
    }

    @Override
    public SingleQpidByteBuffer putFloat(int index, float value) {
        this._buffer.putFloat(index, value);
        return this;
    }

    @Override
    public double getDouble(int index) {
        return this._buffer.getDouble(index);
    }

    @Override
    public final boolean hasArray() {
        return this._buffer.hasArray();
    }

    @Override
    public final double getDouble() {
        return this._buffer.getDouble();
    }

    @Override
    public final SingleQpidByteBuffer putFloat(float value) {
        this._buffer.putFloat(value);
        return this;
    }

    @Override
    public final SingleQpidByteBuffer putInt(int value) {
        this._buffer.putInt(value);
        return this;
    }

    @Override
    public byte[] array() {
        return this._buffer.array();
    }

    @Override
    public final SingleQpidByteBuffer putShort(short value) {
        this._buffer.putShort(value);
        return this;
    }

    @Override
    public int getInt(int index) {
        return this._buffer.getInt(index);
    }

    @Override
    public final int remaining() {
        return this._buffer.remaining();
    }

    @Override
    public final SingleQpidByteBuffer put(byte[] src) {
        this._buffer.put(src);
        return this;
    }

    @Override
    public final SingleQpidByteBuffer put(ByteBuffer src) {
        this._buffer.put(src);
        return this;
    }

    @Override
    public final SingleQpidByteBuffer put(QpidByteBuffer src) {
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (src instanceof SingleQpidByteBuffer) {
            this._buffer.put(((SingleQpidByteBuffer)src).getUnderlyingBuffer());
        } else if (src instanceof MultiQpidByteBuffer) {
            for (SingleQpidByteBuffer singleQpidByteBuffer : ((MultiQpidByteBuffer)src).getFragments()) {
                this._buffer.put(singleQpidByteBuffer.getUnderlyingBuffer());
            }
        } else {
            throw new IllegalStateException("unknown QBB implementation");
        }
        return this;
    }

    @Override
    public final SingleQpidByteBuffer get(byte[] dst, int offset, int length) {
        this._buffer.get(dst, offset, length);
        return this;
    }

    @Override
    public final void copyTo(ByteBuffer dst) {
        dst.put(this._buffer.duplicate());
    }

    @Override
    public final void putCopyOf(QpidByteBuffer source) {
        int remaining = this.remaining();
        int sourceRemaining = source.remaining();
        if (sourceRemaining > remaining) {
            throw new BufferOverflowException();
        }
        if (source instanceof SingleQpidByteBuffer) {
            this.put(((SingleQpidByteBuffer)source).getUnderlyingBuffer().duplicate());
        } else if (source instanceof MultiQpidByteBuffer) {
            for (SingleQpidByteBuffer singleQpidByteBuffer : ((MultiQpidByteBuffer)source).getFragments()) {
                this.put(singleQpidByteBuffer.getUnderlyingBuffer().duplicate());
            }
        } else {
            throw new IllegalStateException("unknown QBB implementation");
        }
    }

    @Override
    public SingleQpidByteBuffer rewind() {
        this._buffer.rewind();
        return this;
    }

    @Override
    public SingleQpidByteBuffer clear() {
        this._buffer.clear();
        return this;
    }

    @Override
    public SingleQpidByteBuffer putLong(int index, long value) {
        this._buffer.putLong(index, value);
        return this;
    }

    @Override
    public SingleQpidByteBuffer compact() {
        this._buffer.compact();
        return this;
    }

    @Override
    public final SingleQpidByteBuffer putDouble(double value) {
        this._buffer.putDouble(value);
        return this;
    }

    @Override
    public int limit() {
        return this._buffer.limit();
    }

    @Override
    public SingleQpidByteBuffer reset() {
        this._buffer.reset();
        return this;
    }

    @Override
    public SingleQpidByteBuffer flip() {
        this._buffer.flip();
        return this;
    }

    @Override
    public final short getShort() {
        return this._buffer.getShort();
    }

    @Override
    public final float getFloat() {
        return this._buffer.getFloat();
    }

    @Override
    public SingleQpidByteBuffer limit(int newLimit) {
        this._buffer.limit(newLimit);
        return this;
    }

    @Override
    public SingleQpidByteBuffer duplicate() {
        ByteBuffer buffer = this._ref.getBuffer();
        if (!(this._ref instanceof PooledByteBufferRef)) {
            buffer = buffer.duplicate();
        }
        buffer.position(this._offset);
        buffer.limit(this._offset + this._buffer.capacity());
        buffer = buffer.slice();
        buffer.limit(this._buffer.limit());
        buffer.position(this._buffer.position());
        return new SingleQpidByteBuffer(this._ref, buffer, this._offset);
    }

    @Override
    public final SingleQpidByteBuffer put(byte[] src, int offset, int length) {
        this._buffer.put(src, offset, length);
        return this;
    }

    @Override
    public long getLong(int index) {
        return this._buffer.getLong(index);
    }

    @Override
    public int capacity() {
        return this._buffer.capacity();
    }

    @Override
    public char getChar(int index) {
        return this._buffer.getChar(index);
    }

    @Override
    public final byte get() {
        return this._buffer.get();
    }

    @Override
    public byte get(int index) {
        return this._buffer.get(index);
    }

    @Override
    public final SingleQpidByteBuffer get(byte[] dst) {
        this._buffer.get(dst);
        return this;
    }

    @Override
    public final void copyTo(byte[] dst) {
        if (this.remaining() < dst.length) {
            throw new BufferUnderflowException();
        }
        this._buffer.duplicate().get(dst);
    }

    @Override
    public final SingleQpidByteBuffer putChar(char value) {
        this._buffer.putChar(value);
        return this;
    }

    @Override
    public SingleQpidByteBuffer position(int newPosition) {
        this._buffer.position(newPosition);
        return this;
    }

    @Override
    public final char getChar() {
        return this._buffer.getChar();
    }

    @Override
    public final int getInt() {
        return this._buffer.getInt();
    }

    @Override
    public final SingleQpidByteBuffer putLong(long value) {
        this._buffer.putLong(value);
        return this;
    }

    @Override
    public float getFloat(int index) {
        return this._buffer.getFloat(index);
    }

    @Override
    public SingleQpidByteBuffer slice() {
        return this.view(0, this._buffer.remaining());
    }

    @Override
    public SingleQpidByteBuffer view(int offset, int length) {
        ByteBuffer buffer = this._ref.getBuffer();
        if (!(this._ref instanceof PooledByteBufferRef)) {
            buffer = buffer.duplicate();
        }
        int newRemaining = Math.min(this._buffer.remaining() - offset, length);
        int newPosition = this._offset + this._buffer.position() + offset;
        buffer.limit(newPosition + newRemaining);
        buffer.position(newPosition);
        buffer = buffer.slice();
        return new SingleQpidByteBuffer(this._ref, buffer, newPosition);
    }

    @Override
    public int position() {
        return this._buffer.position();
    }

    @Override
    public SingleQpidByteBuffer putDouble(int index, double value) {
        this._buffer.putDouble(index, value);
        return this;
    }

    ByteBuffer getUnderlyingBuffer() {
        return this._buffer;
    }

    @Override
    public boolean isSparse() {
        return this._ref.isSparse(QpidByteBufferFactory.getSparsityFraction());
    }
}

