/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.Future;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.SenderException;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerSessionDelegate;
import org.apache.qpid.server.protocol.v0_10.SessionInvoker;
import org.apache.qpid.server.protocol.v0_10.Session_0_10;
import org.apache.qpid.server.protocol.v0_10.Waiter;
import org.apache.qpid.server.protocol.v0_10.transport.Binary;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.ExecutionException;
import org.apache.qpid.server.protocol.v0_10.transport.ExecutionSync;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcceptMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcquireMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageCreditUnit;
import org.apache.qpid.server.protocol.v0_10.transport.MessageFlow;
import org.apache.qpid.server.protocol.v0_10.transport.MessageFlowMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageSetFlowMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageStop;
import org.apache.qpid.server.protocol.v0_10.transport.MessageTransfer;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.protocol.v0_10.transport.Range;
import org.apache.qpid.server.protocol.v0_10.transport.RangeSet;
import org.apache.qpid.server.protocol.v0_10.transport.RangeSetFactory;
import org.apache.qpid.server.protocol.v0_10.transport.SessionClosedException;
import org.apache.qpid.server.protocol.v0_10.transport.SessionDetachCode;
import org.apache.qpid.server.protocol.v0_10.transport.SessionException;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;
import org.apache.qpid.server.protocol.v0_10.transport.Xid;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.AlreadyKnownDtxException;
import org.apache.qpid.server.txn.AsyncAutoCommitTransaction;
import org.apache.qpid.server.txn.AsyncCommand;
import org.apache.qpid.server.txn.DistributedTransaction;
import org.apache.qpid.server.txn.DtxNotSelectedException;
import org.apache.qpid.server.txn.IncorrectDtxStateException;
import org.apache.qpid.server.txn.JoinAndResumeDtxException;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.NotAssociatedDtxException;
import org.apache.qpid.server.txn.RollbackOnlyDtxException;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.SuspendAndFailDtxException;
import org.apache.qpid.server.txn.TimeoutDtxException;
import org.apache.qpid.server.txn.UnknownDtxBranchException;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.Serial;
import org.apache.qpid.server.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSession
extends SessionInvoker
implements LogSubject,
AsyncAutoCommitTransaction.FutureRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSession.class);
    public static final int UNLIMITED_CREDIT = -1;
    private static final String NULL_DESTINATION = UUID.randomUUID().toString();
    private static final int PRODUCER_CREDIT_TOPUP_THRESHOLD = 0x40000000;
    private static final int UNFINISHED_COMMAND_QUEUE_THRESHOLD = 500;
    private final Set<Object> _blockingEntities = Collections.synchronizedSet(new HashSet());
    private final Deque<AsyncCommand> _unfinishedCommandsQueue = new ConcurrentLinkedDeque<AsyncCommand>();
    private final AtomicBoolean _blocking = new AtomicBoolean(false);
    private final AtomicInteger _outstandingCredit = new AtomicInteger(-1);
    private final Object processedLock = new Object();
    private final int commandLimit = Integer.getInteger("qpid.session.command_limit", 65536);
    private final Object commandsLock = new Object();
    private final Object stateLock = new Object();
    private Session_0_10 _modelObject;
    private long _blockTime;
    private long _blockingTimeout;
    private boolean _wireBlockingState;
    private ServerConnection connection;
    private Binary name;
    private boolean closing;
    private int channel;
    private ServerSessionDelegate delegate;
    private boolean incomingInit;
    private int commandsIn;
    private RangeSet processed;
    private int maxProcessed;
    private int syncPoint;
    private int commandsOut = 0;
    private Map<Integer, Method> commands = new HashMap<Integer, Method>();
    private int commandBytes = 0;
    private int byteLimit = Integer.getInteger("qpid.session.byte_limit", 0x100000);
    private int maxComplete = this.commandsOut - 1;
    private State state = State.NEW;
    private Semaphore credit = new Semaphore(0);
    private Thread resumer = null;
    private boolean transacted = false;
    private SessionDetachCode detachCode;
    private boolean _isNoReplay = false;
    private Map<Integer, ResultFuture<?>> results = new HashMap();
    private ExecutionException exception = null;
    private final SortedMap<Integer, MessageDispositionChangeListener> _messageDispositionListenerMap = new ConcurrentSkipListMap<Integer, MessageDispositionChangeListener>();
    private volatile ServerTransaction _transaction;
    private Map<String, ConsumerTarget_0_10> _subscriptions = new ConcurrentHashMap<String, ConsumerTarget_0_10>();
    private AtomicReference<LogMessage> _forcedCloseLogMessage = new AtomicReference();

    public ServerSession(ServerConnection connection, ServerSessionDelegate delegate, Binary name, long expiry) {
        this.connection = connection;
        this.delegate = delegate;
        this.name = name;
        this.closing = false;
        this._isNoReplay = false;
        this.initReceiver();
        this._transaction = new AsyncAutoCommitTransaction(this.getMessageStore(), (AsyncAutoCommitTransaction.FutureRecorder)this);
        this._blockingTimeout = (Long)connection.getBroker().getContextValue(Long.class, "channel.flowControlEnforcementTimeout");
    }

    public Binary getName() {
        return this.name;
    }

    protected void setClose(boolean close) {
        this.closing = close;
    }

    public int getChannel() {
        return this.channel;
    }

    void setChannel(int channel) {
        this.channel = channel;
    }

    protected State getState() {
        return this.state;
    }

    void addCredit(int value) {
        this.credit.release(value);
    }

    void drainCredit() {
        this.credit.drainPermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReceiver() {
        Object object = this.processedLock;
        synchronized (object) {
            this.incomingInit = false;
            this.processed = RangeSetFactory.createRangeSet();
        }
    }

    void attach() {
        this.initReceiver();
        this.sessionAttach(this.name.getBytes(), new Option[0]);
        this.sessionRequestTimeout(0L, new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        Object object = this.commandsLock;
        synchronized (object) {
            this.attach();
            int i = this.maxComplete + 1;
            while (Serial.lt((int)i, (int)this.commandsOut)) {
                Method m = this.getCommand(i);
                if (m == null) {
                    m = new ExecutionSync(new Option[0]);
                    m.setId(i);
                } else if (m instanceof MessageTransfer) {
                    DeliveryProperties deliveryProps;
                    MessageTransfer xfr = (MessageTransfer)m;
                    Header header = xfr.getHeader();
                    if (header != null) {
                        if (header.getDeliveryProperties() != null) {
                            header.getDeliveryProperties().setRedelivered(true);
                        } else {
                            deliveryProps = new DeliveryProperties();
                            deliveryProps.setRedelivered(true);
                            xfr.setHeader(new Header(deliveryProps, header.getMessageProperties(), header.getNonStandardProperties()));
                        }
                    } else {
                        deliveryProps = new DeliveryProperties();
                        deliveryProps.setRedelivered(true);
                        xfr.setHeader(new Header(deliveryProps, null, null));
                    }
                }
                this.sessionCommandPoint(m.getId(), 0L, new Option[0]);
                this.send(m);
                ++i;
            }
            this.sessionCommandPoint(this.commandsOut, 0L, new Option[0]);
            this.sessionFlush(Option.COMPLETED);
            this.resumer = Thread.currentThread();
            this.state = State.RESUMING;
            if (this.isTransacted()) {
                this.txSelect(new Option[0]);
            }
            this.resumer = null;
        }
    }

    private Method getCommand(int i) {
        return this.commands.get(i);
    }

    private void setCommand(int commandId, Method command) {
        this.commands.put(commandId, command);
    }

    private Method removeCommand(int id) {
        return this.commands.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void commandPoint(int id) {
        Object object = this.processedLock;
        synchronized (object) {
            this.commandsIn = id;
            if (!this.incomingInit) {
                this.incomingInit = true;
                this.syncPoint = this.maxProcessed = this.commandsIn - 1;
            }
        }
    }

    public int getCommandsOut() {
        return this.commandsOut;
    }

    public int getCommandsIn() {
        return this.commandsIn;
    }

    public int nextCommandId() {
        return this.commandsIn++;
    }

    final void identify(Method cmd) {
        if (!this.incomingInit) {
            throw new IllegalStateException();
        }
        int id = this.nextCommandId();
        cmd.setId(id);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("identify: ch={}, commandId={}", (Object)this.channel, (Object)id);
        }
        if ((id & 0xFF) == 0) {
            this.flushProcessed(Option.TIMELY_REPLY);
        }
    }

    public void processed(Method command) {
        this.processed(command.getId());
    }

    public void processed(int command) {
        this.processed(command, command);
    }

    public void processed(Range range) {
        this.processed(range.getLower(), range.getUpper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processed(int lower, int upper) {
        boolean flush;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} ch={} processed([{},{}]) {} {}", new Object[]{this, this.channel, lower, upper, this.syncPoint, this.maxProcessed});
        }
        Object object = this.processedLock;
        synchronized (object) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} processed: {}", (Object)this, (Object)this.processed);
            }
            if (Serial.ge((int)upper, (int)this.commandsIn)) {
                throw new IllegalArgumentException("range exceeds max received command-id: " + Range.newInstance(lower, upper));
            }
            this.processed.add(lower, upper);
            Range first = this.processed.getFirst();
            int flower = first.getLower();
            int fupper = first.getUpper();
            int old = this.maxProcessed;
            if (Serial.le((int)flower, (int)(this.maxProcessed + 1))) {
                this.maxProcessed = Serial.max((int)this.maxProcessed, (int)fupper);
            }
            boolean synced = Serial.ge((int)this.maxProcessed, (int)this.syncPoint);
            boolean bl = flush = Serial.lt((int)old, (int)this.syncPoint) && synced;
            if (synced) {
                this.syncPoint = this.maxProcessed;
            }
        }
        if (flush) {
            this.flushProcessed(new Option[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushExpected() {
        RangeSet rs = RangeSetFactory.createRangeSet();
        Object object = this.processedLock;
        synchronized (object) {
            if (this.incomingInit) {
                rs.add(this.commandsIn);
            }
        }
        this.sessionExpected(rs, null, new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushProcessed(Option ... options) {
        RangeSet copy;
        Object object = this.processedLock;
        synchronized (object) {
            copy = this.processed.copy();
        }
        object = this.commandsLock;
        synchronized (object) {
            if (this.state == State.DETACHED || this.state == State.CLOSING || this.state == State.CLOSED) {
                return;
            }
            if (copy.size() > 0) {
                this.sessionCompleted(copy, options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void knownComplete(RangeSet kc) {
        if (kc.size() > 0) {
            Object object = this.processedLock;
            synchronized (object) {
                this.processed.subtract(kc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncPoint() {
        boolean flush;
        int id = this.getCommandsIn() - 1;
        LOGGER.debug("{} synced to {}", (Object)this, (Object)id);
        Object object = this.processedLock;
        synchronized (object) {
            this.syncPoint = id;
            flush = Serial.ge((int)this.maxProcessed, (int)this.syncPoint);
        }
        if (flush) {
            this.flushProcessed(new Option[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean complete(int lower, int upper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} complete({}, {})", new Object[]{this, lower, upper});
        }
        Object object = this.commandsLock;
        synchronized (object) {
            int old = this.maxComplete;
            int id = Serial.max((int)this.maxComplete, (int)lower);
            while (Serial.le((int)id, (int)upper)) {
                Method m = this.removeCommand(id);
                if (m != null) {
                    this.commandBytes -= m.getBodySize();
                    m.complete();
                }
                ++id;
            }
            if (Serial.le((int)lower, (int)(this.maxComplete + 1))) {
                this.maxComplete = Serial.max((int)this.maxComplete, (int)upper);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}   commands remaining: {}", (Object)this, (Object)(this.commandsOut - this.maxComplete));
            }
            this.commandsLock.notifyAll();
            return Serial.gt((int)this.maxComplete, (int)old);
        }
    }

    void received(Method m) {
        m.delegate(this, this.delegate);
    }

    private void send(Method m) {
        m.setChannel(this.channel);
        this.connection.send(m);
        if (!m.isBatch()) {
            this.connection.flush();
        }
    }

    protected boolean isBytesFull() {
        return this.commandBytes >= this.byteLimit;
    }

    protected boolean isCommandsFull(int id) {
        return id - this.maxComplete >= this.commandLimit;
    }

    @Override
    public void invoke(Method m) {
        this.invoke(m, (Runnable)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Method m, Runnable postIdSettingAction) {
        if (m.getEncodedTrack() == 3) {
            Object object = this.commandsLock;
            synchronized (object) {
                boolean replayTransfer;
                Thread current;
                if (this.state == State.DETACHED && m.isUnreliable() && !(current = Thread.currentThread()).equals(this.resumer)) {
                    return;
                }
                if (this.state != State.OPEN && this.state != State.CLOSED && this.state != State.CLOSING && !(current = Thread.currentThread()).equals(this.resumer)) {
                    throw new SessionException(String.format("Unexpected state %s", new Object[]{this.state}));
                }
                switch (this.state) {
                    case OPEN: {
                        break;
                    }
                    case RESUMING: {
                        current = Thread.currentThread();
                        if (current.equals(this.resumer)) break;
                        throw new SessionException("timed out waiting for resume to finish");
                    }
                    case CLOSING: 
                    case CLOSED: {
                        ExecutionException exc = this.getException();
                        if (exc != null) {
                            throw new SessionException(exc);
                        }
                        throw new SessionClosedException();
                    }
                    default: {
                        throw new SessionException(String.format("timed out waiting for session to become open (state=%s)", new Object[]{this.state}));
                    }
                }
                int next = this.commandsOut++;
                m.setId(next);
                if (postIdSettingAction != null) {
                    postIdSettingAction.run();
                }
                if (this.isFull(next)) {
                    throw new SessionException(String.format("Command buffer full next: %d", next));
                }
                if (this.state == State.CLOSED) {
                    ExecutionException exc = this.getException();
                    if (exc != null) {
                        throw new SessionException(exc);
                    }
                    throw new SessionClosedException();
                }
                if (this.isFull(next)) {
                    throw new SessionException("timed out waiting for completion");
                }
                if (next == 0) {
                    this.sessionCommandPoint(0, 0L, new Option[0]);
                }
                boolean bl = replayTransfer = !this._isNoReplay && !this.closing && !this.transacted && m instanceof MessageTransfer && !m.isUnreliable();
                if (replayTransfer || m.hasCompletionListener()) {
                    this.setCommand(next, m);
                    this.commandBytes += m.getBodySize();
                }
                try {
                    this.send(m);
                }
                catch (SenderException e) {
                    if (!this.closing) {
                        LOGGER.error("error sending command", (Throwable)((Object)e));
                    }
                    e.rethrow();
                }
                if (this.shouldIssueFlush(next)) {
                    try {
                        this.sessionFlush(Option.COMPLETED);
                    }
                    catch (SenderException e) {
                        if (!this.closing) {
                            LOGGER.error("error sending flush (periodic)", (Throwable)((Object)e));
                        }
                        e.rethrow();
                    }
                }
            }
        }
        this.send(m);
    }

    protected boolean shouldIssueFlush(int next) {
        return next % 65536 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void result(int command, Struct result) {
        ResultFuture<?> future;
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            future = this.results.remove(command);
        }
        if (future != null) {
            ((ResultFuture)future).set(result);
        } else {
            LOGGER.warn("Received a response to a command that's no longer valid on the client side. [ command id : {} , result : {} ]", (Object)command, (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setException(ExecutionException exc) {
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            if (this.exception != null) {
                throw new IllegalStateException(String.format("too many exceptions: %s, %s", this.exception, exc));
            }
            this.exception = exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionException getException() {
        Map<Integer, ResultFuture<?>> map = this.results;
        synchronized (map) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> Future<T> invoke(Method m, Class<T> klass) {
        Object object = this.commandsLock;
        synchronized (object) {
            int command = this.commandsOut;
            ResultFuture future = new ResultFuture(klass);
            Map<Integer, ResultFuture<?>> map = this.results;
            synchronized (map) {
                this.results.put(command, future);
            }
            this.invoke(m);
            return future;
        }
    }

    public final void messageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, byte[] body, Option ... _options) {
        this.messageTransfer(destination, acceptMode, acquireMode, header, ByteBuffer.wrap(body), _options);
    }

    public final void messageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, String body, Option ... _options) {
        this.messageTransfer(destination, acceptMode, acquireMode, header, Strings.toUTF8((String)body), _options);
    }

    public void exception(Throwable t) {
        LOGGER.error("caught exception", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        Object object = this.commandsLock;
        synchronized (object) {
            this.state = this.closing || this.getException() != null ? State.CLOSED : State.DETACHED;
            this.commandsLock.notifyAll();
            Map<Integer, ResultFuture<?>> map = this.results;
            synchronized (map) {
                Iterator<ResultFuture<?>> iterator = this.results.values().iterator();
                while (iterator.hasNext()) {
                    ResultFuture<?> result;
                    ResultFuture<?> resultFuture = result = iterator.next();
                    synchronized (resultFuture) {
                        result.notifyAll();
                    }
                }
            }
            if (this.state == State.CLOSED) {
                this.delegate.closed(this);
            } else {
                this.delegate.detached(this);
            }
        }
        if (this.state == State.CLOSED) {
            this.connection.removeSession(this);
        }
    }

    public boolean isClosing() {
        return this.state == State.CLOSED || this.state == State.CLOSING || this.connection.isClosing();
    }

    public String toString() {
        return String.format("ssn:%s", this.name);
    }

    public void setTransacted(boolean b) {
        this.transacted = b;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setDetachCode(SessionDetachCode dtc) {
        this.detachCode = dtc;
    }

    public SessionDetachCode getDetachCode() {
        return this.detachCode;
    }

    public Object getStateLock() {
        return this.stateLock;
    }

    protected void sendSessionAttached(byte[] name, Option ... options) {
        super.sessionAttached(name, options);
    }

    public Subject getSubject() {
        return this._modelObject.getSubject();
    }

    public AccessControlContext getAccessControllerContext() {
        return this._modelObject.getAccessControllerContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(final State state) {
        if (this.runningAsSubject()) {
            Object object = this.commandsLock;
            synchronized (object) {
                this.state = state;
                this.commandsLock.notifyAll();
            }
            if (state == State.OPEN) {
                this.getAMQPConnection().getEventLogger().message(ChannelMessages.CREATE());
            }
        } else {
            this.runAsSubject(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServerSession.this.setState(state);
                    return null;
                }
            });
        }
    }

    private <T> T runAsSubject(PrivilegedAction<T> privilegedAction) {
        return AccessController.doPrivileged(privilegedAction, this.getAccessControllerContext());
    }

    private boolean runningAsSubject() {
        return this.getAuthorizedSubject().equals(Subject.getSubject(AccessController.getContext()));
    }

    private void invokeBlock() {
        this.invoke(new MessageSetFlowMode("", MessageFlowMode.CREDIT, new Option[0]));
        this.invoke(new MessageStop("", new Option[0]));
    }

    private void invokeUnblock() {
        MessageFlow mf = new MessageFlow();
        mf.setUnit(MessageCreditUnit.MESSAGE);
        mf.setDestination("");
        this._outstandingCredit.set(Integer.MAX_VALUE);
        mf.setValue(Integer.MAX_VALUE);
        this.invoke(mf);
    }

    void authorisePublish(MessageDestination destination, String routingKey, boolean immediate, long currentTime) {
        this._modelObject.getPublishAuthCache().authorisePublish(destination, routingKey, immediate, currentTime);
    }

    protected boolean isFull(int id) {
        return this.isCommandsFull(id);
    }

    RoutingResult<MessageTransferMessage> enqueue(MessageTransferMessage message, InstanceProperties instanceProperties, MessageDestination exchange) {
        if (this._outstandingCredit.get() != -1 && this._outstandingCredit.decrementAndGet() == 0x3FFFFFFF) {
            this._outstandingCredit.addAndGet(0x40000000);
            this.invoke(new MessageFlow("", MessageCreditUnit.MESSAGE, 0x40000000L, new Option[0]));
        }
        long arrivalTime = message.getArrivalTime();
        RoutingResult result = exchange.route((ServerMessage)message, message.getInitialRoutingAddress(), instanceProperties);
        result.send(this._transaction, null);
        this.getModelObject().registerMessageReceived(message.getSize());
        if (this.isTransactional()) {
            this.getModelObject().registerTransactedMessageReceived();
        }
        return result;
    }

    public void sendMessage(MessageTransfer xfr, Runnable postIdSettingAction) {
        this.getModelObject().registerMessageDelivered(xfr.getBodySize());
        if (this._transaction.isTransactional()) {
            this.getModelObject().registerTransactedMessageDelivered();
        }
        this.invoke((Method)xfr, postIdSettingAction);
    }

    public void onMessageDispositionChange(MessageTransfer xfr, MessageDispositionChangeListener acceptListener) {
        this._messageDispositionListenerMap.put(xfr.getId(), acceptListener);
    }

    public void accept(RangeSet ranges) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            @Override
            public void performAction(MessageDispositionChangeListener listener) {
                listener.onAccept();
            }
        });
    }

    public void release(RangeSet ranges, final boolean setRedelivered) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            @Override
            public void performAction(MessageDispositionChangeListener listener) {
                listener.onRelease(setRedelivered, false);
            }
        });
    }

    public void reject(RangeSet ranges) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            @Override
            public void performAction(MessageDispositionChangeListener listener) {
                listener.onReject();
            }
        });
    }

    public RangeSet acquire(RangeSet transfers) {
        RangeSet acquired = RangeSetFactory.createRangeSet();
        if (!this._messageDispositionListenerMap.isEmpty()) {
            Iterator<Integer> unacceptedMessages = this._messageDispositionListenerMap.keySet().iterator();
            Iterator<Range> rangeIter = transfers.iterator();
            if (rangeIter.hasNext()) {
                Range range = rangeIter.next();
                while (range != null && unacceptedMessages.hasNext()) {
                    MessageDispositionChangeListener changeListener;
                    int next = unacceptedMessages.next();
                    while (Serial.gt((int)next, (int)range.getUpper())) {
                        if (rangeIter.hasNext()) {
                            range = rangeIter.next();
                            continue;
                        }
                        range = null;
                        break;
                    }
                    if (range == null || !range.includes(next) || (changeListener = (MessageDispositionChangeListener)this._messageDispositionListenerMap.get(next)) == null || !changeListener.acquire()) continue;
                    acquired.add(next);
                }
            }
        }
        return acquired;
    }

    public void dispositionChange(RangeSet ranges, MessageDispositionAction action) {
        block5: {
            block6: {
                if (ranges == null) break block5;
                if (ranges.size() != 1) break block6;
                Range r = ranges.getFirst();
                for (int i = r.getLower(); i <= r.getUpper(); ++i) {
                    MessageDispositionChangeListener changeListener = (MessageDispositionChangeListener)this._messageDispositionListenerMap.remove(i);
                    if (changeListener == null) continue;
                    action.performAction(changeListener);
                }
                break block5;
            }
            if (this._messageDispositionListenerMap.isEmpty()) break block5;
            Iterator<Integer> unacceptedMessages = this._messageDispositionListenerMap.keySet().iterator();
            Iterator<Range> rangeIter = ranges.iterator();
            if (rangeIter.hasNext()) {
                Range range = rangeIter.next();
                while (range != null && unacceptedMessages.hasNext()) {
                    int next = unacceptedMessages.next();
                    while (Serial.gt((int)next, (int)range.getUpper())) {
                        if (rangeIter.hasNext()) {
                            range = rangeIter.next();
                            continue;
                        }
                        range = null;
                        break;
                    }
                    if (range == null || !range.includes(next)) continue;
                    MessageDispositionChangeListener changeListener = (MessageDispositionChangeListener)this._messageDispositionListenerMap.remove(next);
                    action.performAction(changeListener);
                }
            }
        }
    }

    public void removeDispositionListener(Method method) {
        this._messageDispositionListenerMap.remove(method.getId());
    }

    public void onClose() {
        AMQPConnection_0_10 amqpConnection = this.getAMQPConnection();
        if (this._transaction instanceof LocalTransaction) {
            if (((LocalTransaction)this._transaction).hasOutstandingWork()) {
                amqpConnection.incrementTransactionRollbackCounter();
            }
            amqpConnection.decrementTransactionOpenCounter();
            this._transaction.rollback();
            amqpConnection.unregisterTransactionTickers(this._transaction);
        } else if (this._transaction instanceof DistributedTransaction) {
            this.getAddressSpace().getDtxRegistry().endAssociations((AMQPSession)this._modelObject);
        }
        for (MessageDispositionChangeListener messageDispositionChangeListener : this._messageDispositionListenerMap.values()) {
            messageDispositionChangeListener.onRelease(true, true);
        }
        this._messageDispositionListenerMap.clear();
        for (Action action : this._modelObject.getTaskList()) {
            action.performAction((Object)this._modelObject);
        }
        LogMessage operationalLoggingMessage = this._forcedCloseLogMessage.get();
        if (operationalLoggingMessage == null && this.getConnection().getConnectionCloseMessage() != null) {
            operationalLoggingMessage = ChannelMessages.CLOSE_FORCED((Number)this.getConnection().getConnectionCloseCode(), (String)this.getConnection().getConnectionCloseMessage());
        }
        if (operationalLoggingMessage == null) {
            operationalLoggingMessage = ChannelMessages.CLOSE();
        }
        amqpConnection.getEventLogger().message(this.getLogSubject(), operationalLoggingMessage);
    }

    protected void awaitClose() {
    }

    public void acknowledge(final MessageInstanceConsumer consumer, ConsumerTarget_0_10 target, final MessageInstance entry) {
        if (entry.makeAcquisitionUnstealable(consumer)) {
            this._transaction.dequeue(entry.getEnqueueRecord(), new ServerTransaction.Action(){

                public void postCommit() {
                    entry.delete();
                }

                public void onRollback() {
                    entry.setRedelivered();
                    entry.release(consumer);
                }
            });
        }
    }

    Collection<ConsumerTarget_0_10> getSubscriptions() {
        return this._subscriptions.values();
    }

    public void register(String destination, ConsumerTarget_0_10 sub) {
        this._subscriptions.put(destination == null ? NULL_DESTINATION : destination, sub);
    }

    public ConsumerTarget_0_10 getSubscription(String destination) {
        return this._subscriptions.get(destination == null ? NULL_DESTINATION : destination);
    }

    public void unregister(ConsumerTarget_0_10 sub) {
        this._subscriptions.remove(sub.getName());
        sub.close();
    }

    public boolean isTransactional() {
        return this._transaction.isTransactional();
    }

    ServerTransaction getTransaction() {
        return this._transaction;
    }

    public void selectTx() {
        ServerTransaction txn = this._transaction;
        AMQPConnection_0_10 amqpConnection = this.getAMQPConnection();
        if (txn instanceof LocalTransaction) {
            amqpConnection.unregisterTransactionTickers(this._transaction);
        }
        this._transaction = amqpConnection.createLocalTransaction();
        long notificationRepeatPeriod = (Long)this.getModelObject().getContextValue(Long.class, "qpid.session.transactionTimeoutNotificationRepeatPeriod");
        amqpConnection.registerTransactionTickers(this._transaction, message -> amqpConnection.sendConnectionCloseAsync(AMQPConnection.CloseReason.TRANSACTION_TIMEOUT, (String)message), notificationRepeatPeriod);
    }

    public void selectDtx() {
        this._transaction = new DistributedTransaction((AMQPSession)this._modelObject, this.getAddressSpace().getDtxRegistry());
    }

    public void startDtx(Xid xid, boolean join, boolean resume) throws JoinAndResumeDtxException, UnknownDtxBranchException, AlreadyKnownDtxException, DtxNotSelectedException {
        DistributedTransaction distributedTransaction = this.assertDtxTransaction();
        distributedTransaction.start(ServerSession.toDtxXid(xid), join, resume);
    }

    public void endDtx(Xid xid, boolean fail, boolean suspend) throws NotAssociatedDtxException, UnknownDtxBranchException, DtxNotSelectedException, SuspendAndFailDtxException, TimeoutDtxException {
        DistributedTransaction distributedTransaction = this.assertDtxTransaction();
        distributedTransaction.end(ServerSession.toDtxXid(xid), fail, suspend);
    }

    public long getTimeoutDtx(Xid xid) throws UnknownDtxBranchException {
        return this.getAddressSpace().getDtxRegistry().getTimeout(ServerSession.toDtxXid(xid));
    }

    public void setTimeoutDtx(Xid xid, long timeout) throws UnknownDtxBranchException {
        this.getAddressSpace().getDtxRegistry().setTimeout(ServerSession.toDtxXid(xid), timeout);
    }

    public void prepareDtx(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException, StoreException, RollbackOnlyDtxException, TimeoutDtxException {
        this.getAddressSpace().getDtxRegistry().prepare(ServerSession.toDtxXid(xid));
    }

    public void commitDtx(Xid xid, boolean onePhase) throws UnknownDtxBranchException, IncorrectDtxStateException, StoreException, RollbackOnlyDtxException, TimeoutDtxException {
        this.getAddressSpace().getDtxRegistry().commit(ServerSession.toDtxXid(xid), onePhase);
    }

    public void rollbackDtx(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException, StoreException, TimeoutDtxException {
        this.getAddressSpace().getDtxRegistry().rollback(ServerSession.toDtxXid(xid));
    }

    public void forgetDtx(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException {
        this.getAddressSpace().getDtxRegistry().forget(ServerSession.toDtxXid(xid));
    }

    public List<Xid> recoverDtx() {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        for (org.apache.qpid.server.txn.Xid dtxXid : this.getAddressSpace().getDtxRegistry().recover()) {
            xids.add(new Xid(dtxXid.getFormat(), dtxXid.getGlobalId(), dtxXid.getBranchId()));
        }
        return xids;
    }

    private DistributedTransaction assertDtxTransaction() throws DtxNotSelectedException {
        if (this._transaction instanceof DistributedTransaction) {
            return (DistributedTransaction)this._transaction;
        }
        throw new DtxNotSelectedException();
    }

    public void commit() {
        this._transaction.commit();
        this.getAMQPConnection().incrementTransactionBeginCounter();
    }

    public void rollback() {
        this._transaction.rollback();
        AMQPConnection_0_10 amqpConnection = this.getAMQPConnection();
        amqpConnection.incrementTransactionRollbackCounter();
        amqpConnection.incrementTransactionBeginCounter();
    }

    public int getChannelId() {
        return this.getChannel();
    }

    public Principal getAuthorizedPrincipal() {
        return this.getConnection().getAuthorizedPrincipal();
    }

    public Subject getAuthorizedSubject() {
        return this.getSubject();
    }

    public Object getReference() {
        return this.getConnection().getReference();
    }

    public MessageStore getMessageStore() {
        return this.getAddressSpace().getMessageStore();
    }

    public NamedAddressSpace getAddressSpace() {
        return this.getConnection().getAddressSpace();
    }

    public boolean isDurable() {
        return false;
    }

    public UUID getId() {
        return this._modelObject.getId();
    }

    public AMQPConnection_0_10 getAMQPConnection() {
        return this.getConnection().getAmqpConnection();
    }

    public ServerConnection getConnection() {
        return this.connection;
    }

    public LogSubject getLogSubject() {
        return this._modelObject.getLogSubject();
    }

    public void block(Queue<?> queue) {
        this.block(queue, queue.getName());
    }

    public void block() {
        this.block(this, "** All Queues **");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block(Object queue, String name) {
        Set<Object> set = this._blockingEntities;
        synchronized (set) {
            if (this._blockingEntities.add(queue) && this._blocking.compareAndSet(false, true)) {
                this.getAMQPConnection().getEventLogger().message(this.getLogSubject(), ChannelMessages.FLOW_ENFORCED((String)name));
                if (this.getState() == State.OPEN) {
                    this.getAMQPConnection().notifyWork(this._modelObject);
                }
            }
        }
    }

    public void unblock(Queue<?> queue) {
        this.unblock((Object)queue);
    }

    public void unblock() {
        this.unblock(this);
    }

    private void unblock(Object queue) {
        if (this._blockingEntities.remove(queue) && this._blockingEntities.isEmpty() && this._blocking.compareAndSet(true, false) && !this.isClosing()) {
            this.getAMQPConnection().getEventLogger().message(this.getLogSubject(), ChannelMessages.FLOW_REMOVED());
            this.getAMQPConnection().notifyWork(this._modelObject);
        }
    }

    boolean blockingTimeoutExceeded() {
        long blockTime = this._blockTime;
        boolean b = this._wireBlockingState && blockTime != 0L && System.currentTimeMillis() - blockTime > this._blockingTimeout;
        return b;
    }

    public void updateBlockedStateIfNecesssary() {
        boolean desiredBlockingState = this._blocking.get();
        if (desiredBlockingState != this._wireBlockingState) {
            this._wireBlockingState = desiredBlockingState;
            if (desiredBlockingState) {
                this.invokeBlock();
            } else {
                this.invokeUnblock();
            }
            this._blockTime = desiredBlockingState ? System.currentTimeMillis() : 0L;
        }
    }

    public Object getConnectionReference() {
        return this.getConnection().getReference();
    }

    public String toLogString() {
        return this._modelObject.toLogString();
    }

    public void close(int cause, String message) {
        this._forcedCloseLogMessage.compareAndSet(null, ChannelMessages.CLOSE_FORCED((Number)cause, (String)message));
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.unregisterSubscriptions();
        if (this._modelObject != null) {
            this._modelObject.delete();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing [{}] in state [{}]", (Object)this, (Object)this.state);
        }
        Object object = this.commandsLock;
        synchronized (object) {
            switch (this.state) {
                case DETACHED: {
                    this.state = State.CLOSED;
                    this.delegate.closed(this);
                    this.connection.removeSession(this);
                    break;
                }
                case CLOSED: {
                    break;
                }
                default: {
                    this.state = State.CLOSING;
                    this.setClose(true);
                    this.sessionRequestTimeout(0L, new Option[0]);
                    this.sessionDetach(this.name.getBytes(), new Option[0]);
                    this.awaitClose();
                }
            }
        }
    }

    void unregisterSubscriptions() {
        Collection<ConsumerTarget_0_10> subscriptions = this.getSubscriptions();
        for (ConsumerTarget_0_10 subscription_0_10 : subscriptions) {
            this.unregister(subscription_0_10);
        }
    }

    void stopSubscriptions() {
        Collection<ConsumerTarget_0_10> subscriptions = this.getSubscriptions();
        for (ConsumerTarget_0_10 subscription_0_10 : subscriptions) {
            subscription_0_10.stop();
        }
    }

    void receivedComplete() {
        this.runAsSubject(() -> {
            Collection<ConsumerTarget_0_10> subscriptions = this.getSubscriptions();
            for (ConsumerTarget_0_10 subscription_0_10 : subscriptions) {
                subscription_0_10.flushCreditState(false);
            }
            this.awaitCommandCompletion();
            return null;
        });
    }

    public int getUnacknowledgedMessageCount() {
        return this._messageDispositionListenerMap.size();
    }

    public boolean getBlocking() {
        return this._blocking.get();
    }

    public void completeAsyncCommands() {
        AsyncCommand cmd;
        while ((cmd = this._unfinishedCommandsQueue.peek()) != null && cmd.isReadyForCompletion()) {
            cmd.complete();
            this._unfinishedCommandsQueue.poll();
        }
        while (this._unfinishedCommandsQueue.size() > 500) {
            cmd = this._unfinishedCommandsQueue.poll();
            cmd.complete();
        }
    }

    public void awaitCommandCompletion() {
        AsyncCommand cmd;
        while ((cmd = this._unfinishedCommandsQueue.poll()) != null) {
            cmd.complete();
        }
    }

    public Object getAsyncCommandMark() {
        return this._unfinishedCommandsQueue.isEmpty() ? null : this._unfinishedCommandsQueue.getLast();
    }

    public void recordFuture(ListenableFuture<Void> future, ServerTransaction.Action action) {
        this._unfinishedCommandsQueue.add(new AsyncCommand(future, action));
    }

    public void setModelObject(Session_0_10 session) {
        this._modelObject = session;
    }

    public Session_0_10 getModelObject() {
        return this._modelObject;
    }

    public long getTransactionStartTimeLong() {
        ServerTransaction serverTransaction = this._transaction;
        if (serverTransaction.isTransactional()) {
            return serverTransaction.getTransactionStartTime();
        }
        return 0L;
    }

    public long getTransactionUpdateTimeLong() {
        ServerTransaction serverTransaction = this._transaction;
        if (serverTransaction.isTransactional()) {
            return serverTransaction.getTransactionUpdateTime();
        }
        return 0L;
    }

    public static org.apache.qpid.server.txn.Xid toDtxXid(Xid xid) {
        return new org.apache.qpid.server.txn.Xid(xid.getFormat(), xid.getGlobalId(), xid.getBranchId());
    }

    private class ResultFuture<T>
    implements Future<T> {
        private final Class<T> klass;
        private T result;

        private ResultFuture(Class<T> klass) {
            this.klass = klass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void set(Struct result) {
            ResultFuture resultFuture = this;
            synchronized (resultFuture) {
                this.result = this.klass.cast(result);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout) {
            ResultFuture resultFuture = this;
            synchronized (resultFuture) {
                Waiter w = new Waiter(this, timeout);
                while (w.hasTime() && ServerSession.this.state != State.CLOSED && !this.isDone()) {
                    LOGGER.debug("{} waiting for result: {}", (Object)ServerSession.this, (Object)this);
                    w.await();
                }
            }
            if (this.isDone()) {
                return this.result;
            }
            if (ServerSession.this.state == State.CLOSED) {
                ExecutionException ex = ServerSession.this.getException();
                if (ex == null) {
                    throw new SessionClosedException();
                }
                throw new SessionException(ex);
            }
            throw new SessionException(String.format("%s timed out waiting for result: %s", ServerSession.this, this));
        }

        @Override
        public boolean isDone() {
            return this.result != null;
        }

        public String toString() {
            return String.format("Future(%s)", this.isDone() ? this.result : this.klass);
        }
    }

    private static interface MessageDispositionAction {
        public void performAction(MessageDispositionChangeListener var1);
    }

    public static interface MessageDispositionChangeListener {
        public void onAccept();

        public void onRelease(boolean var1, boolean var2);

        public void onReject();

        public boolean acquire();
    }

    public static enum State {
        NEW,
        DETACHED,
        RESUMING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

