/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.OrderByExpression;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectExpression;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectExpressionFactory;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectFilterParser;
import org.apache.qpid.server.management.plugin.servlet.query.EvaluationException;
import org.apache.qpid.server.management.plugin.servlet.query.ParseException;
import org.apache.qpid.server.management.plugin.servlet.query.TokenMgrError;
import org.apache.qpid.server.model.ConfiguredObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfiguredObjectQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredObjectQuery.class);
    private static final String[] STANDARD_FIELDS = new String[]{"id", "name"};
    public static final int DEFAULT_LIMIT = -1;
    public static final int DEFAULT_OFFSET = 0;
    private final ConfiguredObjectExpressionFactory _expressionFactory = new ConfiguredObjectExpressionFactory();
    private final List<List<Object>> _results;
    private final List<String> _headers;
    private final int _totalNumberOfRows;

    public ConfiguredObjectQuery(List<ConfiguredObject<?>> objects, String selectClause, String whereClause) {
        this(objects, selectClause, whereClause, null);
    }

    public ConfiguredObjectQuery(List<ConfiguredObject<?>> objects, String selectClause, String whereClause, String orderByClause) {
        this(objects, selectClause, whereClause, orderByClause, null, null);
    }

    public ConfiguredObjectQuery(List<ConfiguredObject<?>> objects, String selectClause, String whereClause, String orderByClause, String limitClause, String offsetClause) {
        int limit = this.toInt(limitClause, -1);
        int offset = this.toInt(offsetClause, 0);
        HeadersAndValueExpressions headersAndValueExpressions = this.parseSelectClause(selectClause);
        List<ConfiguredObject<?>> filteredObjects = whereClause == null ? objects : this.filterObjects(objects, whereClause);
        List<ConfiguredObject<?>> orderedObjects = orderByClause == null ? filteredObjects : this.orderObjects(filteredObjects, orderByClause, headersAndValueExpressions);
        List<ConfiguredObject<?>> limitedOrderedObjects = this.applyLimitAndOffset(orderedObjects, limit, offset);
        this._headers = headersAndValueExpressions.getHeaders();
        this._results = this.evaluateResults(limitedOrderedObjects, headersAndValueExpressions.getValueExpressions());
        this._totalNumberOfRows = filteredObjects.size();
    }

    public List<List<Object>> getResults() {
        return this._results;
    }

    public List<String> getHeaders() {
        return this._headers;
    }

    public int getTotalNumberOfRows() {
        return this._totalNumberOfRows;
    }

    private int toInt(String value, int defaultValue) {
        int returnValue = defaultValue;
        if (value != null) {
            try {
                returnValue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private HeadersAndValueExpressions parseSelectClause(String selectClause) {
        final ArrayList<String> headers = new ArrayList<String>();
        final ArrayList<Expression> valueExpressions = new ArrayList<Expression>();
        if (selectClause != null) {
            ConfiguredObjectFilterParser parser = new ConfiguredObjectFilterParser();
            parser.setConfiguredObjectExpressionFactory(this._expressionFactory);
            try {
                List<Map<String, Expression>> expressions = parser.parseSelect(selectClause);
                for (Map<String, Expression> expression : expressions) {
                    Map.Entry<String, Expression> entry = expression.entrySet().iterator().next();
                    headers.add(entry.getKey());
                    valueExpressions.add(entry.getValue());
                }
            }
            catch (ParseException | TokenMgrError e) {
                throw new SelectorParsingException("Unable to parse select clause", e);
            }
        } else {
            for (String field : STANDARD_FIELDS) {
                headers.add(field);
                valueExpressions.add(this._expressionFactory.createConfiguredObjectExpression(field));
            }
        }
        return new HeadersAndValueExpressions(){

            @Override
            public List<String> getHeaders() {
                return Collections.unmodifiableList(headers);
            }

            @Override
            public List<Expression> getValueExpressions() {
                return Collections.unmodifiableList(valueExpressions);
            }

            @Override
            public boolean hasHeader(String headerName) {
                return headers.contains(headerName);
            }

            @Override
            public Expression getValueExpressionForHeader(String headerName) {
                int i = headers.indexOf(headerName);
                if (i < 0) {
                    throw new IllegalStateException(String.format("No expression found for header '%s'", headerName));
                }
                return (Expression)valueExpressions.get(i);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ConfiguredObject<?>> filterObjects(List<ConfiguredObject<?>> objects, String whereClause) {
        ArrayList filteredObjects = new ArrayList();
        ConfiguredObjectFilterParser parser = new ConfiguredObjectFilterParser();
        parser.setConfiguredObjectExpressionFactory(this._expressionFactory);
        try {
            BooleanExpression<ConfiguredObject> expression = parser.parseWhere(whereClause);
            for (ConfiguredObject<?> object : objects) {
                try {
                    if (!expression.matches(object)) continue;
                    filteredObjects.add(object);
                }
                catch (RuntimeException e) {
                    throw new EvaluationException("Error while evaluating object against where clause", e);
                    return filteredObjects;
                }
            }
        }
        catch (ParseException | TokenMgrError e) {
            throw new SelectorParsingException("Unable to parse where clause", e);
        }
    }

    private List<List<Object>> evaluateResults(List<ConfiguredObject<?>> filteredObjects, List<Expression> valueExpressions) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        for (ConfiguredObject<?> object : filteredObjects) {
            ArrayList<Object> objectVals = new ArrayList<Object>();
            for (Expression evaluator : valueExpressions) {
                Object value;
                try {
                    value = evaluator.evaluate(object);
                }
                catch (RuntimeException e) {
                    LOGGER.debug("Error while evaluating select clause", (Throwable)e);
                    value = null;
                }
                objectVals.add(value);
            }
            values.add(objectVals);
        }
        return values;
    }

    private List<ConfiguredObject<?>> applyLimitAndOffset(List<ConfiguredObject<?>> orderedObjects, int limit, int offset) {
        int size = orderedObjects.size();
        int firstIndex = offset < 0 ? Math.max(0, size + offset) : Math.min(size, offset);
        int lastIndex = limit < 0 ? size : Math.min(size, firstIndex + limit);
        return orderedObjects.subList(firstIndex, lastIndex);
    }

    private List<ConfiguredObject<?>> orderObjects(List<ConfiguredObject<?>> unorderedResults, String orderByClause, HeadersAndValueExpressions headersAndValue) {
        List<OrderByExpression> orderByExpressions = this.parseOrderByClause(orderByClause, headersAndValue);
        ArrayList orderedObjects = new ArrayList(unorderedResults.size());
        orderedObjects.addAll(unorderedResults);
        OrderByComparator comparator = new OrderByComparator(orderByExpressions, headersAndValue.getValueExpressions());
        Collections.sort(orderedObjects, comparator);
        return orderedObjects;
    }

    private List<OrderByExpression> parseOrderByClause(String orderByClause, final HeadersAndValueExpressions headersAndValue) {
        List<OrderByExpression> orderByExpressions;
        ConfiguredObjectFilterParser parser = new ConfiguredObjectFilterParser();
        parser.setConfiguredObjectExpressionFactory(new ConfiguredObjectExpressionFactory(){

            @Override
            public ConfiguredObjectExpression createConfiguredObjectExpression(String propertyName) {
                if (headersAndValue.hasHeader(propertyName)) {
                    Expression expression = headersAndValue.getValueExpressionForHeader(propertyName);
                    return object -> expression.evaluate(object);
                }
                return super.createConfiguredObjectExpression(propertyName);
            }
        });
        try {
            orderByExpressions = parser.parseOrderBy(orderByClause);
        }
        catch (ParseException | TokenMgrError e) {
            throw new SelectorParsingException("Unable to parse orderBy clause", e);
        }
        return orderByExpressions;
    }

    class OrderByComparator
    implements Comparator<Object> {
        private final List<OrderByExpression> _orderByExpressions;

        public OrderByComparator(List<OrderByExpression> orderByExpressions, List<Expression> valueExpressions) {
            this._orderByExpressions = new ArrayList<OrderByExpression>(orderByExpressions);
            ListIterator<OrderByExpression> iterator = this._orderByExpressions.listIterator();
            while (iterator.hasNext()) {
                OrderByExpression orderByExpression = iterator.next();
                if (!orderByExpression.isColumnIndex()) continue;
                int index = orderByExpression.getColumnIndex();
                if (index <= 0 || index > valueExpressions.size()) {
                    throw new EvaluationException(String.format("Invalid column index '%d' in orderBy clause", index));
                }
                orderByExpression = new OrderByExpression(valueExpressions.get(index - 1), orderByExpression.getOrder());
                iterator.set(orderByExpression);
            }
        }

        @Override
        public int compare(Object o1, Object o2) {
            int index = 0;
            int comparisonResult = 0;
            for (OrderByExpression orderByExpression : this._orderByExpressions) {
                try {
                    Comparable left = (Comparable)orderByExpression.evaluate(o1);
                    Comparable right = (Comparable)orderByExpression.evaluate(o2);
                    if (left == null && right != null) {
                        comparisonResult = -1;
                    } else if (left != null && right == null) {
                        comparisonResult = 1;
                    } else if (left != null && right != null) {
                        comparisonResult = left.compareTo(right);
                    }
                    if (comparisonResult != 0) {
                        int order = 1;
                        if (orderByExpression.getOrder() == OrderByExpression.Order.DESC) {
                            order = -1;
                        }
                        return order * comparisonResult;
                    }
                    ++index;
                }
                catch (ClassCastException e) {
                    throw new EvaluationException(String.format("The orderBy expression at position '%d' is unsupported", index), e);
                }
            }
            return comparisonResult;
        }
    }

    static interface HeadersAndValueExpressions {
        public List<String> getHeaders();

        public List<Expression> getValueExpressions();

        public boolean hasHeader(String var1);

        public Expression getValueExpressionForHeader(String var1);
    }
}

