/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.security.auth.ManagementConnectionPrincipal;
import org.apache.qpid.server.security.auth.SocketConnectionMetaData;

public class ServletConnectionPrincipal
implements ManagementConnectionPrincipal {
    private static final long serialVersionUID = 1L;
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private static final int HASH_TRUNCATION_LENGTH = 8;
    private final InetSocketAddress _address;
    private final String _sessionId;
    private ServletRequestMetaData _metadata;

    public ServletConnectionPrincipal(HttpServletRequest request) {
        this._address = new InetSocketAddress(request.getRemoteHost(), request.getRemotePort());
        this._metadata = new ServletRequestMetaData(request);
        HttpSession session = request.getSession(false);
        if (session != null) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-256");
                md.update(session.getId().getBytes(UTF8));
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new RuntimeException("Cannot create SHA-256 hash", e);
            }
            byte[] digest = md.digest();
            this._sessionId = Base64.getEncoder().encodeToString(digest).substring(0, 8);
        } else {
            this._sessionId = null;
        }
    }

    public SocketAddress getRemoteAddress() {
        return this._address;
    }

    public SocketConnectionMetaData getConnectionMetaData() {
        return this._metadata;
    }

    public String getName() {
        return this._address.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServletConnectionPrincipal that = (ServletConnectionPrincipal)o;
        return this._address.equals(that._address);
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public String getType() {
        return "HTTP";
    }

    public String getSessionId() {
        return this._sessionId;
    }

    private static class ServletRequestMetaData
    implements SocketConnectionMetaData {
        private final HttpServletRequest _request;

        public ServletRequestMetaData(HttpServletRequest request) {
            this._request = request;
        }

        public Port getPort() {
            return HttpManagementUtil.getPort(this._request);
        }

        public String getLocalAddress() {
            return this._request.getServerName() + ":" + this._request.getServerPort();
        }

        public String getRemoteAddress() {
            return this._request.getRemoteHost() + ":" + this._request.getRemotePort();
        }

        public Protocol getProtocol() {
            return Protocol.HTTP;
        }

        public Transport getTransport() {
            return this._request.isSecure() ? Transport.SSL : Transport.TCP;
        }

        public String getHttpProtocol() {
            return this._request.getProtocol();
        }
    }
}

