/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.latest;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementRequest;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.ResponseType;
import org.apache.qpid.server.management.plugin.controller.ControllerManagementResponse;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.Model;

public class LatestManagementControllerAdapter
implements ManagementController {
    private ManagementController _latestManagementController;

    public LatestManagementControllerAdapter(ManagementController latestManagementController) {
        this._latestManagementController = latestManagementController;
    }

    @Override
    public String getVersion() {
        return this._latestManagementController.getVersion();
    }

    @Override
    public Collection<String> getCategories() {
        return this._latestManagementController.getCategories();
    }

    @Override
    public String getCategoryMapping(String category) {
        return this._latestManagementController.getCategoryMapping(category);
    }

    @Override
    public String getCategory(ConfiguredObject<?> managedObject) {
        return this._latestManagementController.getCategory(managedObject);
    }

    @Override
    public Collection<String> getCategoryHierarchy(ConfiguredObject<?> root, String category) {
        return this._latestManagementController.getCategoryHierarchy(root, category);
    }

    @Override
    public ManagementController getNextVersionManagementController() {
        return this._latestManagementController;
    }

    @Override
    public ManagementResponse handleGet(ManagementRequest request) throws ManagementException {
        ManagementResponse response = this._latestManagementController.handleGet(request);
        return new ControllerManagementResponse(response.getType(), this.convertResponseObject(response.getBody()), response.getResponseCode(), response.getHeaders());
    }

    @Override
    public ManagementResponse handlePut(ManagementRequest request) throws ManagementException {
        ManagementResponse response = this._latestManagementController.handlePut(request);
        return new ControllerManagementResponse(response.getType(), this.convertResponseObject(response.getBody()), response.getResponseCode(), response.getHeaders());
    }

    @Override
    public ManagementResponse handlePost(ManagementRequest request) throws ManagementException {
        ManagementResponse response = this._latestManagementController.handlePost(request);
        return new ControllerManagementResponse(response.getType(), this.convertResponseObject(response.getBody()), response.getResponseCode(), response.getHeaders());
    }

    @Override
    public ManagementResponse handleDelete(ManagementRequest request) throws ManagementException {
        ManagementResponse response = this._latestManagementController.handleDelete(request);
        return new ControllerManagementResponse(response.getType(), this.convertResponseObject(response.getBody()), response.getResponseCode(), response.getHeaders());
    }

    @Override
    public Object get(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        Object result = this._latestManagementController.get(root, category, path, parameters);
        return this.convertResponseObject(result);
    }

    @Override
    public Object createOrUpdate(ConfiguredObject<?> root, String category, List<String> path, Map<String, Object> attributes, boolean isPost) throws ManagementException {
        Object result = this._latestManagementController.createOrUpdate(root, category, path, attributes, isPost);
        if (result instanceof ConfiguredObject) {
            return new LegacyConfiguredObjectObject((ConfiguredObject)result);
        }
        return null;
    }

    @Override
    public int delete(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this._latestManagementController.delete(root, category, path, parameters);
    }

    @Override
    public ManagementResponse invoke(ConfiguredObject<?> root, String category, List<String> path, String operationName, Map<String, Object> parameters, boolean isPost, boolean isSecureOrAllowedOnInsecureChannel) throws ManagementException {
        ManagementResponse response = this._latestManagementController.invoke(root, category, path, operationName, parameters, isPost, isSecureOrAllowedOnInsecureChannel);
        if (response.getType() == ResponseType.MODEL_OBJECT) {
            Set result = response.getBody();
            if (result instanceof ConfiguredObject) {
                result = new LegacyConfiguredObjectObject((ConfiguredObject)result);
            } else if (result instanceof Collection) {
                result = ((Collection)result).stream().map(o -> new LegacyConfiguredObjectObject((ConfiguredObject)o)).collect(Collectors.toSet());
            }
            return new ControllerManagementResponse(ResponseType.MODEL_OBJECT, result);
        }
        return response;
    }

    @Override
    public Object getPreferences(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this._latestManagementController.getPreferences(root, category, path, parameters);
    }

    @Override
    public void setPreferences(ConfiguredObject<?> root, String category, List<String> path, Object preferences, Map<String, List<String>> parameters, boolean isPost) throws ManagementException {
        this._latestManagementController.setPreferences(root, category, path, preferences, parameters, isPost);
    }

    @Override
    public int deletePreferences(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this._latestManagementController.delete(root, category, path, parameters);
    }

    @Override
    public Object formatConfiguredObject(Object data, Map<String, List<String>> parameters, boolean isSecureOrAllowedOnInsecureChannel) {
        Object content = data;
        if (content instanceof LegacyConfiguredObjectObject) {
            content = ((LegacyConfiguredObjectObject)data).getConfiguredObject();
        } else if (data instanceof Collection) {
            content = ((Collection)data).stream().filter(o -> o instanceof LegacyConfiguredObjectObject).map(LegacyConfiguredObjectObject.class::cast).map(LegacyConfiguredObjectObject::getConfiguredObject).collect(Collectors.toSet());
        }
        return this._latestManagementController.formatConfiguredObject(content, parameters, isSecureOrAllowedOnInsecureChannel);
    }

    private Class<? extends ConfiguredObject> getRequestCategoryClass(String categoryName, Model model) {
        for (Class category : model.getSupportedCategories()) {
            if (!category.getSimpleName().toLowerCase().equals(categoryName)) continue;
            return category;
        }
        throw ManagementException.createNotFoundManagementException(String.format("Category is not found for '%s'", categoryName));
    }

    private Object convertResponseObject(Object result) {
        if (result instanceof ConfiguredObject) {
            return new LegacyConfiguredObjectObject((ConfiguredObject)result);
        }
        if (result instanceof Collection) {
            return ((Collection)result).stream().filter(o -> o instanceof ConfiguredObject).map(ConfiguredObject.class::cast).map(o -> new LegacyConfiguredObjectObject((ConfiguredObject<?>)o)).collect(Collectors.toSet());
        }
        return result;
    }

    private class LegacyConfiguredObjectObject
    implements LegacyConfiguredObject {
        private final Map<String, Object> _actualAttributes;
        private ConfiguredObject<?> _configuredObject;

        LegacyConfiguredObjectObject(ConfiguredObject<?> configuredObject) {
            this._configuredObject = configuredObject;
            this._actualAttributes = configuredObject.getActualAttributes();
        }

        @Override
        public Collection<String> getAttributeNames() {
            return this._configuredObject.getAttributeNames();
        }

        @Override
        public Object getAttribute(String name) {
            return this.convertIntoLegacyIfRequired(name, this._configuredObject.getAttribute(name));
        }

        @Override
        public Object getActualAttribute(String name) {
            return this._actualAttributes.get(name);
        }

        @Override
        public Collection<LegacyConfiguredObject> getChildren(String category) {
            Class categoryClass = LatestManagementControllerAdapter.this.getRequestCategoryClass(category.toLowerCase(), this._configuredObject.getModel());
            return this._configuredObject.getChildren(categoryClass).stream().map(x$0 -> new LegacyConfiguredObjectObject((ConfiguredObject<?>)x$0)).collect(Collectors.toSet());
        }

        @Override
        public String getCategory() {
            return this._configuredObject.getCategoryClass().getSimpleName();
        }

        @Override
        public ManagementResponse invoke(String operationName, Map<String, Object> parameters, boolean isSecure) {
            try {
                ResponseType responseType;
                Model model = this._configuredObject.getModel();
                Map availableOperations = model.getTypeRegistry().getOperations(this._configuredObject.getClass());
                ConfiguredObjectOperation operation = (ConfiguredObjectOperation)availableOperations.get(operationName);
                if (operation == null) {
                    throw ManagementException.createNotFoundManagementException(String.format("No such operation as '%s' in '%s'", operationName, this.getCategory()));
                }
                Set returnValue = operation.perform(this._configuredObject, parameters);
                if (ConfiguredObject.class.isAssignableFrom(operation.getReturnType())) {
                    returnValue = new LegacyConfiguredObjectObject((ConfiguredObject)returnValue);
                    responseType = ResponseType.MODEL_OBJECT;
                } else if (ConfiguredObjectTypeRegistry.returnsCollectionOfConfiguredObjects((ConfiguredObjectOperation)operation)) {
                    returnValue = ((Collection)returnValue).stream().map(o -> new LegacyConfiguredObjectObject((ConfiguredObject)o)).collect(Collectors.toSet());
                    responseType = ResponseType.MODEL_OBJECT;
                } else {
                    responseType = ResponseType.DATA;
                }
                return new ControllerManagementResponse(responseType, returnValue);
            }
            catch (RuntimeException e) {
                throw ManagementException.toManagementException(e, LatestManagementControllerAdapter.this.getCategoryMapping(this.getCategory()), Collections.emptyList());
            }
            catch (Error e) {
                throw ManagementException.handleError(e);
            }
        }

        @Override
        public LegacyConfiguredObject getNextVersionConfiguredObject() {
            return null;
        }

        @Override
        public LegacyConfiguredObject getParent(String category) {
            ConfiguredObject parent = this._configuredObject.getParent();
            if (category != null && !parent.getCategoryClass().getSimpleName().equalsIgnoreCase(category)) {
                throw new IllegalArgumentException(String.format("ConfiguredObject of category '%s' has no parent of category %s", this.getCategory(), category));
            }
            return new LegacyConfiguredObjectObject(parent);
        }

        @Override
        public boolean isSecureAttribute(String name) {
            ConfiguredObjectAttribute<?, ?> objectAttribute = this.getConfiguredObjectAttribute(name);
            return objectAttribute != null && objectAttribute.isSecure();
        }

        @Override
        public boolean isOversizedAttribute(String name) {
            ConfiguredObjectAttribute<?, ?> objectAttribute = this.getConfiguredObjectAttribute(name);
            return objectAttribute != null && objectAttribute.isOversized();
        }

        @Override
        public String getContextValue(String contextKey) {
            return (String)this._configuredObject.getContextValue(String.class, contextKey);
        }

        @Override
        public Map<String, Object> getStatistics() {
            return this._configuredObject.getStatistics();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LegacyConfiguredObjectObject object = (LegacyConfiguredObjectObject)o;
            return Objects.equals(this._configuredObject, object._configuredObject);
        }

        public int hashCode() {
            return this._configuredObject.hashCode();
        }

        ConfiguredObject<?> getConfiguredObject() {
            return this._configuredObject;
        }

        private Object convertIntoLegacyIfRequired(String name, Object value) {
            if (value != null) {
                ConfiguredObjectAttribute<?, ?> attribute = this.getConfiguredObjectAttribute(name);
                Class type = attribute.getType();
                Type genericType = attribute.getGenericType();
                if (ConfiguredObject.class.isAssignableFrom(type)) {
                    return new LegacyConfiguredObjectObject((ConfiguredObject)value);
                }
                if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && ConfiguredObject.class.isAssignableFrom(ConfiguredObjectTypeRegistry.getCollectionMemberType((ParameterizedType)((ParameterizedType)genericType)))) {
                    Collection collection = (Collection)value;
                    return collection.stream().filter(o -> o instanceof LegacyConfiguredObjectObject).map(LegacyConfiguredObjectObject.class::cast).map(co -> new LegacyConfiguredObjectObject((ConfiguredObject)co)).collect(Collectors.toSet());
                }
            }
            return value;
        }

        private ConfiguredObjectAttribute<?, ?> getConfiguredObjectAttribute(String name) {
            return (ConfiguredObjectAttribute)this._configuredObject.getModel().getTypeRegistry().getAttributeTypes(this._configuredObject.getClass()).get(name);
        }
    }
}

