/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementRequest;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.RequestType;
import org.apache.qpid.server.management.plugin.ResponseType;
import org.apache.qpid.server.management.plugin.controller.ControllerManagementResponse;
import org.apache.qpid.server.management.plugin.controller.ConverterHelper;

public abstract class AbstractManagementController
implements ManagementController {
    protected static final String USER_PREFERENCES = "userpreferences";
    protected static final String VISIBLE_USER_PREFERENCES = "visiblepreferences";

    @Override
    public ManagementResponse handleGet(ManagementRequest request) throws ManagementException {
        RequestType type = this.getRequestType(request);
        switch (type) {
            case OPERATION: {
                Collection<String> hierarchy = this.getCategoryHierarchy(request.getRoot(), request.getCategory());
                List<String> operationPath = request.getPath().subList(0, hierarchy.size());
                String operationName = request.getPath().get(hierarchy.size());
                return this.invoke(request.getRoot(), request.getCategory(), operationPath, operationName, request.getParametersAsFlatMap(), false, request.isSecure() || request.isConfidentialOperationAllowedOnInsecureChannel());
            }
            case MODEL_OBJECT: {
                Object response = this.get(request.getRoot(), request.getCategory(), request.getPath(), request.getParameters());
                return new ControllerManagementResponse(ResponseType.MODEL_OBJECT, response);
            }
            case VISIBLE_PREFERENCES: 
            case USER_PREFERENCES: {
                Object response = this.getPreferences(request.getRoot(), request.getCategory(), request.getPath(), request.getParameters());
                return new ControllerManagementResponse(ResponseType.DATA, response);
            }
        }
        throw ManagementException.createBadRequestManagementException(String.format("Unexpected request type '%s' for path '%s'", new Object[]{type, this.getCategoryMapping(request.getCategory())}));
    }

    @Override
    public ManagementResponse handlePut(ManagementRequest request) throws ManagementException {
        return this.handlePostOrPut(request);
    }

    @Override
    public ManagementResponse handlePost(ManagementRequest request) throws ManagementException {
        return this.handlePostOrPut(request);
    }

    @Override
    public ManagementResponse handleDelete(ManagementRequest request) throws ManagementException {
        RequestType type = this.getRequestType(request);
        switch (type) {
            case MODEL_OBJECT: {
                this.delete(request.getRoot(), request.getCategory(), request.getPath(), request.getParameters());
                break;
            }
            case VISIBLE_PREFERENCES: 
            case USER_PREFERENCES: {
                this.deletePreferences(request.getRoot(), request.getCategory(), request.getPath(), request.getParameters());
                break;
            }
            default: {
                throw ManagementException.createBadRequestManagementException(String.format("Unexpected request type '%s' for path '%s'", new Object[]{type, this.getCategoryMapping(request.getCategory())}));
            }
        }
        return new ControllerManagementResponse(ResponseType.EMPTY, null);
    }

    private ManagementResponse handlePostOrPut(ManagementRequest request) throws ManagementException {
        RequestType type = this.getRequestType(request);
        Collection<String> hierarchy = this.getCategoryHierarchy(request.getRoot(), request.getCategory());
        switch (type) {
            case OPERATION: {
                List<String> operationPath = request.getPath().subList(0, hierarchy.size());
                String operationName = request.getPath().get(hierarchy.size());
                Map arguments = request.getBody(LinkedHashMap.class);
                return this.invoke(request.getRoot(), request.getCategory(), operationPath, operationName, arguments, true, request.isSecure() || request.isConfidentialOperationAllowedOnInsecureChannel());
            }
            case MODEL_OBJECT: {
                Map attributes = request.getBody(LinkedHashMap.class);
                Object response = this.createOrUpdate(request.getRoot(), request.getCategory(), request.getPath(), attributes, "POST".equalsIgnoreCase(request.getMethod()));
                int responseCode = 200;
                ResponseType responseType = ResponseType.EMPTY;
                Map<String, String> headers = Collections.emptyMap();
                if (response != null) {
                    responseCode = 201;
                    StringBuilder requestURL = new StringBuilder(request.getRequestURL());
                    if (hierarchy.size() != request.getPath().size()) {
                        Object name = attributes.get("name");
                        requestURL.append("/").append(ConverterHelper.encode(String.valueOf(name)));
                    }
                    headers = Collections.singletonMap("Location", requestURL.toString());
                    responseType = ResponseType.MODEL_OBJECT;
                }
                return new ControllerManagementResponse(responseType, response, responseCode, headers);
            }
            case VISIBLE_PREFERENCES: 
            case USER_PREFERENCES: {
                this.setPreferences(request.getRoot(), request.getCategory(), request.getPath(), request.getBody(Object.class), request.getParameters(), "POST".equalsIgnoreCase(request.getMethod()));
                return new ControllerManagementResponse(ResponseType.EMPTY, null);
            }
        }
        throw ManagementException.createBadRequestManagementException(String.format("Unexpected request type '%s' for path '%s'", new Object[]{type, this.getCategoryMapping(request.getCategory())}));
    }

    protected abstract RequestType getRequestType(ManagementRequest var1) throws ManagementException;
}

