/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.v1_0.AMQPConnection_1_0;
import org.apache.qpid.server.protocol.v1_0.AbstractReceivingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.AnonymousRelayDestination;
import org.apache.qpid.server.protocol.v1_0.ConsumerTarget_1_0;
import org.apache.qpid.server.protocol.v1_0.ErrantLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.ExchangeSendingDestination;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.NodeReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.SequenceNumber;
import org.apache.qpid.server.protocol.v1_0.SessionState;
import org.apache.qpid.server.protocol.v1_0.StandardReceivingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.StandardSendingDestination;
import org.apache.qpid.server.protocol.v1_0.UnknownTransactionException;
import org.apache.qpid.server.protocol.v1_0.delivery.DeliveryRegistry;
import org.apache.qpid.server.protocol.v1_0.delivery.DeliveryRegistryImpl;
import org.apache.qpid.server.protocol.v1_0.delivery.UnsettledDelivery;
import org.apache.qpid.server.protocol.v1_0.framing.OversizeFrameException;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.ErrorCondition;
import org.apache.qpid.server.protocol.v1_0.type.FrameBody;
import org.apache.qpid.server.protocol.v1_0.type.LifetimePolicy;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeleteOnClose;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeleteOnNoLinks;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeleteOnNoLinksOrMessages;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeleteOnNoMessages;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.StdDistMode;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Terminus;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Begin;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Disposition;
import org.apache.qpid.server.protocol.v1_0.type.transport.End;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;
import org.apache.qpid.server.protocol.v1_0.type.transport.LinkError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.protocol.v1_0.type.transport.SessionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;
import org.apache.qpid.server.queue.CreatingLinkInfoImpl;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.session.AbstractAMQPSession;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.Deletable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session_1_0
extends AbstractAMQPSession<Session_1_0, ConsumerTarget_1_0>
implements LogSubject,
Deletable<Session_1_0> {
    static final Symbol DELAYED_DELIVERY = Symbol.valueOf("DELAYED_DELIVERY");
    static final Symbol SHARED_CAPABILITY = Symbol.getSymbol("shared");
    static final Symbol GLOBAL_CAPABILITY = Symbol.getSymbol("global");
    private static final Logger LOGGER = LoggerFactory.getLogger(Session_1_0.class);
    public static final Symbol LIFETIME_POLICY = Symbol.valueOf("lifetime-policy");
    private static final EnumSet<SessionState> END_STATES = EnumSet.of(SessionState.END_RECVD, SessionState.END_PIPE, SessionState.END_SENT, SessionState.ENDED);
    private final AMQPConnection_1_0<?> _connection;
    private final AtomicBoolean _closed = new AtomicBoolean();
    private SessionState _sessionState;
    private final Map<LinkEndpoint<? extends BaseSource, ? extends BaseTarget>, UnsignedInteger> _endpointToOutputHandle = new HashMap<LinkEndpoint<? extends BaseSource, ? extends BaseTarget>, UnsignedInteger>();
    private final Map<UnsignedInteger, LinkEndpoint<? extends BaseSource, ? extends BaseTarget>> _inputHandleToEndpoint = new HashMap<UnsignedInteger, LinkEndpoint<? extends BaseSource, ? extends BaseTarget>>();
    private final Set<LinkEndpoint<? extends BaseSource, ? extends BaseTarget>> _associatedLinkEndpoints = new HashSet<LinkEndpoint<? extends BaseSource, ? extends BaseTarget>>();
    private final int _sendingChannel;
    private static final int DEFAULT_SESSION_BUFFER_SIZE = 2048;
    private int _nextOutgoingDeliveryId;
    private final UnsignedInteger _initialOutgoingId = UnsignedInteger.ZERO;
    private SequenceNumber _nextIncomingId;
    private final UnsignedInteger _incomingWindow;
    private final SequenceNumber _nextOutgoingId = new SequenceNumber(this._initialOutgoingId.intValue());
    private final UnsignedInteger _outgoingWindow = UnsignedInteger.valueOf(2048);
    private volatile long _remoteIncomingWindow;
    private UnsignedInteger _remoteOutgoingWindow = UnsignedInteger.ZERO;
    private UnsignedInteger _lastSentIncomingLimit;
    private final DeliveryRegistry _outgoingDeliveryRegistry = new DeliveryRegistryImpl();
    private final DeliveryRegistry _incomingDeliveryRegistry = new DeliveryRegistryImpl();
    private final Error _sessionEndedLinkError = new Error(LinkError.DETACH_FORCED, "Force detach the link because the session is remotely ended.");
    private final String _primaryDomain;
    private final Set<Object> _blockingEntities = Collections.newSetFromMap(new ConcurrentHashMap());

    public Session_1_0(AMQPConnection_1_0 connection, Begin begin, int sendingChannelId, int receivingChannelId, long incomingWindow) {
        super((Connection)connection, sendingChannelId);
        this._sendingChannel = sendingChannelId;
        this._sessionState = SessionState.ACTIVE;
        this._nextIncomingId = new SequenceNumber(begin.getNextOutgoingId().intValue());
        this._connection = connection;
        this._primaryDomain = this.getPrimaryDomain();
        this._incomingWindow = UnsignedInteger.valueOf(incomingWindow);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Session_1_0.this._connection.getEventLogger().message(ChannelMessages.CREATE());
                return null;
            }
        }, this._accessControllerContext);
    }

    public void sendDetach(Detach detach) {
        this.send(detach);
    }

    public void receiveAttach(Attach attach) {
        this.receivedComplete();
        if (this._sessionState == SessionState.ACTIVE) {
            UnsignedInteger inputHandle = attach.getHandle();
            if (this._inputHandleToEndpoint.containsKey(inputHandle)) {
                String errorMessage = String.format("Input Handle '%d' already in use", inputHandle.intValue());
                this.getConnection().close(new Error(SessionError.HANDLE_IN_USE, errorMessage));
                throw new ConnectionScopedRuntimeException(errorMessage);
            }
            Link_1_0 link = attach.getRole() == Role.RECEIVER ? (Link_1_0)this.getAddressSpace().getSendingLink(this.getConnection().getRemoteContainerId(), attach.getName()) : (Link_1_0)this.getAddressSpace().getReceivingLink(this.getConnection().getRemoteContainerId(), attach.getName());
            ListenableFuture future = link.attach(this, attach);
            Session_1_0.addFutureCallback(future, new EndpointCreationCallback(attach), (Executor)MoreExecutors.directExecutor());
        }
    }

    private void updateDisposition(Role role, UnsignedInteger first, UnsignedInteger last, DeliveryState state, boolean settled) {
        Disposition disposition = new Disposition();
        disposition.setRole(role);
        disposition.setFirst(first);
        disposition.setLast(last);
        disposition.setSettled(settled);
        disposition.setState(state);
        if (settled) {
            DeliveryRegistry deliveryRegistry = role == Role.RECEIVER ? this._incomingDeliveryRegistry : this._outgoingDeliveryRegistry;
            SequenceNumber pos = new SequenceNumber(first.intValue());
            SequenceNumber end = new SequenceNumber(last.intValue());
            while (pos.compareTo(end) <= 0) {
                deliveryRegistry.removeDelivery(UnsignedInteger.valueOf(pos.intValue()));
                pos.incr();
            }
        }
        this.send(disposition);
    }

    void updateDisposition(LinkEndpoint<?, ?> linkEndpoint, Binary deliveryTag, DeliveryState state, boolean settled) {
        UnsignedInteger deliveryId = this.getDeliveryId(deliveryTag, linkEndpoint);
        this.updateDisposition(linkEndpoint.getRole(), deliveryId, deliveryId, state, settled);
    }

    private UnsignedInteger getDeliveryId(DeliveryRegistry deliveryRegistry, Binary deliveryTag, LinkEndpoint<?, ?> linkEndpoint) {
        UnsignedInteger deliveryId = deliveryRegistry.getDeliveryId(deliveryTag, linkEndpoint);
        if (deliveryId == null) {
            throw new ConnectionScopedRuntimeException(String.format("Delivery with tag '%s' is not found in unsettled deliveries", deliveryTag));
        }
        return deliveryId;
    }

    private SortedSet<UnsignedInteger> getDeliveryIds(Set<Binary> deliveryTags, LinkEndpoint<?, ?> linkEndpoint) {
        DeliveryRegistry deliveryRegistry = this.getDeliveryRegistry(linkEndpoint.getRole());
        return deliveryTags.stream().map(deliveryTag -> this.getDeliveryId(deliveryRegistry, (Binary)deliveryTag, linkEndpoint)).collect(Collectors.toCollection(TreeSet::new));
    }

    private UnsignedInteger getDeliveryId(Binary deliveryTag, LinkEndpoint<?, ?> linkEndpoint) {
        DeliveryRegistry deliveryRegistry = this.getDeliveryRegistry(linkEndpoint.getRole());
        return this.getDeliveryId(deliveryRegistry, deliveryTag, linkEndpoint);
    }

    private DeliveryRegistry getDeliveryRegistry(Role role) {
        return role == Role.RECEIVER ? this.getIncomingDeliveryRegistry() : this.getOutgoingDeliveryRegistry();
    }

    void updateDisposition(LinkEndpoint<?, ?> linkEndpoint, Set<Binary> deliveryTags, DeliveryState state, boolean settled) {
        Role role = linkEndpoint.getRole();
        Iterator iterator = this.getDeliveryIds(deliveryTags, linkEndpoint).iterator();
        if (iterator.hasNext()) {
            UnsignedInteger begin;
            UnsignedInteger end = begin = (UnsignedInteger)iterator.next();
            while (iterator.hasNext()) {
                UnsignedInteger deliveryId = (UnsignedInteger)iterator.next();
                if (!end.add(UnsignedInteger.ONE).equals(deliveryId)) {
                    this.updateDisposition(role, begin, end, state, settled);
                    end = begin = deliveryId;
                    continue;
                }
                end = deliveryId;
            }
            this.updateDisposition(role, begin, end, state, settled);
        }
    }

    public boolean hasCreditToSend() {
        boolean b = this._remoteIncomingWindow > 0L;
        boolean b1 = this.getOutgoingWindow() != null && this.getOutgoingWindow().compareTo(UnsignedInteger.ZERO) > 0;
        return b && b1;
    }

    public void end() {
        this.end(new End());
    }

    void sendTransfer(Transfer xfr, SendingLinkEndpoint endpoint) {
        this._nextOutgoingId.incr();
        boolean settled = Boolean.TRUE.equals(xfr.getSettled());
        UnsignedInteger deliveryId = UnsignedInteger.valueOf(this._nextOutgoingDeliveryId++);
        xfr.setDeliveryId(deliveryId);
        if (!settled) {
            UnsettledDelivery delivery = new UnsettledDelivery(xfr.getDeliveryTag(), endpoint);
            this._outgoingDeliveryRegistry.addDelivery(deliveryId, delivery);
        }
        --this._remoteIncomingWindow;
        try (QpidByteBuffer payload = xfr.getPayload();){
            long remaining = payload == null ? 0L : (long)payload.remaining();
            int payloadSent = this._connection.sendFrame(this._sendingChannel, xfr, payload);
            if (payload != null) {
                while ((long)payloadSent < remaining && payloadSent >= 0) {
                    Transfer continuationTransfer = new Transfer();
                    continuationTransfer.setHandle(xfr.getHandle());
                    continuationTransfer.setRcvSettleMode(xfr.getRcvSettleMode());
                    continuationTransfer.setState(xfr.getState());
                    continuationTransfer.setPayload(payload);
                    this._nextOutgoingId.incr();
                    --this._remoteIncomingWindow;
                    remaining = payload.remaining();
                    payloadSent = this._connection.sendFrame(this._sendingChannel, continuationTransfer, payload);
                    continuationTransfer.dispose();
                }
            }
        }
        catch (OversizeFrameException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }

    public boolean isActive() {
        return this._sessionState == SessionState.ACTIVE;
    }

    public void receiveEnd(End end) {
        this.receivedComplete();
        switch (this._sessionState) {
            case END_SENT: {
                this.remoteEnd(end);
                this._sessionState = SessionState.ENDED;
                break;
            }
            case ACTIVE: {
                this._sessionState = SessionState.END_RECVD;
                this.detachLinks();
                this.remoteEnd(end);
                this._connection.sendEnd(this._sendingChannel, new End(), true);
                this._sessionState = SessionState.ENDED;
                break;
            }
            default: {
                End reply = new End();
                Error error = new Error();
                error.setCondition(AmqpError.ILLEGAL_STATE);
                error.setDescription("END called on Session which has not been opened");
                reply.setError(error);
                this._connection.sendEnd(this._sendingChannel, reply, true);
            }
        }
    }

    public UnsignedInteger getNextOutgoingId() {
        return UnsignedInteger.valueOf(this._nextOutgoingId.intValue());
    }

    public void sendFlowConditional() {
        UnsignedInteger clientsCredit;
        if (this._nextIncomingId != null && this._incomingWindow.subtract(clientsCredit = this._lastSentIncomingLimit.subtract(UnsignedInteger.valueOf(this._nextIncomingId.intValue()))).compareTo(clientsCredit) >= 0) {
            this.sendFlow();
        }
    }

    public UnsignedInteger getOutgoingWindow() {
        return this._outgoingWindow;
    }

    public void receiveFlow(Flow flow) {
        this.receivedComplete();
        SequenceNumber flowNextIncomingId = new SequenceNumber(flow.getNextIncomingId() == null ? this._initialOutgoingId.intValue() : flow.getNextIncomingId().intValue());
        if (flowNextIncomingId.compareTo(this._nextOutgoingId) > 0) {
            End end = new End();
            end.setError(new Error(SessionError.WINDOW_VIOLATION, String.format("Next incoming id '%d' exceeds next outgoing id '%d'", flowNextIncomingId.longValue(), this._nextOutgoingId.longValue())));
            this.end(end);
        } else {
            this._remoteIncomingWindow = flowNextIncomingId.longValue() + flow.getIncomingWindow().longValue() - this._nextOutgoingId.longValue();
            this._nextIncomingId = new SequenceNumber(flow.getNextOutgoingId().intValue());
            this._remoteOutgoingWindow = flow.getOutgoingWindow();
            UnsignedInteger handle = flow.getHandle();
            if (handle != null) {
                LinkEndpoint<? extends BaseSource, ? extends BaseTarget> endpoint = this._inputHandleToEndpoint.get(handle);
                if (endpoint == null) {
                    End end = new End();
                    end.setError(new Error(SessionError.UNATTACHED_HANDLE, String.format("Received Flow with unknown handle %d", handle.intValue())));
                    this.end(end);
                } else {
                    endpoint.receiveFlow(flow);
                }
            } else {
                Collection<LinkEndpoint<? extends BaseSource, ? extends BaseTarget>> allLinkEndpoints = this._inputHandleToEndpoint.values();
                for (LinkEndpoint<? extends BaseSource, ? extends BaseTarget> le : allLinkEndpoints) {
                    le.flowStateChanged();
                }
                if (Boolean.TRUE.equals(flow.getEcho())) {
                    this.sendFlow();
                }
            }
        }
    }

    public void receiveDisposition(Disposition disposition) {
        Role dispositionRole = disposition.getRole();
        DeliveryRegistry unsettledDeliveries = dispositionRole == Role.RECEIVER ? this._outgoingDeliveryRegistry : this._incomingDeliveryRegistry;
        SequenceNumber deliveryId = new SequenceNumber(disposition.getFirst().intValue());
        SequenceNumber last = disposition.getLast() == null ? new SequenceNumber(deliveryId.intValue()) : new SequenceNumber(disposition.getLast().intValue());
        while (deliveryId.compareTo(last) <= 0) {
            UnsignedInteger deliveryIdUnsigned = UnsignedInteger.valueOf(deliveryId.intValue());
            UnsettledDelivery unsettledDelivery = unsettledDeliveries.getDelivery(deliveryIdUnsigned);
            if (unsettledDelivery != null) {
                LinkEndpoint<?, ?> linkEndpoint = unsettledDelivery.getLinkEndpoint();
                linkEndpoint.receiveDeliveryState(unsettledDelivery.getDeliveryTag(), disposition.getState(), disposition.getSettled());
                if (Boolean.TRUE.equals(disposition.getSettled())) {
                    unsettledDeliveries.removeDelivery(deliveryIdUnsigned);
                }
            }
            deliveryId.incr();
        }
    }

    public SessionState getSessionState() {
        return this._sessionState;
    }

    public void sendFlow() {
        this.sendFlow(new Flow());
    }

    public void sendFlow(Flow flow) {
        if (this._nextIncomingId != null) {
            flow.setNextIncomingId(this._nextIncomingId.unsignedIntegerValue());
            this._lastSentIncomingLimit = this._incomingWindow.add(this._nextIncomingId.unsignedIntegerValue());
        }
        flow.setIncomingWindow(this._incomingWindow);
        flow.setNextOutgoingId(UnsignedInteger.valueOf(this._nextOutgoingId.intValue()));
        flow.setOutgoingWindow(this._outgoingWindow);
        this.send(flow);
    }

    public void receiveDetach(Detach detach) {
        this.receivedComplete();
        UnsignedInteger handle = detach.getHandle();
        this.detach(handle, detach);
    }

    public void sendAttach(Attach attach) {
        this.send(attach);
    }

    private void send(FrameBody frameBody) {
        this._connection.sendFrame(this._sendingChannel, frameBody);
    }

    public boolean isSyntheticError(Error error) {
        return error == this._sessionEndedLinkError;
    }

    public void end(End end) {
        switch (this._sessionState) {
            case BEGIN_SENT: {
                this._connection.sendEnd(this._sendingChannel, end, false);
                this._sessionState = SessionState.END_PIPE;
                break;
            }
            case ACTIVE: {
                this.detachLinks();
                this._connection.sendEnd(this._sendingChannel, end, true);
                this._sessionState = SessionState.END_SENT;
                break;
            }
            default: {
                End reply = new End();
                Error error = new Error();
                error.setCondition(AmqpError.ILLEGAL_STATE);
                error.setDescription("END called on Session which has not been opened");
                reply.setError(error);
                this._connection.sendEnd(this._sendingChannel, reply, true);
            }
        }
    }

    public void receiveTransfer(Transfer transfer) {
        this._nextIncomingId.incr();
        this._remoteOutgoingWindow = this._remoteOutgoingWindow.subtract(UnsignedInteger.ONE);
        UnsignedInteger inputHandle = transfer.getHandle();
        LinkEndpoint<? extends BaseSource, ? extends BaseTarget> linkEndpoint = this._inputHandleToEndpoint.get(inputHandle);
        if (linkEndpoint == null) {
            Error error = new Error();
            error.setCondition(SessionError.UNATTACHED_HANDLE);
            error.setDescription("TRANSFER called on Session for link handle " + inputHandle + " which is not attached.");
            this._connection.close(error);
        } else if (!(linkEndpoint instanceof AbstractReceivingLinkEndpoint)) {
            Error error = new Error();
            error.setCondition(AmqpError.PRECONDITION_FAILED);
            error.setDescription("Received TRANSFER for link handle " + inputHandle + " which is a sending link not a receiving link.");
            this._connection.close(error);
        } else {
            AbstractReceivingLinkEndpoint endpoint = (AbstractReceivingLinkEndpoint)linkEndpoint;
            endpoint.receiveTransfer(transfer);
        }
    }

    boolean isEnded() {
        return this._sessionState == SessionState.ENDED || this._connection.isClosed();
    }

    UnsignedInteger getIncomingWindow() {
        return this._incomingWindow;
    }

    AccessControlContext getAccessControllerContext() {
        return this._accessControllerContext;
    }

    public ReceivingDestination getReceivingDestination(Link_1_0<?, ?> link, Target target) throws AmqpErrorException {
        ReceivingDestination destination;
        if (target != null) {
            DestinationAddress destinationAddress;
            MessageDestination messageDestination;
            String addr;
            if (Boolean.TRUE.equals(target.getDynamic())) {
                MessageDestination tempDestination = this.createDynamicDestination(link, target);
                if (tempDestination != null) {
                    target.setAddress(this._primaryDomain + tempDestination.getName());
                } else {
                    throw new AmqpErrorException(AmqpError.INTERNAL_ERROR, "Cannot create dynamic destination", new Object[0]);
                }
            }
            destination = (addr = target.getAddress()) == null || "".equals(addr.trim()) ? new AnonymousRelayDestination(this.getAddressSpace(), target, this._connection.getEventLogger()) : ((messageDestination = (destinationAddress = new DestinationAddress(this.getAddressSpace(), addr, true)).getMessageDestination()) != null ? new NodeReceivingDestination(destinationAddress, target.getDurable(), target.getExpiryPolicy(), target.getCapabilities(), this._connection.getEventLogger()) : null);
        } else {
            destination = null;
        }
        if (destination == null) {
            throw new AmqpErrorException(AmqpError.NOT_FOUND, String.format("Could not find destination for target '%s'", target), new Object[0]);
        }
        return destination;
    }

    public boolean updateSourceForSubscription(SendingLinkEndpoint linkEndpoint, Source newSource, SendingDestination newDestination) {
        SendingDestination oldDestination = linkEndpoint.getDestination();
        if (oldDestination instanceof ExchangeSendingDestination) {
            ExchangeSendingDestination oldExchangeDestination = (ExchangeSendingDestination)oldDestination;
            String newAddress = newSource.getAddress();
            if (newDestination instanceof ExchangeSendingDestination) {
                ExchangeSendingDestination newExchangeDestination = (ExchangeSendingDestination)newDestination;
                if (oldExchangeDestination.getQueue() != newExchangeDestination.getQueue()) {
                    Source oldSource = (Source)linkEndpoint.getSource();
                    oldSource.setAddress(newAddress);
                    oldSource.setFilter(newSource.getFilter());
                    return true;
                }
            }
        }
        return false;
    }

    public SendingDestination getSendingDestination(Link_1_0<?, ?> link, Source source) throws AmqpErrorException {
        String address;
        StandardSendingDestination destination = null;
        if (Boolean.TRUE.equals(source.getDynamic())) {
            MessageSource tempSource = this.createDynamicSource(link, source);
            if (tempSource != null) {
                source.setAddress(this._primaryDomain + tempSource.getName());
            } else {
                throw new AmqpErrorException(AmqpError.INTERNAL_ERROR, "Cannot create dynamic source", new Object[0]);
            }
        }
        if ((address = source.getAddress()) != null) {
            MessageSource queue;
            destination = !address.startsWith("/") && address.contains("/") ? this.createExchangeDestination(address, link.getName(), source) : ((queue = this.getAddressSpace().getAttainedMessageSource(address)) != null ? new StandardSendingDestination(queue) : this.createExchangeDestination(address, null, link.getName(), source));
        }
        if (destination == null) {
            throw new AmqpErrorException(AmqpError.NOT_FOUND, String.format("Could not find destination for source '%s'", source), new Object[0]);
        }
        return destination;
    }

    private ExchangeSendingDestination createExchangeDestination(String address, String linkName, Source source) throws AmqpErrorException {
        String[] parts = address.split("/", 2);
        String exchangeName = parts[0];
        String bindingKey = parts[1];
        return this.createExchangeDestination(exchangeName, bindingKey, linkName, source);
    }

    private ExchangeSendingDestination createExchangeDestination(String exchangeName, String bindingKey, String linkName, Source source) throws AmqpErrorException {
        ExchangeSendingDestination exchangeDestination = null;
        Exchange<?> exchange = this.getExchange(exchangeName);
        if (exchange != null) {
            if (!Boolean.TRUE.equals(source.getDynamic())) {
                String remoteContainerId = this.getConnection().getRemoteContainerId();
                exchangeDestination = new ExchangeSendingDestination(exchange, linkName, bindingKey, remoteContainerId, source);
                source.setFilter(exchangeDestination.getFilters());
                source.setDistributionMode(StdDistMode.COPY);
            } else {
                throw new AmqpErrorException(new Error(AmqpError.NOT_IMPLEMENTED, "Temporary subscription is not implemented"));
            }
        }
        return exchangeDestination;
    }

    private MessageSource createDynamicSource(Link_1_0<?, ?> link, Terminus terminus) throws AmqpErrorException {
        String queueName = "TempQueue" + UUID.randomUUID().toString();
        try {
            HashSet capabilities;
            Map<String, Object> attributes = this.createDynamicNodeAttributes(link, terminus, queueName);
            if (terminus.getCapabilities() != null && ((capabilities = Sets.newHashSet((Object[])terminus.getCapabilities())).contains(Symbol.valueOf("temporary-queue")) || capabilities.contains(Symbol.valueOf("temporary-topic")))) {
                attributes.put("exclusive", ExclusivityPolicy.CONNECTION);
            }
            return Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> this.getAddressSpace().createMessageSource(MessageSource.class, attributes));
        }
        catch (AccessControlException e) {
            throw new AmqpErrorException(AmqpError.UNAUTHORIZED_ACCESS, e.getMessage(), new Object[0]);
        }
        catch (AbstractConfiguredObject.DuplicateNameException e) {
            LOGGER.error("A temporary queue was created with a name which collided with an existing queue name");
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }

    private MessageDestination createDynamicDestination(Link_1_0<?, ?> link, Terminus terminus) throws AmqpErrorException {
        Object[] capabilities = terminus.getCapabilities();
        HashSet capabilitySet = capabilities == null ? Collections.emptySet() : Sets.newHashSet((Object[])capabilities);
        boolean isTopic = capabilitySet.contains(Symbol.valueOf("temporary-topic")) || capabilitySet.contains(Symbol.valueOf("topic"));
        String destName = (isTopic ? "TempTopic" : "TempQueue") + UUID.randomUUID().toString();
        try {
            Class clazz;
            Map<String, Object> attributes = this.createDynamicNodeAttributes(link, terminus, destName);
            Class clazz2 = clazz = isTopic ? Exchange.class : MessageDestination.class;
            if (isTopic) {
                attributes.put("type", "fanout");
            } else if (capabilitySet.contains(Symbol.valueOf("temporary-queue"))) {
                attributes.put("exclusive", ExclusivityPolicy.CONNECTION);
            }
            return Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> this.getAddressSpace().createMessageDestination(clazz, attributes));
        }
        catch (AccessControlException e) {
            throw new AmqpErrorException(AmqpError.UNAUTHORIZED_ACCESS, e.getMessage(), new Object[0]);
        }
        catch (AbstractConfiguredObject.DuplicateNameException e) {
            LOGGER.error("A temporary destination was created with a name which collided with an existing destination name '{}'", (Object)destName);
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }

    private Map<String, Object> createDynamicNodeAttributes(Link_1_0<?, ?> link, Terminus terminus, String nodeName) {
        Map<Symbol, Object> properties = terminus.getDynamicNodeProperties();
        TerminusExpiryPolicy expiryPolicy = terminus.getExpiryPolicy();
        LifetimePolicy lifetimePolicy = properties == null ? null : (LifetimePolicy)properties.get(LIFETIME_POLICY);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("id", UUID.randomUUID());
        attributes.put("name", nodeName);
        attributes.put("durable", TerminusExpiryPolicy.NEVER.equals(expiryPolicy));
        if (lifetimePolicy instanceof DeleteOnNoLinks) {
            attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.DELETE_ON_NO_LINKS);
        } else if (lifetimePolicy instanceof DeleteOnNoLinksOrMessages) {
            attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.IN_USE);
        } else if (lifetimePolicy instanceof DeleteOnClose) {
            attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.DELETE_ON_CREATING_LINK_CLOSE);
            CreatingLinkInfoImpl linkInfo = new CreatingLinkInfoImpl(link.getRole() == Role.SENDER, link.getRemoteContainerId(), link.getName());
            attributes.put("creatingLinkInfo", linkInfo);
        } else if (lifetimePolicy instanceof DeleteOnNoMessages) {
            attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.IN_USE);
        } else {
            attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.DELETE_ON_CONNECTION_CLOSE);
        }
        return attributes;
    }

    ServerTransaction getTransaction(Binary transactionId) {
        int txnId;
        try {
            txnId = Session_1_0.transactionIdToInteger(transactionId);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownTransactionException(e.getMessage());
        }
        return this._connection.getTransaction(txnId);
    }

    void remoteEnd(End end) {
        HashSet<LinkEndpoint<? extends BaseSource, ? extends BaseTarget>> associatedLinkEndpoints = new HashSet<LinkEndpoint<? extends BaseSource, ? extends BaseTarget>>(this._associatedLinkEndpoints);
        for (LinkEndpoint linkEndpoint : associatedLinkEndpoints) {
            linkEndpoint.remoteDetached(new Detach());
            linkEndpoint.destroy();
        }
        this._associatedLinkEndpoints.clear();
        this._connection.sessionEnded(this);
        this.performCloseTasks();
    }

    static Integer transactionIdToInteger(Binary txnId) {
        if (txnId == null) {
            throw new UnknownTransactionException("'null' is not a valid transaction-id.");
        }
        byte[] data = txnId.getArray();
        if (data.length > 4) {
            throw new IllegalArgumentException("transaction-id cannot have more than 32-bit.");
        }
        int id = 0;
        for (int i = 0; i < data.length; ++i) {
            id <<= 8;
            id |= data[i] & 0xFF;
        }
        return id;
    }

    static Binary integerToTransactionId(int txnId) {
        byte[] data = new byte[4];
        data[3] = (byte)(txnId & 0xFF);
        data[2] = (byte)((txnId & 0xFF00) >> 8);
        data[1] = (byte)((txnId & 0xFF0000) >> 16);
        data[0] = (byte)((txnId & 0xFF000000) >> 24);
        return new Binary(data);
    }

    public void close() {
        this.performCloseTasks();
        this.end();
    }

    private void performCloseTasks() {
        if (this._closed.compareAndSet(false, true)) {
            ArrayList taskList = new ArrayList(this._taskList);
            this._taskList.clear();
            for (Action task : taskList) {
                task.performAction((Object)this);
            }
            this.getAMQPConnection().getEventLogger().message(this.getLogSubject(), ChannelMessages.CLOSE());
        }
    }

    public void close(ErrorCondition condition, String message) {
        this.performCloseTasks();
        End end = new End();
        Error theError = new Error();
        theError.setDescription(message);
        theError.setCondition(condition);
        end.setError(theError);
        this.end(end);
    }

    public void transportStateChanged() {
        for (LinkEndpoint<? extends BaseSource, ? extends BaseTarget> linkEndpoint : this._endpointToOutputHandle.keySet()) {
            if (!(linkEndpoint instanceof SendingLinkEndpoint)) continue;
            ConsumerTarget_1_0 target = ((SendingLinkEndpoint)linkEndpoint).getConsumerTarget();
            target.flowStateChanged();
        }
        if (!this._consumersWithPendingWork.isEmpty() && !this.getAMQPConnection().isTransportBlockedForWriting()) {
            this.getAMQPConnection().notifyWork((AMQPSession)this);
        }
    }

    public void block(Queue<?> queue) {
        this.getAMQPConnection().doOnIOThreadAsync(() -> this.doBlock(queue));
    }

    private void doBlock(Queue<?> queue) {
        if (this._blockingEntities.add(queue)) {
            this.messageWithSubject(ChannelMessages.FLOW_ENFORCED((String)queue.getName()));
            for (LinkEndpoint<? extends BaseSource, ? extends BaseTarget> linkEndpoint : this._endpointToOutputHandle.keySet()) {
                if (!(linkEndpoint instanceof StandardReceivingLinkEndpoint) || !this.isQueueDestinationForLink(queue, ((StandardReceivingLinkEndpoint)linkEndpoint).getReceivingDestination())) continue;
                linkEndpoint.setStopped(true);
            }
        }
    }

    private boolean isQueueDestinationForLink(Queue<?> queue, ReceivingDestination recvDest) {
        return recvDest instanceof NodeReceivingDestination && queue == ((NodeReceivingDestination)recvDest).getDestination();
    }

    public void unblock(Queue<?> queue) {
        this.getAMQPConnection().doOnIOThreadAsync(() -> this.doUnblock(queue));
    }

    private void doUnblock(Queue<?> queue) {
        if (this._blockingEntities.remove(queue) && !this._blockingEntities.contains((Object)this)) {
            if (this._blockingEntities.isEmpty()) {
                this.messageWithSubject(ChannelMessages.FLOW_REMOVED());
            }
            for (LinkEndpoint<? extends BaseSource, ? extends BaseTarget> linkEndpoint : this._endpointToOutputHandle.keySet()) {
                if (!(linkEndpoint instanceof StandardReceivingLinkEndpoint) || !this.isQueueDestinationForLink(queue, ((StandardReceivingLinkEndpoint)linkEndpoint).getReceivingDestination())) continue;
                linkEndpoint.setStopped(false);
            }
        }
    }

    public void block() {
        this.getAMQPConnection().doOnIOThreadAsync(this::doBlock);
    }

    private void doBlock() {
        if (this._blockingEntities.add((Object)this)) {
            this.messageWithSubject(ChannelMessages.FLOW_ENFORCED((String)"** All Queues **"));
            for (LinkEndpoint<? extends BaseSource, ? extends BaseTarget> linkEndpoint : this._endpointToOutputHandle.keySet()) {
                if (!(linkEndpoint instanceof StandardReceivingLinkEndpoint)) continue;
                linkEndpoint.setStopped(true);
            }
        }
    }

    public void unblock() {
        this.getAMQPConnection().doOnIOThreadAsync(this::doUnblock);
    }

    private void doUnblock() {
        if (this._blockingEntities.remove((Object)this)) {
            if (this._blockingEntities.isEmpty()) {
                this.messageWithSubject(ChannelMessages.FLOW_REMOVED());
            }
            for (LinkEndpoint<? extends BaseSource, ? extends BaseTarget> linkEndpoint : this._endpointToOutputHandle.keySet()) {
                if (!(linkEndpoint instanceof StandardReceivingLinkEndpoint) || this._blockingEntities.contains(((StandardReceivingLinkEndpoint)linkEndpoint).getReceivingDestination())) continue;
                linkEndpoint.setStopped(false);
            }
        }
    }

    public boolean getBlocking() {
        return !this._blockingEntities.isEmpty();
    }

    private void messageWithSubject(LogMessage operationalLogMessage) {
        this.getEventLogger().message(this.getLogSubject(), operationalLogMessage);
    }

    public Object getConnectionReference() {
        return this.getConnection().getReference();
    }

    public int getUnacknowledgedMessageCount() {
        return this._outgoingDeliveryRegistry.size();
    }

    public String toLogString() {
        return this.getLogSubject().toLogString();
    }

    public AMQPConnection_1_0<?> getConnection() {
        return this._connection;
    }

    public void addDeleteTask(Action<? super Session_1_0> task) {
        if (!this._closed.get()) {
            super.addDeleteTask(task);
        }
    }

    public Subject getSubject() {
        return this._subject;
    }

    private NamedAddressSpace getAddressSpace() {
        return this._connection.getAddressSpace();
    }

    public SecurityToken getSecurityToken() {
        return this._token;
    }

    public long getTransactionStartTimeLong() {
        return 0L;
    }

    public long getTransactionUpdateTimeLong() {
        return 0L;
    }

    protected void updateBlockedStateIfNecessary() {
    }

    public boolean isClosing() {
        return END_STATES.contains((Object)this.getSessionState()) || this.getConnection().isClosing();
    }

    public String toString() {
        return "Session_1_0[" + this._connection + ": " + this._sendingChannel + ']';
    }

    public void dissociateEndpoint(LinkEndpoint<? extends BaseSource, ? extends BaseTarget> linkEndpoint) {
        for (Map.Entry<UnsignedInteger, LinkEndpoint<? extends BaseSource, ? extends BaseTarget>> entry : this._inputHandleToEndpoint.entrySet()) {
            if (entry.getValue() != linkEndpoint) continue;
            this._inputHandleToEndpoint.remove(entry.getKey());
            break;
        }
        this._endpointToOutputHandle.remove(linkEndpoint);
        this._associatedLinkEndpoints.remove(linkEndpoint);
        if (linkEndpoint.getRole() == Role.RECEIVER) {
            this.getIncomingDeliveryRegistry().removeDeliveriesForLinkEndpoint(linkEndpoint);
        } else {
            this.getOutgoingDeliveryRegistry().removeDeliveriesForLinkEndpoint(linkEndpoint);
        }
    }

    private void detach(UnsignedInteger handle, Detach detach) {
        if (this._inputHandleToEndpoint.containsKey(handle)) {
            LinkEndpoint<? extends BaseSource, ? extends BaseTarget> endpoint = this._inputHandleToEndpoint.remove(handle);
            endpoint.remoteDetached(detach);
            this._endpointToOutputHandle.remove(endpoint);
            this._associatedLinkEndpoints.remove(endpoint);
        }
    }

    private void detachLinks() {
        ArrayList<UnsignedInteger> handles = new ArrayList<UnsignedInteger>(this._inputHandleToEndpoint.keySet());
        for (UnsignedInteger handle : handles) {
            Detach detach = new Detach();
            detach.setClosed(false);
            detach.setHandle(handle);
            detach.setError(this._sessionEndedLinkError);
            this.detach(handle, detach);
        }
    }

    private UnsignedInteger findNextAvailableOutputHandle() {
        int i = 0;
        do {
            if (this._endpointToOutputHandle.containsValue(UnsignedInteger.valueOf(i))) continue;
            return UnsignedInteger.valueOf(i);
        } while (++i != 0);
        return null;
    }

    private Exchange<?> getExchange(String name) {
        MessageDestination destination = this.getAddressSpace().getAttainedMessageDestination(name, false);
        return destination instanceof Exchange ? (Exchange)destination : null;
    }

    private Queue<?> getQueue(String name) {
        MessageSource source = this.getAddressSpace().getAttainedMessageSource(name);
        return source instanceof Queue ? (Queue)source : null;
    }

    private String getPrimaryDomain() {
        String primaryDomain = "";
        List globalAddressDomains = this.getAddressSpace().getGlobalAddressDomains();
        if (globalAddressDomains != null && !globalAddressDomains.isEmpty() && (primaryDomain = (String)globalAddressDomains.get(0)) != null && !(primaryDomain = primaryDomain.trim()).endsWith("/")) {
            primaryDomain = primaryDomain + "/";
        }
        return primaryDomain;
    }

    DeliveryRegistry getOutgoingDeliveryRegistry() {
        return this._outgoingDeliveryRegistry;
    }

    DeliveryRegistry getIncomingDeliveryRegistry() {
        return this._incomingDeliveryRegistry;
    }

    void receivedComplete() {
        this._associatedLinkEndpoints.forEach(linkedEnpoint -> linkedEnpoint.receiveComplete());
    }

    private void checkMessageDestinationFlowForReceivingLinkEndpoint(LinkEndpoint<?, ?> endpoint) {
        if (endpoint instanceof StandardReceivingLinkEndpoint) {
            Queue queue;
            ReceivingDestination destination = ((StandardReceivingLinkEndpoint)endpoint).getReceivingDestination();
            if (this._blockingEntities.contains((Object)this) || this._blockingEntities.contains(destination)) {
                endpoint.setStopped(true);
            } else if (destination.getMessageDestination() instanceof Queue && (queue = (Queue)destination.getMessageDestination()).isQueueFlowStopped()) {
                queue.checkCapacity();
            }
        }
    }

    private class EndpointCreationCallback<T extends LinkEndpoint<? extends BaseSource, ? extends BaseTarget>>
    implements FutureCallback<T> {
        private final Attach _attach;

        EndpointCreationCallback(Attach attach) {
            this._attach = attach;
        }

        public void onSuccess(T endpoint) {
            Session_1_0.this.doOnIOThreadAsync(() -> {
                Session_1_0.this._associatedLinkEndpoints.add(endpoint);
                Session_1_0.this._inputHandleToEndpoint.put(this._attach.getHandle(), endpoint);
                UnsignedInteger nextAvailableOutputHandle = Session_1_0.this.findNextAvailableOutputHandle();
                if (nextAvailableOutputHandle == null) {
                    endpoint.close(new Error(AmqpError.RESOURCE_LIMIT_EXCEEDED, String.format("Cannot find free handle for endpoint '%s' on session '%s'", this._attach.getName(), endpoint.getSession().toLogString())));
                } else {
                    endpoint.setLocalHandle(nextAvailableOutputHandle);
                    if (endpoint instanceof ErrantLinkEndpoint) {
                        endpoint.sendAttach();
                        ((ErrantLinkEndpoint)endpoint).closeWithError();
                    } else if (!Session_1_0.this._endpointToOutputHandle.containsKey(endpoint)) {
                        Session_1_0.this._endpointToOutputHandle.put(endpoint, endpoint.getLocalHandle());
                        Session_1_0.this.checkMessageDestinationFlowForReceivingLinkEndpoint(endpoint);
                        endpoint.sendAttach();
                        endpoint.start();
                    } else {
                        End end = new End();
                        end.setError(new Error(AmqpError.INTERNAL_ERROR, "Endpoint is already registered with session."));
                        endpoint.getSession().end(end);
                    }
                }
            });
        }

        public void onFailure(Throwable t) {
            String errorMessage = String.format("Failed to create LinkEndpoint in response to Attach: %s", this._attach);
            LOGGER.error(errorMessage, t);
            throw new ConnectionScopedRuntimeException(errorMessage, t);
        }
    }
}

