/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class OrphanConfigurationRecordPurger {
    private static final String USAGE_STRING = "usage: " + String.format("java %s\n       -dryRun                   # Dry run mode\n       -parentRootCategory <dir> # Parent root category\n       -storePath <dir>          # Store path\n       [-ha                      # HA mode\n        -nodeName <nodename>     # HA node name\n        -nodeHost <nodehost>     # HA node host\n        -groupName <groupName>]  # HA group name\n", OrphanConfigurationRecordPurger.class.getName());
    private static final String VERSION_DB_NAME = "DB_VERSION";
    private static final String CONFIGURED_OBJECTS_DB_NAME = "CONFIGURED_OBJECTS";
    private static final String CONFIGURED_OBJECT_HIERARCHY_DB_NAME = "CONFIGURED_OBJECT_HIERARCHY";
    private static final Set<Integer> ALLOWED_VERSIONS = new HashSet<Integer>(Arrays.asList(8, 9));
    private static final DatabaseConfig READ_ONLY_DB_CONFIG = DatabaseConfig.DEFAULT.setAllowCreate(false).setReadOnly(true).setTransactional(true);
    private static final DatabaseConfig READ_WRITE_DB_CONFIG = READ_ONLY_DB_CONFIG.setReadOnly(false);
    private String _parentRootCategory;
    private String _storePath;
    private boolean _dryRun;
    private boolean _ha;
    private String _nodeName;
    private String _nodeHost;
    private String _groupName;

    public static void main(String[] argv) throws Exception {
        OrphanConfigurationRecordPurger purger = new OrphanConfigurationRecordPurger();
        purger.parseArgs(argv);
        purger.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() throws Exception {
        EnvironmentConfig config = EnvironmentConfig.DEFAULT;
        config.setAllowCreate(false);
        config.setTransactional(true);
        try (Environment env = this.createEnvironment(config);){
            int version = this.getVersion(env, READ_ONLY_DB_CONFIG);
            if (!ALLOWED_VERSIONS.contains(version)) {
                throw new IllegalStateException(String.format("Store has unexpected version. Found %d expected %s", version, ALLOWED_VERSIONS));
            }
            Transaction tx = env.beginTransaction(null, TransactionConfig.DEFAULT);
            boolean success = false;
            try {
                this.purgeOrphans(env, tx);
                success = true;
            }
            finally {
                if (!success) {
                    System.out.println("No config or config hierarchy records purged.");
                    tx.abort();
                } else if (this._dryRun) {
                    System.out.println("No config or config hierarchy records purged - -dryRun flag specified.");
                    tx.abort();
                } else {
                    tx.commit();
                    System.out.format("Config records(s) and associated hierarchy records purged.", new Object[0]);
                }
            }
        }
    }

    private Environment createEnvironment(EnvironmentConfig config) throws Exception {
        Environment env;
        if (this._ha) {
            ReplicationConfig repConfig = (ReplicationConfig)ReplicationConfig.DEFAULT.setNodeHostPort(this._nodeHost).setGroupName(this._groupName).setNodeName(this._nodeName).setDesignatedPrimary(true).setElectableGroupSizeOverride(1);
            env = new ReplicatedEnvironment(new File(this._storePath), repConfig, config);
        } else {
            env = new Environment(new File(this._storePath), config);
        }
        return env;
    }

    /*
     * Exception decompiling
     */
    private int getVersion(Environment env, DatabaseConfig dbConfig) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void purgeOrphans(Environment env, Transaction tx) throws Exception {
        try (Database configDb = env.openDatabase(tx, CONFIGURED_OBJECTS_DB_NAME, READ_WRITE_DB_CONFIG);){
            HashSet<UUID> records = new HashSet<UUID>();
            try (Cursor configCursor = configDb.openCursor(tx, null);){
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry value = new DatabaseEntry();
                while (configCursor.getNext(key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    UUID recId = this.entryToUuid(new TupleInput(key.getData()));
                    records.add(recId);
                }
            }
            int configRecordDeleted = 0;
            int configHierarchyRecordsDeleted = 0;
            try (Database hierarchyDb = env.openDatabase(null, CONFIGURED_OBJECT_HIERARCHY_DB_NAME, READ_WRITE_DB_CONFIG);){
                boolean loopAgain;
                do {
                    loopAgain = false;
                    try (Cursor hierarchyCursor = hierarchyDb.openCursor(tx, null);){
                        DatabaseEntry key = new DatabaseEntry();
                        DatabaseEntry value = new DatabaseEntry();
                        boolean parentReferencingRecordFound = false;
                        while (hierarchyCursor.getNext(key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                            TupleInput keyInput = new TupleInput(key.getData());
                            UUID childId = this.entryToUuid(keyInput);
                            String parentType = keyInput.readString();
                            UUID parentId = this.entryToUuid(new TupleInput(value.getData()));
                            if (this._parentRootCategory.equals(parentType)) {
                                parentReferencingRecordFound = true;
                                continue;
                            }
                            if (records.contains(parentId)) continue;
                            System.out.format("Orphan UUID : %s (has unknown parent with UUID %s of type %s)\n", childId, parentId, parentType);
                            hierarchyCursor.delete();
                            ++configHierarchyRecordsDeleted;
                            loopAgain = true;
                            DatabaseEntry uuidKey = new DatabaseEntry();
                            TupleOutput tupleOutput = this.uuidToKey(childId);
                            TupleBase.outputToEntry((TupleOutput)tupleOutput, (DatabaseEntry)uuidKey);
                            OperationStatus delete = configDb.delete(tx, uuidKey);
                            if (delete != OperationStatus.SUCCESS) continue;
                            records.remove(childId);
                            ++configRecordDeleted;
                        }
                        if (!parentReferencingRecordFound) {
                            throw new IllegalStateException(String.format("No hierarchy record found with root category type (%s). Cannot modify store.", this._parentRootCategory));
                        }
                    }
                } while (loopAgain);
                System.out.format("Identified %d orphaned configured object record(s) and %d hierarchy records for purging\n", configRecordDeleted, configHierarchyRecordsDeleted);
            }
        }
    }

    private TupleOutput uuidToKey(UUID uuid) {
        DatabaseEntry key = new DatabaseEntry();
        TupleOutput output = new TupleOutput();
        output.writeLong(uuid.getMostSignificantBits());
        output.writeLong(uuid.getLeastSignificantBits());
        return output;
    }

    private UUID entryToUuid(TupleInput input) {
        long mostSigBits = input.readLong();
        long leastSigBits = input.readLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    private void parseArgs(String[] argv) {
        int argCount = argv.length;
        if (argCount == 0) {
            this.printUsage(null);
        }
        int argc = 0;
        block18: while (argc < argCount) {
            String thisArg;
            switch (thisArg = argv[argc++]) {
                case "-parentRootCategory": {
                    if (argc < argCount) {
                        this._parentRootCategory = argv[argc++];
                        continue block18;
                    }
                    this.printUsage("-parentRootCategory requires an argument");
                    continue block18;
                }
                case "-storePath": {
                    if (argc < argCount) {
                        this._storePath = argv[argc++];
                        continue block18;
                    }
                    this.printUsage("-storePath requires an argument");
                    continue block18;
                }
                case "-ha": {
                    this._ha = true;
                    continue block18;
                }
                case "-nodeName": {
                    if (argc < argCount) {
                        this._nodeName = argv[argc++];
                        continue block18;
                    }
                    this.printUsage("-nodeName requires an argument");
                    continue block18;
                }
                case "-nodeHost": {
                    if (argc < argCount) {
                        this._nodeHost = argv[argc++];
                        continue block18;
                    }
                    this.printUsage("-nodeHost requires an argument");
                    continue block18;
                }
                case "-groupName": {
                    if (argc < argCount) {
                        this._groupName = argv[argc++];
                        continue block18;
                    }
                    this.printUsage("-groupName requires an argument");
                    continue block18;
                }
                case "-dryRun": {
                    this._dryRun = true;
                    continue block18;
                }
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
        if (this._storePath == null) {
            this.printUsage("-storePath is a required argument");
        }
        if (this._parentRootCategory == null) {
            this.printUsage("-parentRootCategory is a required argument");
        }
        if (this._ha) {
            if (this._nodeName == null) {
                this.printUsage("-nodeName is a required argument when in ha mode");
            }
            if (this._nodeHost == null) {
                this.printUsage("-nodeHost is a required argument when in ha mode");
            }
            if (this._groupName == null) {
                this.printUsage("-groupName is a required argument when in ha mode");
            }
        }
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE_STRING);
        System.exit(-1);
    }
}

