/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.store.ConfiguredObjectRecord;

public class BDBConfiguredObjectRecord
implements ConfiguredObjectRecord {
    private final UUID _id;
    private final String _type;
    private final Map<String, Object> _attributes;
    private Map<String, UUID> _parents = new HashMap<String, UUID>();

    public BDBConfiguredObjectRecord(UUID id, String type, Map<String, Object> attributes) {
        this._id = id;
        this._type = type;
        this._attributes = Collections.unmodifiableMap(attributes);
    }

    public UUID getId() {
        return this._id;
    }

    public String getType() {
        return this._type;
    }

    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    void addParent(String parentType, ConfiguredObjectRecord parent) {
        this._parents.put(parentType, parent.getId());
    }

    public Map<String, UUID> getParents() {
        return Collections.unmodifiableMap(this._parents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BDBConfiguredObjectRecord that = (BDBConfiguredObjectRecord)o;
        if (this._attributes != null ? !this._attributes.equals(that._attributes) : that._attributes != null) {
            return false;
        }
        if (this._id != null ? !this._id.equals(that._id) : that._id != null) {
            return false;
        }
        return !(this._type != null ? !this._type.equals(that._type) : that._type != null);
    }

    public int hashCode() {
        int result = this._id != null ? this._id.hashCode() : 0;
        result = 31 * result + (this._type != null ? this._type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BDBConfiguredObjectRecord [id=" + this._id + ", type=" + this._type + ", name=" + (this._attributes == null ? null : this._attributes.get("name")) + ", parents=" + this._parents + "]";
    }
}

