/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_8_v0_10;

import java.util.HashMap;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.ReplyTo;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQPInvalidClassException;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.FieldTableFactory;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.protocol.v0_8.transport.MessagePublishInfo;
import org.apache.qpid.server.store.StoredMessage;

@PluggableService
public class MessageConverter_0_10_to_0_8
implements MessageConverter<MessageTransferMessage, AMQMessage> {
    private static final int BASIC_CLASS_ID = 60;

    public static BasicContentHeaderProperties convertContentHeaderProperties(MessageTransferMessage messageTransferMessage, NamedAddressSpace addressSpace) {
        BasicContentHeaderProperties props = new BasicContentHeaderProperties();
        Header header = messageTransferMessage.getHeader();
        DeliveryProperties deliveryProps = header.getDeliveryProperties();
        MessageProperties messageProps = header.getMessageProperties();
        if (deliveryProps != null) {
            if (deliveryProps.hasDeliveryMode()) {
                props.setDeliveryMode(deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT ? (byte)2 : 1);
            }
            if (deliveryProps.hasTtl()) {
                props.setExpiration(messageTransferMessage.getArrivalTime() + deliveryProps.getTtl());
            } else if (deliveryProps.hasExpiration()) {
                props.setExpiration(deliveryProps.getExpiration());
            }
            if (deliveryProps.hasPriority()) {
                props.setPriority((byte)deliveryProps.getPriority().getValue());
            }
            if (deliveryProps.hasTimestamp()) {
                props.setTimestamp(deliveryProps.getTimestamp());
            } else {
                props.setTimestamp(messageTransferMessage.getArrivalTime());
            }
        }
        if (messageProps != null) {
            if (messageProps.hasAppId()) {
                try {
                    props.setAppId(AMQShortString.createAMQShortString((byte[])messageProps.getAppId()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (messageProps.hasContentType()) {
                props.setContentType(messageProps.getContentType());
            }
            if (messageProps.hasCorrelationId()) {
                try {
                    props.setCorrelationId(AMQShortString.createAMQShortString((byte[])messageProps.getCorrelationId()));
                }
                catch (IllegalArgumentException e) {
                    throw new MessageConversionException("Could not convert message from 0-10 to 0-8 because conversion of 'correlationId' failed.", (Throwable)e);
                }
            }
            if (messageProps.hasContentEncoding()) {
                props.setEncoding(messageProps.getContentEncoding());
            }
            if (messageProps.hasMessageId()) {
                props.setMessageId("ID:" + messageProps.getMessageId().toString());
            }
            if (messageProps.hasReplyTo()) {
                ReplyTo replyTo = messageProps.getReplyTo();
                String exchangeName = replyTo.getExchange();
                String routingKey = replyTo.getRoutingKey();
                if (exchangeName == null) {
                    exchangeName = "";
                }
                if (!"".equals(exchangeName) || routingKey != null && !"".equals(routingKey)) {
                    MessageDestination destination = addressSpace.getAttainedMessageDestination(exchangeName, false);
                    Exchange exchange = destination instanceof Exchange ? (Exchange)destination : null;
                    String exchangeClass = exchange == null ? "direct" : exchange.getType();
                    String routingKeyOption = routingKey == null ? "" : "?routingkey='" + routingKey + "'";
                    String replyToBindingUrl = String.format("%s://%s//%s", exchangeClass, exchangeName, routingKeyOption);
                    try {
                        props.setReplyTo(replyToBindingUrl);
                    }
                    catch (IllegalArgumentException e) {
                        throw new MessageConversionException("Could not convert message from 0-10 to 0-8 because conversion of 'reply-to' failed.", (Throwable)e);
                    }
                }
            }
            if (messageProps.hasUserId()) {
                try {
                    props.setUserId(AMQShortString.createAMQShortString((byte[])messageProps.getUserId()));
                }
                catch (IllegalArgumentException replyTo) {
                    // empty catch block
                }
            }
            if (messageProps.hasApplicationHeaders()) {
                FieldTable ft;
                HashMap appHeaders = new HashMap(messageProps.getApplicationHeaders());
                if (messageProps.getApplicationHeaders().containsKey("x-jms-type")) {
                    String jmsType = String.valueOf(appHeaders.remove("x-jms-type"));
                    try {
                        props.setType(jmsType);
                    }
                    catch (IllegalArgumentException e) {
                        throw new MessageConversionException("Could not convert message from 0-10 to 0-8 because x-jms-type conversion failed.", (Throwable)e);
                    }
                }
                try {
                    ft = FieldTableFactory.createFieldTable(appHeaders);
                }
                catch (IllegalArgumentException | AMQPInvalidClassException e) {
                    throw new MessageConversionException("Could not convert message from 0-10 to 0-8 because conversion of application headers failed.", e);
                }
                props.setHeaders(ft);
            }
        }
        return props;
    }

    public Class<MessageTransferMessage> getInputClass() {
        return MessageTransferMessage.class;
    }

    public Class<AMQMessage> getOutputClass() {
        return AMQMessage.class;
    }

    public AMQMessage convert(MessageTransferMessage message, NamedAddressSpace addressSpace) {
        return new AMQMessage(this.convertToStoredMessage(message, addressSpace));
    }

    public void dispose(AMQMessage message) {
    }

    private StoredMessage<MessageMetaData> convertToStoredMessage(final MessageTransferMessage message, NamedAddressSpace addressSpace) {
        final MessageMetaData metaData = this.convertMetaData(message, addressSpace);
        final int metadataSize = metaData.getStorableSize();
        return new StoredMessage<MessageMetaData>(){

            public MessageMetaData getMetaData() {
                return metaData;
            }

            public long getMessageNumber() {
                return message.getMessageNumber();
            }

            public QpidByteBuffer getContent(int offset, int length) {
                return message.getContent(offset, length);
            }

            public int getContentSize() {
                return metaData.getContentSize();
            }

            public int getMetadataSize() {
                return metadataSize;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInContentInMemory() {
                return true;
            }

            public long getInMemorySize() {
                return this.getMetadataSize() + this.getContentSize();
            }

            public boolean flowToDisk() {
                return false;
            }

            public void reallocate() {
            }
        };
    }

    private MessageMetaData convertMetaData(MessageTransferMessage message, NamedAddressSpace addressSpace) {
        return new MessageMetaData(this.convertPublishBody(message), this.convertContentHeaderBody(message, addressSpace), message.getArrivalTime());
    }

    private ContentHeaderBody convertContentHeaderBody(MessageTransferMessage message, NamedAddressSpace addressSpace) {
        BasicContentHeaderProperties props = MessageConverter_0_10_to_0_8.convertContentHeaderProperties(message, addressSpace);
        ContentHeaderBody chb = new ContentHeaderBody(props);
        chb.setBodySize(message.getSize());
        return chb;
    }

    private MessagePublishInfo convertPublishBody(MessageTransferMessage message) {
        DeliveryProperties delvProps = message.getHeader().getDeliveryProperties();
        AMQShortString exchangeName = delvProps == null || delvProps.getExchange() == null ? null : AMQShortString.createAMQShortString((String)delvProps.getExchange());
        AMQShortString routingKey = delvProps == null || delvProps.getRoutingKey() == null ? null : AMQShortString.createAMQShortString((String)delvProps.getRoutingKey());
        boolean immediate = delvProps != null && delvProps.getImmediate();
        boolean mandatory = delvProps != null && !delvProps.getDiscardUnroutable();
        return new MessagePublishInfo(exchangeName, immediate, mandatory, routingKey);
    }

    public String getType() {
        return "v0-10 to v0-8";
    }
}

