/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.qpid.disttest.controller.config;

import java.util.Collections;
import java.util.Map;

public class QueueConfig
{
    private String _name;
    private boolean _durable;
    private Map<String, Object> _attributes;

    public QueueConfig()
    {
        super();
        _attributes = Collections.emptyMap();
    }

    public QueueConfig(String name, boolean durable, Map<String, Object> attributes)
    {
        this._name = name;
        this._durable = durable;
        this._attributes = attributes;
    }

    public String getName()
    {
        return _name;
    }

    public Map<String, Object> getAttributes()
    {
        return _attributes;
    }

    public boolean isDurable()
    {
        return _durable;
    }

    @Override
    public String toString()
    {
        return "QueueConfig[" +
               "name='" + _name + '\'' +
               ", durable=" + _durable +
               ", attributes=" + _attributes +
               ']';
    }
}
