/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.config.RuleSetCreator;
import org.apache.qpid.server.security.access.plugins.RuleOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AclFileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclFileParser.class);
    public static final String DEFAULT_ALLOW = "defaultallow";
    public static final String DEFAULT_DEFER = "defaultdefer";
    public static final String DEFAULT_DENY = "defaultdeny";
    private static final Character COMMENT = Character.valueOf('#');
    private static final Character CONTINUATION = Character.valueOf('\\');
    public static final String ACL = "acl";
    private static final String CONFIG = "config";
    private static final String UNRECOGNISED_INITIAL_MSG = "Unrecognised initial token '%s' at line %d";
    static final String NOT_ENOUGH_TOKENS_MSG = "Not enough tokens at line %d";
    private static final String NUMBER_NOT_ALLOWED_MSG = "Number not allowed before '%s' at line %d";
    private static final String CANNOT_LOAD_MSG = "I/O Error while reading configuration";
    static final String PREMATURE_CONTINUATION_MSG = "Premature continuation character at line %d";
    private static final String PREMATURE_EOF_MSG = "Premature end of file reached at line %d";
    static final String PARSE_TOKEN_FAILED_MSG = "Failed to parse token at line %d";
    static final String NOT_ENOUGH_ACL_MSG = "Not enough data for an acl at line %d";
    private static final String NOT_ENOUGH_CONFIG_MSG = "Not enough data for config at line %d";
    private static final String BAD_ACL_RULE_NUMBER_MSG = "Invalid rule number at line %d";
    static final String PROPERTY_KEY_ONLY_MSG = "Incomplete property (key only) at line %d";
    static final String PROPERTY_NO_EQUALS_MSG = "Incomplete property (no equals) at line %d";
    static final String PROPERTY_NO_VALUE_MSG = "Incomplete property (no value) at line %d";

    private AclFileParser() {
    }

    private static Reader getReaderFromURLString(String urlString) {
        try {
            URL url;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                File file = new File(urlString);
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException notAFile) {
                    throw new IllegalConfigurationException("Cannot convert " + urlString + " to a readable resource", (Throwable)notAFile);
                }
            }
            return new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot convert " + urlString + " to a readable resource", (Throwable)e);
        }
    }

    public static RuleSet parse(String name, EventLoggerProvider eventLoggerProvider) {
        return AclFileParser.parse(AclFileParser.getReaderFromURLString(name), eventLoggerProvider);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RuleSet parse(Reader configReader, EventLoggerProvider eventLogger) {
        RuleSetCreator ruleSetCreator = new RuleSetCreator();
        int line = 0;
        try (Reader fileReader = configReader;){
            int current;
            LOGGER.debug("About to load ACL file");
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(fileReader));
            tokenizer.resetSyntax();
            tokenizer.commentChar(COMMENT.charValue());
            tokenizer.eolIsSignificant(true);
            tokenizer.ordinaryChar(61);
            tokenizer.ordinaryChar(CONTINUATION.charValue());
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(95, 95);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(46, 46);
            tokenizer.wordChars(42, 42);
            tokenizer.wordChars(64, 64);
            tokenizer.wordChars(58, 58);
            Stack<String> stack = new Stack<String>();
            block17: do {
                current = tokenizer.nextToken();
                line = tokenizer.lineno() - 1;
                switch (current) {
                    case -1: 
                    case 10: {
                        if (stack.isEmpty()) continue block17;
                        String first = (String)stack.firstElement();
                        stack.removeElementAt(0);
                        if (stack.isEmpty()) {
                            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_TOKENS_MSG, line));
                        }
                        Integer number = null;
                        if (first != null && first.matches("\\d+")) {
                            number = Integer.valueOf(first);
                            first = (String)stack.firstElement();
                            stack.removeElementAt(0);
                        }
                        if (ACL.equalsIgnoreCase(first)) {
                            AclFileParser.parseAcl(number, stack, ruleSetCreator, line);
                        } else {
                            if (number != null) throw new IllegalConfigurationException(String.format(NUMBER_NOT_ALLOWED_MSG, first, line));
                            if ("GROUP".equalsIgnoreCase(first)) {
                                throw new IllegalConfigurationException(String.format("GROUP keyword not supported at line %d. Groups should defined via a Group Provider, not in the ACL file.", line));
                            }
                            if (!CONFIG.equalsIgnoreCase(first)) throw new IllegalConfigurationException(String.format(UNRECOGNISED_INITIAL_MSG, first, line));
                            AclFileParser.parseConfig(stack, ruleSetCreator, line);
                        }
                        stack.clear();
                        break;
                    }
                    case -2: {
                        stack.push(Integer.toString(Double.valueOf(tokenizer.nval).intValue()));
                        break;
                    }
                    case -3: {
                        stack.push(tokenizer.sval);
                        break;
                    }
                    default: {
                        if (tokenizer.ttype == CONTINUATION.charValue()) {
                            int next = tokenizer.nextToken();
                            line = tokenizer.lineno() - 1;
                            if (next == 10) continue block17;
                            throw new IllegalConfigurationException(String.format(PREMATURE_CONTINUATION_MSG, line + 1));
                        }
                        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
                            stack.push(tokenizer.sval);
                            break;
                        }
                        stack.push(Character.toString((char)tokenizer.ttype));
                    }
                }
            } while (current != -1);
            if (stack.isEmpty()) return ruleSetCreator.createRuleSet(eventLogger);
            throw new IllegalConfigurationException(String.format(PREMATURE_EOF_MSG, line));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalConfigurationException(String.format(PARSE_TOKEN_FAILED_MSG, line), (Throwable)iae);
        }
        catch (IOException ioe) {
            throw new IllegalConfigurationException(CANNOT_LOAD_MSG, (Throwable)ioe);
        }
    }

    private static void parseAcl(Integer number, List<String> args, RuleSetCreator ruleSetCreator, int line) {
        RuleOutcome outcome;
        if (args.size() < 3) {
            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_ACL_MSG, line));
        }
        String text = args.get(0);
        try {
            outcome = RuleOutcome.valueOf(text.replace('-', '_').toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Not a valid permission: " + text, e);
        }
        String identity = args.get(1);
        LegacyOperation operation = LegacyOperation.valueOf(args.get(2).toUpperCase());
        if (number != null && !ruleSetCreator.isValidNumber(number)) {
            throw new IllegalConfigurationException(String.format(BAD_ACL_RULE_NUMBER_MSG, line));
        }
        if (args.size() == 3) {
            ruleSetCreator.addRule(number, identity, outcome, operation);
        } else {
            ObjectType object = ObjectType.valueOf(args.get(3).toUpperCase());
            AclRulePredicates predicates = AclFileParser.toRulePredicates(args.subList(4, args.size()), line);
            ruleSetCreator.addRule(number, identity, outcome, operation, object, predicates);
        }
    }

    private static void parseConfig(List<String> args, RuleSetCreator ruleSetCreator, int line) {
        if (args.size() < 3) {
            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_CONFIG_MSG, line));
        }
        Map<String, Boolean> properties = AclFileParser.toPluginProperties(args, line);
        if (Boolean.TRUE.equals(properties.get(DEFAULT_ALLOW))) {
            ruleSetCreator.setDefaultResult(Result.ALLOWED);
        }
        if (Boolean.TRUE.equals(properties.get(DEFAULT_DEFER))) {
            ruleSetCreator.setDefaultResult(Result.DEFER);
        }
        if (Boolean.TRUE.equals(properties.get(DEFAULT_DENY))) {
            ruleSetCreator.setDefaultResult(Result.DENIED);
        }
    }

    private static AclRulePredicates toRulePredicates(List<String> args, int line) {
        AclRulePredicates predicates = new AclRulePredicates();
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = i.next();
            if (!i.hasNext()) {
                throw new IllegalConfigurationException(String.format(PROPERTY_KEY_ONLY_MSG, line));
            }
            if (!"=".equals(i.next())) {
                throw new IllegalConfigurationException(String.format(PROPERTY_NO_EQUALS_MSG, line));
            }
            if (!i.hasNext()) {
                throw new IllegalConfigurationException(String.format(PROPERTY_NO_VALUE_MSG, line));
            }
            String value = i.next();
            predicates.parse(key, value);
        }
        return predicates;
    }

    private static Map<String, Boolean> toPluginProperties(List<String> args, int line) {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = i.next().toLowerCase();
            if (!i.hasNext()) {
                throw new IllegalConfigurationException(String.format(PROPERTY_KEY_ONLY_MSG, line));
            }
            if (!"=".equals(i.next())) {
                throw new IllegalConfigurationException(String.format(PROPERTY_NO_EQUALS_MSG, line));
            }
            if (!i.hasNext()) {
                throw new IllegalConfigurationException(String.format(PROPERTY_NO_VALUE_MSG, line));
            }
            Boolean value = Boolean.valueOf(i.next());
            properties.put(key, value);
        }
        return properties;
    }
}

