/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.google.common.util.concurrent.ListenableFuture;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.CoalescingCommiter;
import org.apache.qpid.server.store.berkeleydb.Committer;
import org.apache.qpid.server.store.berkeleydb.EnvHomeRegistry;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentUtils;
import org.apache.qpid.server.store.berkeleydb.LoggingAsyncExceptionListener;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentConfiguration;
import org.apache.qpid.server.store.berkeleydb.logging.Slf4jLoggingHandler;
import org.apache.qpid.server.store.berkeleydb.upgrade.Upgrader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardEnvironmentFacade
implements EnvironmentFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardEnvironmentFacade.class);
    private final String _storePath;
    private final ConcurrentMap<String, Database> _cachedDatabases = new ConcurrentHashMap<String, Database>();
    private final ConcurrentMap<DatabaseEntry, Sequence> _cachedSequences = new ConcurrentHashMap<DatabaseEntry, Sequence>();
    private final AtomicReference<Environment> _environment;
    private final Committer _committer;
    private final File _environmentPath;
    private static final Set<String> PARAMS_SET_BY_DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardEnvironmentFacade(StandardEnvironmentConfiguration configuration) {
        this._storePath = configuration.getStorePath();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Creating environment at environment path " + this._storePath);
        }
        this._environmentPath = new File(this._storePath);
        if (!this._environmentPath.exists()) {
            if (!this._environmentPath.mkdirs()) {
                throw new IllegalArgumentException("Environment path " + this._environmentPath + " could not be read or created. Ensure the path is correct and that the permissions are correct.");
            }
        } else if (this._environmentPath.isFile()) {
            throw new IllegalArgumentException("Environment path " + this._environmentPath + " exists as a file - not a directory. Ensure the path is correct.");
        }
        String name = configuration.getName();
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setCacheMode(configuration.getCacheMode());
        envConfig.setLoggingHandler((Handler)new Slf4jLoggingHandler(configuration));
        LOGGER.debug("Cache mode {}", (Object)envConfig.getCacheMode());
        HashMap<String, String> params = new HashMap<String, String>(EnvironmentFacade.ENVCONFIG_DEFAULTS);
        params.putAll(configuration.getParameters());
        for (Map.Entry configItem : params.entrySet()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting EnvironmentConfig key " + (String)configItem.getKey() + " to '" + (String)configItem.getValue() + "'");
            }
            envConfig.setConfigParam((String)configItem.getKey(), (String)configItem.getValue());
        }
        envConfig.setExceptionListener((ExceptionListener)new LoggingAsyncExceptionListener());
        DbInternal.setLoadPropertyFile((EnvironmentConfig)envConfig, (boolean)false);
        File propsFile = new File(this._environmentPath, "je.properties");
        if (propsFile.exists()) {
            LOGGER.warn("The BDB configuration file at '" + this._environmentPath + File.separator + "je.properties' will NOT be loaded.  Configure BDB using Qpid context variables instead.");
        }
        EnvHomeRegistry.getInstance().registerHome(this._environmentPath);
        boolean success = false;
        try {
            this._environment = new AtomicReference<Environment>(new Environment(this._environmentPath, envConfig));
            success = true;
        }
        finally {
            if (!success) {
                EnvHomeRegistry.getInstance().deregisterHome(this._environmentPath);
            }
        }
        this._committer = new CoalescingCommiter(name, this);
        this._committer.start();
    }

    @Override
    public Transaction beginTransaction(TransactionConfig transactionConfig) {
        return this.getEnvironment().beginTransaction(null, transactionConfig);
    }

    @Override
    public void commit(Transaction tx, boolean syncCommit) {
        try {
            tx.commitNoSync();
        }
        catch (DatabaseException de) {
            LOGGER.error("Got DatabaseException on commit, closing environment", (Throwable)de);
            this.closeEnvironmentSafely();
            throw this.handleDatabaseException("Got DatabaseException on commit", (RuntimeException)((Object)de));
        }
        this._committer.commit(tx, syncCommit);
    }

    @Override
    public <X> ListenableFuture<X> commitAsync(Transaction tx, X val) {
        try {
            tx.commitNoSync();
        }
        catch (DatabaseException de) {
            LOGGER.error("Got DatabaseException on commit, closing environment", (Throwable)de);
            this.closeEnvironmentSafely();
            throw this.handleDatabaseException("Got DatabaseException on commit", (RuntimeException)((Object)de));
        }
        return this._committer.commitAsync(tx, val);
    }

    @Override
    public void close() {
        try {
            this._committer.stop();
            this.closeSequences();
            this.closeDatabases();
        }
        finally {
            try {
                this.closeEnvironment();
            }
            finally {
                EnvHomeRegistry.getInstance().deregisterHome(this._environmentPath);
            }
        }
    }

    @Override
    public long getTotalLogSize() {
        return this.getEnvironment().getStats(null).getTotalLogSize();
    }

    @Override
    public void reduceSizeOnDisk() {
        BDBUtils.runCleaner(this.getEnvironment());
    }

    @Override
    public void flushLog() {
        try {
            this.getEnvironment().flushLog(true);
        }
        catch (RuntimeException e) {
            throw this.handleDatabaseException("Exception whilst syncing data to disk", e);
        }
    }

    @Override
    public void setCacheSize(long cacheSize) {
        Environment environment = this.getEnvironment();
        EnvironmentMutableConfig mutableConfig = environment.getMutableConfig();
        mutableConfig.setCacheSize(cacheSize);
        environment.setMutableConfig(mutableConfig);
    }

    @Override
    public void flushLogFailed(RuntimeException e) {
        LOGGER.error("Closing store environment due to failure on syncing data to disk", (Throwable)e);
        try {
            this.close();
        }
        catch (Exception ex) {
            LOGGER.error("Exception closing store environment", (Throwable)ex);
        }
    }

    @Override
    public void updateMutableConfig(ConfiguredObject<?> object) {
        EnvironmentUtils.updateMutableConfig(this.getEnvironment(), PARAMS_SET_BY_DEFAULT, false, object);
    }

    @Override
    public int cleanLog() {
        return this.getEnvironment().cleanLog();
    }

    @Override
    public void checkpoint(boolean force) {
        CheckpointConfig ckptConfig = new CheckpointConfig();
        ckptConfig.setForce(force);
        this.getEnvironment().checkpoint(ckptConfig);
    }

    @Override
    public Map<String, Map<String, Object>> getEnvironmentStatistics(boolean reset) {
        return EnvironmentUtils.getEnvironmentStatistics(this.getEnvironment(), reset);
    }

    @Override
    public Map<String, Object> getDatabaseStatistics(String database, boolean reset) {
        return EnvironmentUtils.getDatabaseStatistics(this.getEnvironment(), database, reset);
    }

    @Override
    public void deleteDatabase(String databaseName) {
        this.closeDatabase(databaseName);
        this.getEnvironment().removeDatabase(null, databaseName);
    }

    @Override
    public Map<String, Object> getTransactionStatistics(boolean reset) {
        return EnvironmentUtils.getTransactionStatistics(this.getEnvironment(), reset);
    }

    private void closeSequences() {
        DatabaseException firstThrownException = null;
        for (DatabaseEntry sequenceKey : this._cachedSequences.keySet()) {
            try {
                this.closeSequence(sequenceKey);
            }
            catch (DatabaseException de) {
                if (firstThrownException != null) continue;
                firstThrownException = de;
            }
        }
        if (firstThrownException != null) {
            throw firstThrownException;
        }
    }

    private void closeDatabases() {
        DatabaseException firstThrownException = null;
        for (String databaseName : this._cachedDatabases.keySet()) {
            try {
                this.closeDatabase(databaseName);
            }
            catch (DatabaseException e) {
                if (firstThrownException != null) continue;
                firstThrownException = e;
            }
        }
        if (firstThrownException != null) {
            throw firstThrownException;
        }
    }

    private void closeEnvironmentSafely() {
        Environment environment = this._environment.getAndSet(null);
        if (environment != null) {
            if (environment.isValid()) {
                try {
                    this.closeDatabases();
                }
                catch (Exception e) {
                    LOGGER.error("Exception closing environment databases", (Throwable)e);
                }
            }
            try {
                environment.close();
            }
            catch (DatabaseException ex) {
                LOGGER.error("Exception closing store environment", (Throwable)ex);
            }
            catch (IllegalStateException ex) {
                LOGGER.error("Exception closing store environment", (Throwable)ex);
            }
        }
    }

    private Environment getEnvironment() {
        Environment environment = this._environment.get();
        if (environment == null) {
            throw new IllegalStateException("Environment is null.");
        }
        return environment;
    }

    @Override
    public void upgradeIfNecessary(ConfiguredObject<?> parent) {
        Upgrader upgrader = new Upgrader(this.getEnvironment(), parent);
        upgrader.upgradeIfNecessary();
    }

    private void closeEnvironment() {
        Environment environment = this._environment.getAndSet(null);
        if (environment != null) {
            try {
                BDBUtils.runCleaner(environment);
            }
            finally {
                environment.close();
            }
        }
    }

    @Override
    public RuntimeException handleDatabaseException(String contextMessage, RuntimeException e) {
        Environment environment = this._environment.get();
        if (environment != null && !environment.isValid()) {
            this.closeEnvironmentSafely();
        }
        if (e instanceof StoreException) {
            return e;
        }
        return new StoreException(contextMessage, (Throwable)e);
    }

    @Override
    public Database openDatabase(String name, DatabaseConfig databaseConfig) {
        Database cachedHandle = (Database)this._cachedDatabases.get(name);
        if (cachedHandle == null) {
            Database handle = this.getEnvironment().openDatabase(null, name, databaseConfig);
            Database existingHandle = this._cachedDatabases.putIfAbsent(name, handle);
            if (existingHandle == null) {
                cachedHandle = handle;
            } else {
                cachedHandle = existingHandle;
                handle.close();
            }
        }
        return cachedHandle;
    }

    @Override
    public Database clearDatabase(Transaction txn, String databaseName, DatabaseConfig databaseConfig) {
        this.closeDatabase(databaseName);
        this.getEnvironment().removeDatabase(txn, databaseName);
        return this.getEnvironment().openDatabase(txn, databaseName, databaseConfig);
    }

    @Override
    public Sequence openSequence(Database database, DatabaseEntry sequenceKey, SequenceConfig sequenceConfig) {
        Sequence cachedSequence = (Sequence)this._cachedSequences.get(sequenceKey);
        if (cachedSequence == null) {
            Sequence handle = database.openSequence(null, sequenceKey, sequenceConfig);
            Sequence existingHandle = this._cachedSequences.putIfAbsent(sequenceKey, handle);
            if (existingHandle == null) {
                cachedSequence = handle;
            } else {
                cachedSequence = existingHandle;
                handle.close();
            }
        }
        return cachedSequence;
    }

    private void closeSequence(DatabaseEntry sequenceKey) {
        Sequence cachedHandle = (Sequence)this._cachedSequences.remove(sequenceKey);
        if (cachedHandle != null) {
            cachedHandle.close();
        }
    }

    @Override
    public void closeDatabase(String name) {
        Database cachedHandle = (Database)this._cachedDatabases.remove(name);
        if (cachedHandle != null) {
            cachedHandle.close();
        }
    }

    static {
        HashSet excludes = new HashSet(ENVCONFIG_DEFAULTS.keySet());
        excludes.addAll(Arrays.asList("je.maxMemory", "je.maxMemoryPercent"));
        PARAMS_SET_BY_DEFAULT = Collections.unmodifiableSet(excludes);
    }
}

