/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.ModelVersion;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.jdbc.JdbcUtils;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceRecordImpl;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreUpdater;
import org.apache.qpid.server.util.BaseAction;
import org.slf4j.Logger;

public abstract class AbstractJDBCPreferenceStore
implements PreferenceStore {
    private static final String PREFERENCES_VERSION_TABLE_NAME = "PREFERENCES_VERSION";
    private static final String PREFERENCES_TABLE_NAME = "PREFERENCES";
    private static final String CREATE_PREFERENCES_VERSION_TABLE = "CREATE TABLE %s ( version VARCHAR(20) NOT NULL )";
    private static final String INSERT_INTO_PREFERENCES_VERSION = "INSERT INTO %s ( version ) VALUES ( ? )";
    private static final String SELECT_FROM_PREFERENCES_VERSION = "SELECT version FROM %s";
    private static final String INSERT_INTO_PREFERENCES = "INSERT INTO %s ( id, attributes ) VALUES ( ?, ? )";
    private static final String DELETE_FROM_PREFERENCES = "DELETE FROM %s where id = ?";
    private static final String SELECT_FROM_PREFERENCES = "SELECT id, attributes FROM %s";
    private static final String FIND_PREFERENCE = "SELECT attributes FROM %s WHERE id = ?";
    private static final String UPDATE_PREFERENCES = "UPDATE %s SET attributes = ? WHERE id = ?";
    private final AtomicReference<StoreState> _storeState = new AtomicReference<StoreState>(StoreState.CLOSED);
    private final ReentrantReadWriteLock _useOrCloseRWLock = new ReentrantReadWriteLock(true);
    private String _tableNamePrefix = "";

    protected void setTableNamePrefix(String tableNamePrefix) {
        this._tableNamePrefix = tableNamePrefix == null ? "" : tableNamePrefix;
    }

    public Collection<PreferenceRecord> openAndLoad(PreferenceStoreUpdater updater) throws StoreException {
        if (!this._storeState.compareAndSet(StoreState.CLOSED, StoreState.OPENING)) {
            throw new IllegalStateException(String.format("PreferenceStore cannot be opened when in state '%s'", new Object[]{this._storeState.get()}));
        }
        try {
            Collection records;
            this._storeState.set(StoreState.OPENED);
            try (Connection connection = this.getConnection();){
                this.createVersionTable(connection);
                this.createPreferencesTable(connection);
                ModelVersion preferencesVersion = this.getPreferencesVersion(connection);
                ModelVersion brokerModelVersion = ModelVersion.fromString((String)"7.1");
                if (brokerModelVersion.lessThan(preferencesVersion)) {
                    throw new StoreException(String.format("Cannot downgrade preference store from '%s' to '%s'", preferencesVersion, brokerModelVersion));
                }
                records = this.getPreferenceRecords(connection);
                if (preferencesVersion.lessThan(brokerModelVersion)) {
                    HashSet<UUID> ids = new HashSet<UUID>();
                    for (PreferenceRecord record : records) {
                        ids.add(record.getId());
                    }
                    records = updater.updatePreferences(preferencesVersion.toString(), records);
                    this.removeAndAdd(ids, records, (BaseAction<Connection, SQLException>)((BaseAction)transactedConnection -> this.updateVersion((Connection)transactedConnection, brokerModelVersion.toString())));
                }
            }
            return records;
        }
        catch (SQLException e) {
            this._storeState.set(StoreState.ERRORED);
            this.close();
            throw new StoreException((Throwable)e);
        }
    }

    public void updateOrCreate(final Collection<PreferenceRecord> preferenceRecords) {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (!this.getStoreState().equals((Object)StoreState.OPENED)) {
                throw new IllegalStateException("PreferenceStore is not opened");
            }
            this.performSafeTransaction(new BaseAction<Connection, Exception>(){

                public void performAction(Connection connection) throws Exception {
                    AbstractJDBCPreferenceStore.this.updateOrCreateInternal(connection, preferenceRecords);
                }
            });
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    public void replace(Collection<UUID> preferenceRecordsToRemove, Collection<PreferenceRecord> preferenceRecordsToAdd) {
        this.removeAndAdd(preferenceRecordsToRemove, preferenceRecordsToAdd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndAdd(final Collection<UUID> preferenceRecordsToRemove, final Collection<PreferenceRecord> preferenceRecordsToAdd, final BaseAction<Connection, SQLException> preCommitAction) {
        this._useOrCloseRWLock.readLock().lock();
        try {
            if (!this.getStoreState().equals((Object)StoreState.OPENED)) {
                throw new IllegalStateException("PreferenceStore is not opened");
            }
            this.performSafeTransaction(new BaseAction<Connection, Exception>(){

                public void performAction(Connection connection) throws Exception {
                    for (UUID id : preferenceRecordsToRemove) {
                        PreparedStatement deleteStatement = connection.prepareStatement(String.format(AbstractJDBCPreferenceStore.DELETE_FROM_PREFERENCES, AbstractJDBCPreferenceStore.this.getPreferencesTableName()));
                        Throwable throwable = null;
                        try {
                            deleteStatement.setString(1, id.toString());
                            int deletedCount = deleteStatement.executeUpdate();
                            if (deletedCount != 1) continue;
                            AbstractJDBCPreferenceStore.this.getLogger().debug(String.format("Failed to delete preference with id %s : no such record", id));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (deleteStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    deleteStatement.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            deleteStatement.close();
                        }
                    }
                    AbstractJDBCPreferenceStore.this.updateOrCreateInternal(connection, preferenceRecordsToAdd);
                    if (preCommitAction != null) {
                        preCommitAction.performAction((Object)connection);
                    }
                }
            });
        }
        finally {
            this._useOrCloseRWLock.readLock().unlock();
        }
    }

    public void onDelete() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            this.close();
            this.doDelete();
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    public void close() {
        this._useOrCloseRWLock.writeLock().lock();
        try {
            while (true) {
                StoreState storeState;
                if ((storeState = this.getStoreState()).equals((Object)StoreState.OPENED) || storeState.equals((Object)StoreState.ERRORED)) {
                    if (!this._storeState.compareAndSet(storeState, StoreState.CLOSING)) continue;
                    break;
                }
                if (!storeState.equals((Object)StoreState.CLOSED) && !storeState.equals((Object)StoreState.CLOSING)) continue;
                return;
            }
            this.doClose();
            this._storeState.set(StoreState.CLOSED);
        }
        finally {
            this._useOrCloseRWLock.writeLock().unlock();
        }
    }

    protected void dropTables(Connection connection) throws SQLException {
        try (Statement dropTableStatement = connection.createStatement();){
            dropTableStatement.execute(String.format("DROP TABLE %s", this.getPreferencesTableName()));
            dropTableStatement.execute(String.format("DROP TABLE %s", this.getPreferencesVersionTableName()));
        }
        catch (SQLException e) {
            this.getLogger().warn("Failed to drop preferences table", (Throwable)e);
        }
    }

    protected abstract void doDelete();

    protected abstract void doClose();

    protected abstract Logger getLogger();

    protected abstract Connection getConnection() throws SQLException;

    protected abstract String getSqlBlobType();

    protected abstract String getBlobAsString(ResultSet var1, int var2) throws SQLException;

    StoreState getStoreState() {
        return this._storeState.get();
    }

    private void updateOrCreateInternal(Connection conn, Collection<PreferenceRecord> preferenceRecords) throws SQLException, JsonProcessingException {
        for (PreferenceRecord record : preferenceRecords) {
            PreparedStatement stmt = conn.prepareStatement(String.format(FIND_PREFERENCE, this.getPreferencesTableName()));
            Throwable throwable = null;
            try {
                stmt.setString(1, record.getId().toString());
                ResultSet rs = stmt.executeQuery();
                Throwable throwable2 = null;
                try {
                    Throwable throwable3;
                    if (rs.next()) {
                        PreparedStatement updateStatement = conn.prepareStatement(String.format(UPDATE_PREFERENCES, this.getPreferencesTableName()));
                        throwable3 = null;
                        try {
                            this.setAttributesAsBlob(updateStatement, 1, record.getAttributes());
                            updateStatement.setString(2, record.getId().toString());
                            updateStatement.execute();
                            continue;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (updateStatement == null) continue;
                            if (throwable3 != null) {
                                try {
                                    updateStatement.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            updateStatement.close();
                            continue;
                        }
                    }
                    PreparedStatement insertStatement = conn.prepareStatement(String.format(INSERT_INTO_PREFERENCES, this.getPreferencesTableName()));
                    throwable3 = null;
                    try {
                        insertStatement.setString(1, record.getId().toString());
                        this.setAttributesAsBlob(insertStatement, 2, record.getAttributes());
                        insertStatement.execute();
                    }
                    catch (Throwable throwable6) {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (insertStatement == null) continue;
                        if (throwable3 != null) {
                            try {
                                insertStatement.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        insertStatement.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable2 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (stmt == null) continue;
                if (throwable != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                stmt.close();
            }
        }
    }

    private void performSafeTransaction(BaseAction<Connection, Exception> transactedAction) {
        Connection connection = null;
        try {
            connection = this.getTransactedConnection();
            transactedAction.performAction((Object)connection);
            connection.commit();
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e1) {
                this.getLogger().error("Failed to rollback transaction", (Throwable)e1);
            }
            throw new StoreException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().warn("Failed to close JDBC connection", (Throwable)e);
            }
        }
    }

    private Connection getTransactedConnection() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(2);
        return connection;
    }

    private void setAttributesAsBlob(PreparedStatement preparedSqlStatement, int parameterIndex, Map<String, Object> attributes) throws JsonProcessingException, SQLException {
        ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)true);
        if (attributes != null) {
            byte[] attributesAsBytes = objectMapper.writeValueAsBytes(attributes);
            ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
            preparedSqlStatement.setBinaryStream(parameterIndex, (InputStream)bis, attributesAsBytes.length);
        } else {
            preparedSqlStatement.setNull(parameterIndex, 2004);
        }
    }

    private void createVersionTable(Connection conn) throws SQLException {
        if (!JdbcUtils.tableExists(this.getPreferencesVersionTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute(String.format(CREATE_PREFERENCES_VERSION_TABLE, this.getPreferencesVersionTableName()));
            }
            this.updateVersion(conn, "7.1");
        }
    }

    private void updateVersion(Connection conn, String currentVersion) throws SQLException {
        try (PreparedStatement pstmt = conn.prepareStatement(String.format(INSERT_INTO_PREFERENCES_VERSION, this.getPreferencesVersionTableName()));){
            pstmt.setString(1, currentVersion);
            pstmt.execute();
        }
    }

    private void createPreferencesTable(Connection conn) throws SQLException {
        if (!JdbcUtils.tableExists(this.getPreferencesTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getPreferencesTableName() + " ( id VARCHAR(36) not null, attributes " + this.getSqlBlobType() + ",  PRIMARY KEY (id))");
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModelVersion getPreferencesVersion(Connection conn) throws SQLException {
        block30: {
            storedVersion = null;
            stmt = conn.createStatement();
            var4_4 = null;
            try {
                rs = stmt.executeQuery(String.format("SELECT version FROM %s", new Object[]{this.getPreferencesVersionTableName()}));
                var6_8 = null;
                while (true) {
                    ** try [egrp 1[TRYBLOCK] [2, 3 : 39->102)] { 
lbl9:
                    // 1 sources

                    break;
lbl10:
                    // 1 sources

                    catch (Throwable var7_11) {
                        var6_8 = var7_11;
                        throw var7_11;
                    }
                    break;
                }
            }
            catch (Throwable var5_7) {
                var4_4 = var5_7;
                throw var5_7;
            }
            while (rs.next()) {
                versionString = rs.getString(1);
                try {
                    version = ModelVersion.fromString((String)versionString);
                    if (storedVersion != null && !storedVersion.lessThan(version)) ** continue;
                    storedVersion = version;
                }
                catch (IllegalArgumentException e) {
                    throw new StoreException("preference store version is malformed", (Throwable)e);
                }
            }
            break block30;
lbl27:
            // 1 sources

            finally {
                if (rs != null) {
                    if (var6_8 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable var7_10) {
                            var6_8.addSuppressed(var7_10);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    if (var4_4 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable var5_6) {
                            var4_4.addSuppressed(var5_6);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        if (storedVersion == null) {
            throw new StoreException("No preferences version found");
        }
        return storedVersion;
    }

    private Collection<PreferenceRecord> getPreferenceRecords(Connection connection) throws SQLException {
        LinkedHashSet<PreferenceRecord> records = new LinkedHashSet<PreferenceRecord>();
        ObjectMapper objectMapper = new ObjectMapper();
        try (PreparedStatement stmt = connection.prepareStatement(String.format(SELECT_FROM_PREFERENCES, this.getPreferencesTableName()));){
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String id = rs.getString(1);
                    String attributes = this.getBlobAsString(rs, 2);
                    PreferenceRecordImpl preferenceRecord = new PreferenceRecordImpl(UUID.fromString(id), (Map)objectMapper.readValue(attributes, Map.class));
                    records.add((PreferenceRecord)preferenceRecord);
                }
            }
            catch (IOException e) {
                throw new StoreException("Error recovering persistent state: " + e.getMessage(), (Throwable)e);
            }
        }
        return records;
    }

    private String getPreferencesTableName() {
        return this._tableNamePrefix + PREFERENCES_TABLE_NAME;
    }

    private String getPreferencesVersionTableName() {
        return this._tableNamePrefix + PREFERENCES_VERSION_TABLE_NAME;
    }

    static enum StoreState {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING,
        ERRORED;

    }
}

