/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;

public final class ExecutionResult
extends Method {
    public static final int TYPE = 770;
    private short packing_flags = 0;
    private int commandId;
    private Struct value;

    @Override
    public final int getStructType() {
        return 770;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public ExecutionResult() {
    }

    public ExecutionResult(int commandId, Struct value, Option ... _options) {
        this.setCommandId(commandId);
        if (value != null) {
            this.setValue(value);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.executionResult(context, this);
    }

    public final boolean hasCommandId() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ExecutionResult clearCommandId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.commandId = 0;
        this.setDirty(true);
        return this;
    }

    public final int getCommandId() {
        return this.commandId;
    }

    public final ExecutionResult setCommandId(int value) {
        this.commandId = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final ExecutionResult commandId(int value) {
        return this.setCommandId(value);
    }

    public final boolean hasValue() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ExecutionResult clearValue() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.value = null;
        this.setDirty(true);
        return this;
    }

    public final Struct getValue() {
        return this.value;
    }

    public final ExecutionResult setValue(Struct value) {
        this.value = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final ExecutionResult value(Struct value) {
        return this.setValue(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeSequenceNo(this.commandId);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStruct32(this.value);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.commandId = dec.readSequenceNo();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.value = dec.readStruct32();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("commandId", this.getCommandId());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("value", this.getValue());
        }
        return result;
    }
}

