/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import com.google.common.cache.Cache;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.EncoderUtils;
import org.apache.qpid.server.protocol.v0_10.transport.Range;
import org.apache.qpid.server.protocol.v0_10.transport.RangeSet;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;
import org.apache.qpid.server.protocol.v0_10.transport.Type;
import org.apache.qpid.server.transport.util.Functions;
import org.apache.qpid.server.virtualhost.CacheFactory;
import org.apache.qpid.server.virtualhost.NullCache;

public abstract class AbstractEncoder
implements Encoder {
    private static final NullCache<String, byte[]> NULL_CACHE = new NullCache();
    private static final ThreadLocal<Cache<String, byte[]>> CACHE = ThreadLocal.withInitial(() -> CacheFactory.getCache((String)"encodedStr8BytesCache", NULL_CACHE));

    protected abstract void doPut(byte var1);

    protected abstract void doPut(ByteBuffer var1);

    protected void put(byte b) {
        this.doPut(b);
    }

    protected void put(ByteBuffer src) {
        this.doPut(src);
    }

    protected void put(byte[] bytes) {
        this.put(ByteBuffer.wrap(bytes));
    }

    protected abstract int beginSize8();

    protected abstract void endSize8(int var1);

    protected abstract int beginSize16();

    protected abstract void endSize16(int var1);

    protected abstract int beginSize32();

    protected abstract void endSize32(int var1);

    @Override
    public void writeUint8(short b) {
        assert (b < 256);
        this.put((byte)b);
    }

    @Override
    public void writeUint16(int s) {
        assert (s < 65536);
        this.put(Functions.lsb((int)(s >>> 8)));
        this.put(Functions.lsb((int)s));
    }

    @Override
    public void writeUint32(long i) {
        assert (i < 0x100000000L);
        this.put(Functions.lsb((long)(i >>> 24)));
        this.put(Functions.lsb((long)(i >>> 16)));
        this.put(Functions.lsb((long)(i >>> 8)));
        this.put(Functions.lsb((long)i));
    }

    @Override
    public void writeSequenceNo(int i) {
        this.writeUint32(i);
    }

    @Override
    public void writeUint64(long l) {
        for (int i = 0; i < 8; ++i) {
            this.put(Functions.lsb((long)(l >> 56 - i * 8)));
        }
    }

    @Override
    public void writeDatetime(long l) {
        this.writeUint64(l);
    }

    @Override
    public void writeStr8(String s) {
        byte[] bytes;
        if (s == null) {
            s = "";
        }
        if ((bytes = (byte[])AbstractEncoder.getEncodedStringCache().getIfPresent((Object)s)) == null) {
            bytes = s.getBytes(StandardCharsets.UTF_8);
            if (bytes.length > 255) {
                throw new IllegalArgumentException(String.format("String too long (%d) for str8", bytes.length));
            }
            AbstractEncoder.getEncodedStringCache().put((Object)s, (Object)bytes);
        }
        this.writeUint8((short)bytes.length);
        this.put(bytes);
    }

    @Override
    public void writeStr16(String s) {
        byte[] bytes;
        if (s == null) {
            s = "";
        }
        if ((bytes = s.getBytes(StandardCharsets.UTF_8)).length > 65535) {
            throw new IllegalArgumentException(String.format("String too long (%d) for str16", bytes.length));
        }
        this.writeUint16(bytes.length);
        this.put(bytes);
    }

    @Override
    public void writeVbin8(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (bytes.length > 255) {
            throw new IllegalArgumentException("array too long: " + bytes.length);
        }
        this.writeUint8((short)bytes.length);
        this.put(ByteBuffer.wrap(bytes));
    }

    @Override
    public void writeVbin16(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        this.writeUint16(bytes.length);
        this.put(ByteBuffer.wrap(bytes));
    }

    @Override
    public void writeVbin32(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        this.writeUint32(bytes.length);
        this.put(ByteBuffer.wrap(bytes));
    }

    @Override
    public void writeSequenceSet(RangeSet ranges) {
        if (ranges == null) {
            this.writeUint16(0);
        } else {
            this.writeUint16(ranges.size() * 8);
            for (Range range : ranges) {
                this.writeSequenceNo(range.getLower());
                this.writeSequenceNo(range.getUpper());
            }
        }
    }

    @Override
    public void writeByteRanges(RangeSet ranges) {
        throw new Error("not implemented");
    }

    @Override
    public void writeUuid(UUID uuid) {
        long msb = 0L;
        long lsb = 0L;
        if (uuid != null) {
            msb = uuid.getMostSignificantBits();
            lsb = uuid.getLeastSignificantBits();
        }
        this.writeUint64(msb);
        this.writeUint64(lsb);
    }

    @Override
    public void writeStruct(int type, Struct s) {
        boolean empty = false;
        if (s == null) {
            s = Struct.create(type);
            empty = true;
        }
        int width = s.getSizeWidth();
        int pos = -1;
        if (width > 0) {
            pos = this.beginSize(width);
        }
        if (type > 0) {
            this.writeUint16(type);
        }
        s.write(this);
        if (width > 0) {
            this.endSize(width, pos);
        }
    }

    @Override
    public void writeStruct32(Struct s) {
        if (s == null) {
            this.writeUint32(0L);
        } else {
            int pos = this.beginSize32();
            this.writeUint16(s.getEncodedType());
            s.write(this);
            this.endSize32(pos);
        }
    }

    @Override
    public void writeMap(Map<String, Object> map) {
        int pos = this.beginSize32();
        if (map != null) {
            this.writeUint32(map.size());
            this.writeMapEntries(map);
        }
        this.endSize32(pos);
    }

    protected void writeMapEntries(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Type type = EncoderUtils.getEncodingType(value);
            this.writeStr8(key);
            this.put(type.getCode());
            this.write(type, value);
        }
    }

    @Override
    public void writeList(List<Object> list) {
        int pos = this.beginSize32();
        if (list != null) {
            this.writeUint32(list.size());
            this.writeListEntries(list);
        }
        this.endSize32(pos);
    }

    protected void writeListEntries(List<Object> list) {
        for (Object value : list) {
            Type type = EncoderUtils.getEncodingType(value);
            this.put(type.getCode());
            this.write(type, value);
        }
    }

    @Override
    public void writeArray(List<Object> array) {
        int pos = this.beginSize32();
        if (array != null) {
            this.writeArrayEntries(array);
        }
        this.endSize32(pos);
    }

    protected void writeArrayEntries(List<Object> array) {
        if (array.isEmpty()) {
            return;
        }
        Type type = EncoderUtils.getEncodingType(array.get(0));
        this.put(type.getCode());
        this.writeUint32(array.size());
        for (Object value : array) {
            this.write(type, value);
        }
    }

    private void writeSize(Type t, int size) {
        if (t.isFixed()) {
            if (size != t.getWidth()) {
                throw new IllegalArgumentException("size does not match fixed width " + t.getWidth() + ": " + size);
            }
        } else {
            this.writeSize(t.getWidth(), size);
        }
    }

    private void writeSize(int width, int size) {
        switch (width) {
            case 1: {
                this.writeUint8((short)size);
                break;
            }
            case 2: {
                this.writeUint16(size);
                break;
            }
            case 4: {
                this.writeUint32(size);
                break;
            }
            default: {
                throw new IllegalStateException("illegal width: " + width);
            }
        }
    }

    private int beginSize(int width) {
        switch (width) {
            case 1: {
                return this.beginSize8();
            }
            case 2: {
                return this.beginSize16();
            }
            case 4: {
                return this.beginSize32();
            }
        }
        throw new IllegalStateException("illegal width: " + width);
    }

    private void endSize(int width, int pos) {
        switch (width) {
            case 1: {
                this.endSize8(pos);
                break;
            }
            case 2: {
                this.endSize16(pos);
                break;
            }
            case 4: {
                this.endSize32(pos);
                break;
            }
            default: {
                throw new IllegalStateException("illegal width: " + width);
            }
        }
    }

    private void writeBytes(Type t, byte[] bytes) {
        this.writeSize(t, bytes.length);
        this.put(bytes);
    }

    private <T> T coerce(Class<T> klass, Object value) {
        if (klass.isInstance(value)) {
            return klass.cast(value);
        }
        throw new IllegalArgumentException("" + value);
    }

    private void write(Type t, Object value) {
        switch (t) {
            case BIN8: 
            case UINT8: {
                this.writeUint8(this.coerce(Short.class, value));
                break;
            }
            case INT8: {
                this.put(this.coerce(Byte.class, value));
                break;
            }
            case CHAR: {
                this.put((byte)this.coerce(Character.class, value).charValue());
                break;
            }
            case BOOLEAN: {
                if (this.coerce(Boolean.class, value).booleanValue()) {
                    this.put((byte)1);
                    break;
                }
                this.put((byte)0);
                break;
            }
            case BIN16: 
            case UINT16: {
                this.writeUint16(this.coerce(Integer.class, value));
                break;
            }
            case INT16: {
                this.writeUint16(this.coerce(Short.class, value).shortValue());
                break;
            }
            case BIN32: 
            case UINT32: {
                this.writeUint32(this.coerce(Long.class, value));
                break;
            }
            case CHAR_UTF32: 
            case INT32: {
                this.writeUint32(this.coerce(Integer.class, value).intValue());
                break;
            }
            case FLOAT: {
                this.writeUint32(Float.floatToIntBits(this.coerce(Float.class, value).floatValue()));
                break;
            }
            case BIN64: 
            case UINT64: 
            case INT64: 
            case DATETIME: {
                this.writeUint64(this.coerce(Long.class, value));
                break;
            }
            case DOUBLE: {
                long bits = Double.doubleToLongBits(this.coerce(Double.class, value));
                this.writeUint64(bits);
                break;
            }
            case UUID: {
                this.writeUuid(this.coerce(UUID.class, value));
                break;
            }
            case STR8: {
                this.writeStr8(this.coerce(String.class, value));
                break;
            }
            case STR16: {
                this.writeStr16(this.coerce(String.class, value));
                break;
            }
            case STR8_LATIN: 
            case STR16_LATIN: {
                Charset charset;
                try {
                    charset = Charset.forName("ISO-8859-15");
                }
                catch (UnsupportedCharsetException e) {
                    charset = StandardCharsets.ISO_8859_1;
                }
                this.writeBytes(t, this.coerce(String.class, value).getBytes(charset));
                break;
            }
            case STR8_UTF16: 
            case STR16_UTF16: {
                this.writeBytes(t, this.coerce(String.class, value).getBytes(StandardCharsets.UTF_16));
                break;
            }
            case MAP: {
                this.writeMap(this.coerce(Map.class, value));
                break;
            }
            case LIST: {
                this.writeList(this.coerce(List.class, value));
                break;
            }
            case ARRAY: {
                this.writeArray(this.coerce(List.class, value));
                break;
            }
            case STRUCT32: {
                this.writeStruct32(this.coerce(Struct.class, value));
                break;
            }
            case BIN40: 
            case DEC32: 
            case BIN72: 
            case DEC64: {
                this.writeBytes(t, this.coerce(byte[].class, value));
                break;
            }
            case VOID: {
                break;
            }
            default: {
                this.writeBytes(t, this.coerce(byte[].class, value));
            }
        }
    }

    static Cache<String, byte[]> getEncodedStringCache() {
        return CACHE.get();
    }

    static void setEncodedStringCache(Cache<String, byte[]> cache) {
        CACHE.set(cache);
    }
}

