/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.security.AccessController;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.logging.logback.PredicateAndLoggerNameAndLevelFilter;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.security.QpidPrincipal;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.SocketConnectionPrincipal;

class ConnectionAndUserPredicate
implements PredicateAndLoggerNameAndLevelFilter.Predicate {
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    private Pattern _usernamePattern = MATCH_ALL;
    private Pattern _connectionNamePattern = MATCH_ALL;
    private Pattern _remoteContainerIdPattern = MATCH_ALL;

    ConnectionAndUserPredicate() {
    }

    @Override
    public boolean evaluate(ILoggingEvent event) {
        String userPrincipalString = "";
        String connectionString = "";
        String remoteContainerName = "";
        Subject subject = Subject.getSubject(AccessController.getContext());
        Set<SocketConnectionPrincipal> connectionPrincipals = subject.getPrincipals(SocketConnectionPrincipal.class);
        Set<AuthenticatedPrincipal> userPrincipals = subject.getPrincipals(AuthenticatedPrincipal.class);
        if (!connectionPrincipals.isEmpty()) {
            SocketConnectionPrincipal socketConnectionPrincipal = connectionPrincipals.iterator().next();
            connectionString = socketConnectionPrincipal.getName();
            if (socketConnectionPrincipal instanceof ConnectionPrincipal && (remoteContainerName = ((ConnectionPrincipal)socketConnectionPrincipal).getConnection().getRemoteContainerName()) == null) {
                remoteContainerName = "";
            }
        }
        if (!userPrincipals.isEmpty()) {
            userPrincipalString = new GenericPrincipal((QpidPrincipal)userPrincipals.iterator().next()).toExternalForm();
        }
        return this._usernamePattern.matcher(userPrincipalString).matches() && this._connectionNamePattern.matcher(connectionString).matches() && this._remoteContainerIdPattern.matcher(remoteContainerName).matches();
    }

    void setConnectionNamePattern(String connectionName) {
        this._connectionNamePattern = connectionName != null ? Pattern.compile(connectionName) : MATCH_ALL;
    }

    void setRemoteContainerIdPattern(String remoteContainerId) {
        this._remoteContainerIdPattern = remoteContainerId != null ? Pattern.compile(remoteContainerId) : MATCH_ALL;
    }

    void setUsernamePattern(String usernamePattern) {
        this._usernamePattern = usernamePattern != null ? Pattern.compile(usernamePattern) : MATCH_ALL;
    }
}

