/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;

public class FileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCES_PREFIX = "/resources";
    private static final Map<String, String> CONTENT_TYPES;
    private final String _resourcePathPrefix;
    private final boolean _usePathInfo;

    public FileServlet() {
        this(RESOURCES_PREFIX, false);
    }

    public FileServlet(String resourcePathPrefix, boolean usePathInfo) {
        this._resourcePathPrefix = resourcePathPrefix;
        this._usePathInfo = usePathInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block9: {
            URL resourceURL;
            String suffix;
            String contentType;
            String filename = null;
            filename = this._usePathInfo ? request.getPathInfo() : request.getServletPath();
            if (filename.contains(".") && (contentType = CONTENT_TYPES.get(suffix = filename.substring(filename.lastIndexOf(46) + 1))) != null) {
                response.setContentType(contentType);
            }
            if ((resourceURL = ((Object)((Object)this)).getClass().getResource(this._resourcePathPrefix + filename)) != null) {
                response.setStatus(200);
                try (InputStream fileInput = resourceURL.openStream();){
                    byte[] buffer = new byte[1024];
                    int read = 0;
                    try (OutputStream output = HttpManagementUtil.getOutputStream(request, response);){
                        while ((read = fileInput.read(buffer)) != -1) {
                            output.write(buffer, 0, read);
                        }
                        break block9;
                    }
                }
            }
            response.sendError(404, "unknown file");
        }
    }

    static {
        HashMap<String, String> contentTypes = new HashMap<String, String>();
        contentTypes.put("js", "application/javascript");
        contentTypes.put("html", "text/html");
        contentTypes.put("css", "text/css");
        contentTypes.put("json", "application/json");
        contentTypes.put("jpg", "image/jpg");
        contentTypes.put("png", "image/png");
        contentTypes.put("gif", "image/gif");
        contentTypes.put("svg", "image/svg+xml");
        CONTENT_TYPES = Collections.unmodifiableMap(contentTypes);
    }
}

