/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.portunification;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class MarkableEndPoint
implements EndPoint {
    private final EndPoint _underlying;
    private final List<ByteBuffer> _preserved = new ArrayList<ByteBuffer>();
    private volatile boolean _marked;

    MarkableEndPoint(EndPoint underlying) {
        this._underlying = underlying;
    }

    public InetSocketAddress getLocalAddress() {
        return this._underlying.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._underlying.getRemoteAddress();
    }

    public boolean isOpen() {
        return this._underlying.isOpen();
    }

    public long getCreatedTimeStamp() {
        return this._underlying.getCreatedTimeStamp();
    }

    public void shutdownOutput() {
        this._underlying.shutdownOutput();
    }

    public boolean isOutputShutdown() {
        return this._underlying.isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this._underlying.isInputShutdown();
    }

    public void close() {
        this._underlying.close();
    }

    public boolean flush(ByteBuffer ... buffer) throws IOException {
        return this._underlying.flush(buffer);
    }

    public Object getTransport() {
        return this._underlying.getTransport();
    }

    public long getIdleTimeout() {
        return this._underlying.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeout) {
        this._underlying.setIdleTimeout(idleTimeout);
    }

    public void fillInterested(Callback callback) throws ReadPendingException {
        this._underlying.fillInterested(callback);
    }

    public boolean tryFillInterested(Callback callback) {
        return this._underlying.tryFillInterested(callback);
    }

    public boolean isFillInterested() {
        return this._underlying.isFillInterested();
    }

    public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
        this._underlying.write(callback, buffers);
    }

    public Connection getConnection() {
        return this._underlying.getConnection();
    }

    public void setConnection(Connection connection) {
        this._underlying.setConnection(connection);
    }

    public void onOpen() {
        this._underlying.onOpen();
    }

    public void onClose() {
        this._underlying.onClose();
    }

    public boolean isOptimizedForDirectBuffers() {
        return this._underlying.isOptimizedForDirectBuffers();
    }

    public void upgrade(Connection newConnection) {
        this._underlying.upgrade(newConnection);
    }

    public synchronized int fill(ByteBuffer dst) throws IOException {
        if (this._marked) {
            int oldLimit = dst.limit();
            int i = this._underlying.fill(dst);
            int newLimit = dst.limit();
            ByteBuffer buf = this.preserve(dst.duplicate(), newLimit, oldLimit);
            this._preserved.add(buf);
            return i;
        }
        int i = 0;
        if (!this._preserved.isEmpty()) {
            i += this.fillFromPreserved(dst);
            if (!this._preserved.isEmpty()) {
                return i;
            }
        }
        return i += this._underlying.fill(dst);
    }

    synchronized void mark() {
        if (!this._preserved.isEmpty()) {
            throw new IllegalStateException("Already marked");
        }
        this._marked = true;
    }

    synchronized void rewind() {
        if (!this._marked) {
            throw new IllegalStateException("Not marked");
        }
        this._marked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillFromPreserved(ByteBuffer dst) {
        int filled = 0;
        int pos = BufferUtil.flipToFill((ByteBuffer)dst);
        try {
            Iterator<ByteBuffer> bufferIterator = this._preserved.iterator();
            while (bufferIterator.hasNext()) {
                ByteBuffer buffer = bufferIterator.next();
                int bufRemaining = buffer.remaining();
                int dstRemaining = dst.remaining();
                if (dstRemaining >= bufRemaining) {
                    dst.put(buffer);
                } else {
                    ByteBuffer slice = buffer.slice();
                    slice.limit(dstRemaining);
                    dst.put(slice);
                    buffer.position(buffer.position() + dstRemaining);
                }
                filled += bufRemaining - buffer.remaining();
                if (buffer.hasRemaining()) {
                    int n = filled;
                    return n;
                }
                bufferIterator.remove();
            }
        }
        finally {
            BufferUtil.flipToFlush((ByteBuffer)dst, (int)pos);
        }
        return filled;
    }

    private ByteBuffer preserve(ByteBuffer dst, int newLimit, int oldLimit) {
        ByteBuffer buf = BufferUtil.allocate((int)(newLimit - oldLimit));
        ByteBuffer slice = dst.slice();
        slice.position(oldLimit);
        slice.limit(newLimit);
        BufferUtil.append((ByteBuffer)buf, (ByteBuffer)slice);
        return buf;
    }
}

