/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = null;
        String url = null;
        if (LOGGER.isDebugEnabled()) {
            method = httpRequest.getMethod();
            url = HttpManagementUtil.getRequestURL(httpRequest);
            LOGGER.debug("REQUEST  method='{}' url='{}'", (Object)method, (Object)url);
        }
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            if (LOGGER.isDebugEnabled()) {
                String responseStatus = String.valueOf(httpResponse.getStatus());
                LOGGER.debug("RESPONSE method='{}' url='{}' status='{}'", new Object[]{method, url, responseStatus});
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            String responseStatus = String.valueOf(httpResponse.getStatus());
            LOGGER.debug("RESPONSE method='{}' url='{}' status='{}'", new Object[]{method, url, responseStatus});
        }
    }

    public void destroy() {
    }
}

