/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.KerberosAuthenticationManager;

@PluggableService
public class SpnegoPreemptiveAuthenticator
implements HttpRequestPreemptiveAuthenticator {
    @Override
    public Subject attemptAuthentication(HttpServletRequest request, HttpManagementConfiguration configuration) {
        AuthenticationProvider authenticationProvider = configuration.getAuthenticationProvider(request);
        if (authenticationProvider instanceof KerberosAuthenticationManager) {
            KerberosAuthenticationManager kerberosProvider = (KerberosAuthenticationManager)authenticationProvider;
            String authorizationHeader = request.getHeader("Authorization");
            AuthenticationResult authenticationResult = kerberosProvider.authenticate(authorizationHeader);
            Port<?> port = configuration.getPort(request);
            SubjectCreator subjectCreator = port.getSubjectCreator(request.isSecure(), request.getServerName());
            SubjectAuthenticationResult result = subjectCreator.createResultWithGroups(authenticationResult);
            return result.getSubject();
        }
        return null;
    }

    public String getType() {
        return "SPNEGO";
    }
}

