/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import java.nio.charset.StandardCharsets;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.UsernamePasswordAuthenticationProvider;
import org.apache.qpid.server.util.Strings;

@PluggableService
public class BasicAuthPreemptiveAuthenticator
implements HttpRequestPreemptiveAuthenticator {
    private static final String BASIC_AUTH = "BasicAuth";

    @Override
    public Subject attemptAuthentication(HttpServletRequest request, HttpManagementConfiguration managementConfiguration) {
        String header = request.getHeader("Authorization");
        Port<?> port = managementConfiguration.getPort(request);
        AuthenticationProvider authenticationProvider = managementConfiguration.getAuthenticationProvider(request);
        SubjectCreator subjectCreator = port.getSubjectCreator(request.isSecure(), request.getServerName());
        if (header != null && authenticationProvider instanceof UsernamePasswordAuthenticationProvider) {
            UsernamePasswordAuthenticationProvider namePasswdAuthProvider = (UsernamePasswordAuthenticationProvider)authenticationProvider;
            String[] tokens = header.split("\\s");
            if (tokens.length >= 2 && "BASIC".equalsIgnoreCase(tokens[0])) {
                String base64UsernameAndPassword;
                String[] credentials;
                boolean isBasicAuthSupported = false;
                isBasicAuthSupported = request.isSecure() ? managementConfiguration.isHttpsBasicAuthenticationEnabled() : managementConfiguration.isHttpBasicAuthenticationEnabled();
                if (isBasicAuthSupported && (credentials = new String(Strings.decodePrivateBase64((String)(base64UsernameAndPassword = tokens[1]), (String)"basic authentication credentials"), StandardCharsets.UTF_8).split(":", 2)).length == 2) {
                    String username = credentials[0];
                    String password = credentials[1];
                    AuthenticationResult authenticationResult = namePasswdAuthProvider.authenticate(username, password);
                    SubjectAuthenticationResult result = subjectCreator.createResultWithGroups(authenticationResult);
                    return result.getSubject();
                }
            }
        }
        return null;
    }

    public String getType() {
        return BASIC_AUTH;
    }
}

