/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.RemoteReplicationNode;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreAttributes;
import org.apache.qpid.server.virtualhostnode.RedirectingVirtualHostImpl;
import org.apache.qpid.server.virtualhostnode.RedirectingVirtualHostNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectingVirtualHostNodeImpl
extends AbstractConfiguredObject<RedirectingVirtualHostNodeImpl>
implements RedirectingVirtualHostNode<RedirectingVirtualHostNodeImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectingVirtualHostImpl.class);
    public static final String VIRTUAL_HOST_NODE_TYPE = "Redirector";
    private final Broker<?> _broker;
    @ManagedAttributeField
    private String _virtualHostInitialConfiguration;
    @ManagedAttributeField
    private boolean _defaultVirtualHostNode;
    @ManagedAttributeField
    private PreferenceStoreAttributes _preferenceStoreAttributes;
    @ManagedAttributeField
    private Map<Port<?>, String> _redirects;
    private volatile RedirectingVirtualHostImpl _virtualHost;

    @ManagedObjectFactoryConstructor
    public RedirectingVirtualHostNodeImpl(Map<String, Object> attributes, Broker<?> parent) {
        super(parent, attributes);
        this._broker = parent;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.STOPPED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> doActivate() {
        final SettableFuture resultFuture = SettableFuture.create();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", this.getName());
        attributes.put("type", "REDIRECTOR");
        ListenableFuture<VirtualHost> virtualHostFuture = this.getObjectFactory().createAsync(VirtualHost.class, attributes, this);
        RedirectingVirtualHostNodeImpl.addFutureCallback(virtualHostFuture, new FutureCallback<VirtualHost>(){

            public void onSuccess(VirtualHost virtualHost) {
                RedirectingVirtualHostNodeImpl.this._virtualHost = (RedirectingVirtualHostImpl)virtualHost;
                RedirectingVirtualHostNodeImpl.this.setState(State.ACTIVE);
                resultFuture.set(null);
            }

            public void onFailure(Throwable t) {
                RedirectingVirtualHostNodeImpl.this.setState(State.ERRORED);
                if (((Broker)RedirectingVirtualHostNodeImpl.this.getParent()).isManagementMode()) {
                    LOGGER.warn("Failed to make {} active.", (Object)this, (Object)t);
                    resultFuture.set(null);
                } else {
                    resultFuture.setException(t);
                }
            }
        }, this.getTaskExecutor());
        return resultFuture;
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED, State.UNINITIALIZED}, desiredState=State.STOPPED)
    private ListenableFuture<Void> doStop() {
        final ListenableFuture future = Futures.immediateFuture(null);
        RedirectingVirtualHostImpl virtualHost = this._virtualHost;
        if (virtualHost != null) {
            return this.doAfter(virtualHost.closeAsync(), new Callable<ListenableFuture<Void>>(){

                @Override
                public ListenableFuture<Void> call() throws Exception {
                    RedirectingVirtualHostNodeImpl.this._virtualHost = null;
                    RedirectingVirtualHostNodeImpl.this.setState(State.STOPPED);
                    return future;
                }
            });
        }
        this.setState(State.STOPPED);
        return future;
    }

    @Override
    protected ListenableFuture<Void> beforeClose() {
        ListenableFuture<Void> superFuture = super.beforeClose();
        return this.closeVirtualHost(superFuture);
    }

    @Override
    protected ListenableFuture<Void> beforeDelete() {
        ListenableFuture<Void> superFuture = super.beforeDelete();
        return this.closeVirtualHost(superFuture);
    }

    private ListenableFuture<Void> closeVirtualHost(ListenableFuture<Void> superFuture) {
        RedirectingVirtualHostImpl virtualHost = this._virtualHost;
        if (virtualHost != null) {
            return this.doAfter(virtualHost.closeAsync(), () -> {
                this._virtualHost = null;
                return superFuture;
            });
        }
        return superFuture;
    }

    @Override
    public String getVirtualHostInitialConfiguration() {
        return this._virtualHostInitialConfiguration;
    }

    @Override
    public boolean isDefaultVirtualHostNode() {
        return this._defaultVirtualHostNode;
    }

    @Override
    public VirtualHost<?> getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public DurableConfigurationStore getConfigurationStore() {
        return null;
    }

    @Override
    public Collection<? extends RemoteReplicationNode> getRemoteReplicationNodes() {
        return Collections.emptySet();
    }

    @Override
    public PreferenceStore createPreferenceStore() {
        return null;
    }

    @Override
    public PreferenceStoreAttributes getPreferenceStoreAttributes() {
        return this._preferenceStoreAttributes;
    }

    @Override
    public Map<Port<?>, String> getRedirects() {
        return this._redirects;
    }

    @Override
    protected void validateOnCreate() {
        VirtualHostNode existingDefault;
        super.validateOnCreate();
        if (this.isDefaultVirtualHostNode() && (existingDefault = this._broker.findDefautVirtualHostNode()) != null) {
            throw new IntegrityViolationException("The existing virtual host node '" + existingDefault.getName() + "' is already the default for the Broker.");
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        VirtualHostNode existingDefault;
        super.validateChange(proxyForValidation, changedAttributes);
        VirtualHostNode updated = (VirtualHostNode)proxyForValidation;
        if (changedAttributes.contains("defaultVirtualHostNode") && updated.isDefaultVirtualHostNode() && (existingDefault = this._broker.findDefautVirtualHostNode()) != null && existingDefault != this) {
            throw new IntegrityViolationException("Cannot make '" + this.getName() + "' the default virtual host node for the Broker as virtual host node '" + existingDefault.getName() + "' is already the default.");
        }
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        if (childClass == VirtualHost.class) {
            throw new UnsupportedOperationException("The redirecting virtualhost node automatically manages the creation of the redirecting virtualhost. Creating it explicitly is not supported.");
        }
        return super.addChildAsync(childClass, attributes);
    }

    public static Map<String, Collection<String>> getSupportedChildTypes() {
        Set<String> validVhostTypes = Collections.singleton("type");
        return Collections.singletonMap(VirtualHost.class.getSimpleName(), validVhostTypes);
    }
}

