/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class FixedKeyMapCreator {
    private final String[] _keys;
    private final int[] _keyHashCodes;
    private final Set<String> _keySet = new AbstractSet<String>(){

        @Override
        public Iterator<String> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return FixedKeyMapCreator.this._keys.length;
        }
    };

    public FixedKeyMapCreator(String ... keys) {
        this._keys = keys;
        this._keyHashCodes = new int[keys.length];
        HashSet<String> uniqueKeys = new HashSet<String>(Arrays.asList(keys));
        if (uniqueKeys.size() != keys.length) {
            ArrayList<String> duplicateKeys = new ArrayList<String>(Arrays.asList(keys));
            duplicateKeys.removeAll(uniqueKeys);
            throw new IllegalArgumentException("The supplied keys must be unique, but the following keys are duplicated: " + duplicateKeys);
        }
        for (int i = 0; i < keys.length; ++i) {
            this._keyHashCodes[i] = keys[i].hashCode();
        }
    }

    public Map<String, Object> createMap(Object ... values) {
        if (values.length != this._keys.length) {
            throw new IllegalArgumentException("There are " + this._keys.length + " keys, so that many values must be supplied");
        }
        return new FixedKeyMap(values);
    }

    private class KeysIterator
    implements Iterator<String> {
        private int _position = 0;

        private KeysIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._position < FixedKeyMapCreator.this._keys.length;
        }

        @Override
        public String next() {
            try {
                return FixedKeyMapCreator.this._keys[this._position++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FixedKeyEntry
    implements Map.Entry<String, Object> {
        private final String _key;
        private final Object _value;

        private FixedKeyEntry(String key, Object value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e2 = (Map.Entry)o;
                return this._key.equals(e2.getKey()) && (this._value == null ? e2.getValue() == null : this._value.equals(e2.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ (this._value == null ? 0 : this._value.hashCode());
        }
    }

    private final class FixedKeyMap
    extends AbstractMap<String, Object> {
        private final Object[] _values;

        private FixedKeyMap(Object[] values) {
            this._values = values;
        }

        @Override
        public Object get(Object key) {
            int keyHashCode = key.hashCode();
            for (int i = 0; i < FixedKeyMapCreator.this._keys.length; ++i) {
                if (FixedKeyMapCreator.this._keyHashCodes[i] != keyHashCode || !FixedKeyMapCreator.this._keys[i].equals(key)) continue;
                return this._values[i];
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                for (Object o : this._values) {
                    if (o != null) continue;
                    return true;
                }
            } else {
                for (Object o : this._values) {
                    if (!value.equals(o)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            int keyHashCode = key.hashCode();
            for (int i = 0; i < FixedKeyMapCreator.this._keys.length; ++i) {
                if (FixedKeyMapCreator.this._keyHashCodes[i] != keyHashCode || !FixedKeyMapCreator.this._keys[i].equals(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            return FixedKeyMapCreator.this._keySet;
        }

        @Override
        public Collection<Object> values() {
            return Collections.unmodifiableCollection(Arrays.asList(this._values));
        }

        @Override
        public int size() {
            return this._values.length;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new EntrySet();
        }

        private class EntrySetIterator
        implements Iterator<Map.Entry<String, Object>> {
            private int _position = 0;

            private EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this._position < FixedKeyMapCreator.this._keys.length;
            }

            @Override
            public Map.Entry<String, Object> next() {
                try {
                    String key = FixedKeyMapCreator.this._keys[this._position];
                    Object value = FixedKeyMap.this._values[this._position++];
                    return new FixedKeyEntry(key, value);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<String, Object>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new EntrySetIterator();
            }

            @Override
            public int size() {
                return FixedKeyMapCreator.this._keys.length;
            }
        }
    }
}

