/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ContainerType;
import org.apache.qpid.server.model.DynamicModel;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;

public class ConfiguredObjectRecordConverter {
    private Model _model;
    private Class<? extends ConfiguredObject> _rootClass;

    public ConfiguredObjectRecordConverter(Model model) {
        this._model = model;
    }

    public Class<? extends ConfiguredObject> getRootClass() {
        return this._rootClass;
    }

    public Model getModel() {
        return this._model;
    }

    public Collection<ConfiguredObjectRecord> readFromJson(Class<? extends ConfiguredObject> rootClass, ConfiguredObject<?> parent, Reader reader) throws IOException {
        HashMap<UUID, ConfiguredObjectRecord> objectsById = new HashMap<UUID, ConfiguredObjectRecord>();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        Map data = (Map)objectMapper.readValue(reader, Map.class);
        if (!data.isEmpty()) {
            if (rootClass == null && parent instanceof DynamicModel) {
                QpidServiceLoader loader;
                Map<String, ContainerType> instancesByType;
                ContainerType containerType;
                String defaultContainerType;
                String containerTypeName = defaultContainerType = ((DynamicModel)((Object)parent)).getDefaultContainerType();
                if (data.get("type") instanceof String) {
                    containerTypeName = data.get("type").toString();
                }
                if ((containerType = (instancesByType = (loader = new QpidServiceLoader()).getInstancesByType(ContainerType.class)).get(containerTypeName)) != null) {
                    this._model = containerType.getModel();
                    rootClass = containerType.getCategoryClass();
                } else {
                    ContainerType defaultContainerTypeInstance = instancesByType.get(defaultContainerType);
                    if (defaultContainerTypeInstance != null) {
                        this._model = defaultContainerTypeInstance.getModel();
                        rootClass = defaultContainerTypeInstance.getCategoryClass();
                    } else {
                        throw new IllegalConfigurationException(String.format("Cannot identify container type for '%s'", containerType));
                    }
                }
            }
            Collection<NameToIdResolver> unresolved = this.loadChild(rootClass, data, parent.getCategoryClass(), parent.getId(), objectsById);
            this._rootClass = rootClass;
            Iterator<NameToIdResolver> iterator = unresolved.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().resolve(objectsById)) continue;
                iterator.remove();
            }
            if (!unresolved.isEmpty()) {
                throw new IllegalArgumentException("Initial configuration has unresolved references");
            }
        }
        return objectsById.values();
    }

    private Collection<NameToIdResolver> loadChild(Class<? extends ConfiguredObject> clazz, Map<String, Object> data, Class<? extends ConfiguredObject> parentClass, UUID parentId, Map<UUID, ConfiguredObjectRecord> records) {
        String idStr = (String)data.remove("id");
        UUID id = idStr == null ? UUID.randomUUID() : UUID.fromString(idStr);
        String type = clazz.getSimpleName();
        HashMap<String, UUID> parentMap = new HashMap<String, UUID>();
        Collection<Class<? extends ConfiguredObject>> childClasses = this._model.getChildTypes(clazz);
        ArrayList<NameToIdResolver> requiringResolution = new ArrayList<NameToIdResolver>();
        for (Class<? extends ConfiguredObject> childClass : childClasses) {
            String childType = childClass.getSimpleName();
            String singularName = childType.toLowerCase();
            String attrName = singularName + (singularName.endsWith("s") ? "es" : "s");
            Object children = data.remove(attrName);
            if (children == null || !(children instanceof Collection)) continue;
            for (Object child : (Collection)children) {
                if (!(child instanceof Map)) continue;
                requiringResolution.addAll(this.loadChild(childClass, (Map)child, clazz, id, records));
            }
        }
        if (parentId != null) {
            parentMap.put(parentClass.getSimpleName(), parentId);
        }
        records.put(id, new ConfiguredObjectRecordImpl(id, type, data, parentMap));
        return requiringResolution;
    }

    private static class AncestorFindingResolver
    implements NameToIdResolver {
        private final String _parentType;
        private final String _parentName;
        private final String _commonAncestorType;
        private final UUID _id;

        public AncestorFindingResolver(UUID id, String parentType, String parentName, String commonAncestorType) {
            this._id = id;
            this._parentType = parentType;
            this._parentName = parentName;
            this._commonAncestorType = commonAncestorType;
        }

        @Override
        public boolean resolve(Map<UUID, ConfiguredObjectRecord> objectsById) {
            ConfiguredObjectRecord record = objectsById.get(this._id);
            ArrayList<ConfiguredObjectRecord> recordsWithMatchingName = new ArrayList<ConfiguredObjectRecord>();
            for (ConfiguredObjectRecord possibleParentRecord : objectsById.values()) {
                if (!possibleParentRecord.getType().equals(this._parentType) || !this._parentName.equals(possibleParentRecord.getAttributes().get("name"))) continue;
                recordsWithMatchingName.add(possibleParentRecord);
            }
            for (ConfiguredObjectRecord candidate : recordsWithMatchingName) {
                UUID candidateAncestor = this.findAncestor(candidate, this._commonAncestorType, objectsById);
                UUID recordAncestor = this.findAncestor(record, this._commonAncestorType, objectsById);
                if (!recordAncestor.equals(candidateAncestor)) continue;
                HashMap<String, UUID> parents = new HashMap<String, UUID>(record.getParents());
                parents.put(this._parentType, candidate.getId());
                objectsById.put(this._id, new ConfiguredObjectRecordImpl(this._id, record.getType(), record.getAttributes(), parents));
                return true;
            }
            return false;
        }

        private UUID findAncestor(ConfiguredObjectRecord record, String commonAncestorType, Map<UUID, ConfiguredObjectRecord> objectsById) {
            UUID id = record.getParents().get(commonAncestorType);
            if (id == null) {
                for (UUID parentId : record.getParents().values()) {
                    ConfiguredObjectRecord parent = objectsById.get(parentId);
                    if (parent != null) {
                        id = this.findAncestor(parent, commonAncestorType, objectsById);
                    }
                    if (id == null) continue;
                    break;
                }
            }
            return id;
        }
    }

    private static interface NameToIdResolver {
        public boolean resolve(Map<UUID, ConfiguredObjectRecord> var1);
    }
}

