/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5Negotiator;
import org.apache.qpid.server.security.auth.sasl.plain.PlainNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSourceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="Simple", register=false)
public class SimpleAuthenticationManager
extends AbstractAuthenticationManager<SimpleAuthenticationManager>
implements PasswordCredentialManagingAuthenticationProvider<SimpleAuthenticationManager> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleAuthenticationManager.class);
    private static final String PLAIN_MECHANISM = "PLAIN";
    private static final String CRAM_MD5_MECHANISM = "CRAM-MD5";
    private static final String SCRAM_SHA1_MECHANISM = "SCRAM-SHA-1";
    private static final String SCRAM_SHA256_MECHANISM = "SCRAM-SHA-256";
    private final Map<String, String> _users = Collections.synchronizedMap(new HashMap());
    private volatile ScramSaslServerSourceAdapter _scramSha1Adapter;
    private volatile ScramSaslServerSourceAdapter _scramSha256Adapter;

    public SimpleAuthenticationManager(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        PasswordSource passwordSource = this.getPasswordSource();
        int scramIterationCount = this.getContextValue(Integer.class, "qpid.auth.scram.iteration_count");
        this._scramSha1Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA1", "SHA-1", passwordSource);
        this._scramSha256Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA256", "SHA-256", passwordSource);
    }

    public void addUser(String username, String password) {
        this.createUser(username, password, Collections.EMPTY_MAP);
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.unmodifiableList(Arrays.asList(PLAIN_MECHANISM, CRAM_MD5_MECHANISM, SCRAM_SHA1_MECHANISM, SCRAM_SHA256_MECHANISM));
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if (PLAIN_MECHANISM.equals(mechanism)) {
            return new PlainNegotiator(this);
        }
        if (CRAM_MD5_MECHANISM.equals(mechanism)) {
            return new CramMd5Negotiator(this, saslSettings.getLocalFQDN(), this.getPasswordSource());
        }
        if (SCRAM_SHA1_MECHANISM.equals(mechanism)) {
            return new ScramNegotiator(this, this._scramSha1Adapter, SCRAM_SHA1_MECHANISM);
        }
        if (SCRAM_SHA256_MECHANISM.equals(mechanism)) {
            return new ScramNegotiator(this, this._scramSha256Adapter, SCRAM_SHA256_MECHANISM);
        }
        return null;
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        String userPassword;
        if (this._users.containsKey(username) && (userPassword = this._users.get(username)).equals(password)) {
            return new AuthenticationResult(new UsernamePrincipal(username, this));
        }
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
    }

    @Override
    public boolean createUser(String username, String password, Map<String, String> attributes) {
        this._users.put(username, password);
        return true;
    }

    @Override
    public void deleteUser(String username) throws AccountNotFoundException {
        if (this._users.remove(username) == null) {
            throw new AccountNotFoundException("No such user: '" + username + "'");
        }
    }

    @Override
    public void setPassword(String username, String password) throws AccountNotFoundException {
        if (!this._users.containsKey(username)) {
            throw new AccountNotFoundException("No such user: '" + username + "'");
        }
        this._users.put(username, password);
    }

    @Override
    public Map<String, Map<String, String>> getUsers() {
        HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>();
        for (String username : this._users.keySet()) {
            users.put(username, Collections.EMPTY_MAP);
        }
        return users;
    }

    @Override
    public void reload() throws IOException {
    }

    private PasswordSource getPasswordSource() {
        return new PasswordSource(){

            @Override
            public char[] getPassword(String username) {
                String password = (String)SimpleAuthenticationManager.this._users.get(username);
                return password == null ? null : password.toCharArray();
            }
        };
    }
}

