/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.util.concurrent.ListenableFuture;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.ManagedUser;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.plain.PlainNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSource;
import org.apache.qpid.server.util.Strings;

public abstract class AbstractScramAuthenticationManager<X extends AbstractScramAuthenticationManager<X>>
extends ConfigModelPasswordManagingAuthenticationProvider<X>
implements PasswordCredentialManagingAuthenticationProvider<X>,
ScramSaslServerSource {
    public static final String PLAIN = "PLAIN";
    private final SecureRandom _random = new SecureRandom();
    public static final String QPID_AUTHMANAGER_SCRAM_ITERATION_COUNT = "qpid.auth.scram.iteration_count";
    @ManagedContextDefault(name="qpid.auth.scram.iteration_count")
    public static final int DEFAULT_ITERATION_COUNT = 4096;
    private int _iterationCount = 4096;
    private boolean _doNotCreateStoredPasswordBecauseItIsBeingUpgraded;
    private static final byte[] INT_1 = new byte[]{0, 0, 0, 1};

    protected AbstractScramAuthenticationManager(Map<String, Object> attributes, Broker broker) {
        super(attributes, broker);
    }

    @Override
    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.QUIESCED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        this._iterationCount = this.getContextValue(Integer.class, QPID_AUTHMANAGER_SCRAM_ITERATION_COUNT);
        for (ManagedUser user : this.getUserMap().values()) {
            this.updateStoredPasswordFormatIfNecessary(user);
        }
        return super.activate();
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.unmodifiableList(Arrays.asList(this.getMechanismName(), PLAIN));
    }

    protected abstract String getMechanismName();

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if (this.getMechanismName().equals(mechanism)) {
            return new ScramNegotiator(this, this, this.getMechanismName());
        }
        if (PLAIN.equals(mechanism)) {
            return new PlainNegotiator(this);
        }
        return null;
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        ManagedUser user = this.getUser(username);
        if (user != null) {
            this.updateStoredPasswordFormatIfNecessary(user);
            ScramSaslServerSource.SaltAndPasswordKeys saltAndPasswordKeys = this.getSaltAndPasswordKeys(username);
            try {
                byte[] saltedPassword = this.createSaltedPassword(saltAndPasswordKeys.getSalt(), password, saltAndPasswordKeys.getIterationCount());
                byte[] clientKey = this.computeHmac(saltedPassword, "Client Key");
                byte[] storedKey = MessageDigest.getInstance(this.getDigestName()).digest(clientKey);
                byte[] serverKey = this.computeHmac(saltedPassword, "Server Key");
                if (Arrays.equals(saltAndPasswordKeys.getStoredKey(), storedKey) && Arrays.equals(saltAndPasswordKeys.getServerKey(), serverKey)) {
                    return new AuthenticationResult(new UsernamePrincipal(username, this));
                }
            }
            catch (IllegalArgumentException | NoSuchAlgorithmException | SaslException e) {
                return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
            }
        }
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
    }

    @Override
    public int getIterationCount() {
        return this._iterationCount;
    }

    private void updateStoredPasswordFormatIfNecessary(ManagedUser user) {
        int oldDefaultIterationCount = 4096;
        String[] passwordFields = user.getPassword().split(",");
        if (passwordFields.length == 2) {
            byte[] saltedPassword = Strings.decodePrivateBase64(passwordFields[PasswordField.SALTED_PASSWORD.ordinal()], "user '" + user.getName() + "' salted password");
            try {
                byte[] clientKey = this.computeHmac(saltedPassword, "Client Key");
                byte[] storedKey = MessageDigest.getInstance(this.getDigestName()).digest(clientKey);
                byte[] serverKey = this.computeHmac(saltedPassword, "Server Key");
                String password = passwordFields[PasswordField.SALT.ordinal()] + ",," + Base64.getEncoder().encodeToString(storedKey) + "," + Base64.getEncoder().encodeToString(serverKey) + "," + 4096;
                this.upgradeUserPassword(user, password);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (passwordFields.length == 4) {
            String password = passwordFields[PasswordField.SALT.ordinal()] + ",," + passwordFields[PasswordField.STORED_KEY.ordinal()] + "," + passwordFields[PasswordField.SERVER_KEY.ordinal()] + "," + 4096;
            this.upgradeUserPassword(user, password);
        } else if (passwordFields.length != 5) {
            throw new IllegalConfigurationException("password field for user '" + user.getName() + "' has unrecognised format.");
        }
    }

    private void upgradeUserPassword(ManagedUser user, String password) {
        try {
            this._doNotCreateStoredPasswordBecauseItIsBeingUpgraded = true;
            user.setPassword(password);
        }
        finally {
            this._doNotCreateStoredPasswordBecauseItIsBeingUpgraded = false;
        }
    }

    private byte[] createSaltedPassword(byte[] salt, String password, int iterationCount) {
        Mac mac = this.createShaHmac(password.getBytes(ASCII));
        mac.update(salt);
        mac.update(INT_1);
        byte[] result = mac.doFinal();
        byte[] previous = null;
        for (int i = 1; i < iterationCount; ++i) {
            mac.update(previous != null ? previous : result);
            previous = mac.doFinal();
            for (int x = 0; x < result.length; ++x) {
                int n = x;
                result[n] = (byte)(result[n] ^ previous[x]);
            }
        }
        return result;
    }

    private byte[] computeHmac(byte[] key, String string) {
        Mac mac = this.createShaHmac(key);
        mac.update(string.getBytes(StandardCharsets.US_ASCII));
        return mac.doFinal();
    }

    private Mac createShaHmac(byte[] keyBytes) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, this.getHmacName());
            Mac mac = Mac.getInstance(this.getHmacName());
            mac.init(key);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    protected String createStoredPassword(String password) {
        if (this._doNotCreateStoredPasswordBecauseItIsBeingUpgraded) {
            return password;
        }
        try {
            int iterationCount = this.getIterationCount();
            byte[] salt = this.generateSalt();
            byte[] saltedPassword = this.createSaltedPassword(salt, password, iterationCount);
            byte[] clientKey = this.computeHmac(saltedPassword, "Client Key");
            byte[] storedKey = MessageDigest.getInstance(this.getDigestName()).digest(clientKey);
            byte[] serverKey = this.computeHmac(saltedPassword, "Server Key");
            return Base64.getEncoder().encodeToString(salt) + ",," + Base64.getEncoder().encodeToString(storedKey) + "," + Base64.getEncoder().encodeToString(serverKey) + "," + iterationCount;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    void validateUser(ManagedUser managedUser) {
        if (!ASCII.newEncoder().canEncode(managedUser.getName())) {
            throw new IllegalArgumentException("User names are restricted to characters in the ASCII charset");
        }
    }

    @Override
    public ScramSaslServerSource.SaltAndPasswordKeys getSaltAndPasswordKeys(String username) {
        SaslException exception;
        int iterationCount;
        byte[] serverKey;
        byte[] storedKey;
        byte[] salt;
        ManagedUser user = this.getUser(username);
        if (user == null) {
            salt = this.generateSalt();
            storedKey = null;
            serverKey = null;
            iterationCount = this.getIterationCount();
            exception = new SaslException("Authentication Failed");
        } else {
            this.updateStoredPasswordFormatIfNecessary(user);
            String[] passwordFields = user.getPassword().split(",");
            salt = Strings.decodePrivateBase64(passwordFields[PasswordField.SALT.ordinal()], "user '" + user.getName() + "' salt");
            storedKey = Strings.decodePrivateBase64(passwordFields[PasswordField.STORED_KEY.ordinal()], "user '" + user.getName() + "' stored key");
            serverKey = Strings.decodePrivateBase64(passwordFields[PasswordField.SERVER_KEY.ordinal()], "user '" + user.getName() + "' server key");
            iterationCount = Integer.parseInt(passwordFields[PasswordField.ITERATION_COUNT.ordinal()]);
            exception = null;
        }
        return new ScramSaslServerSource.SaltAndPasswordKeys(){

            @Override
            public byte[] getSalt() {
                return salt;
            }

            @Override
            public byte[] getStoredKey() throws SaslException {
                if (storedKey == null) {
                    throw exception;
                }
                return storedKey;
            }

            @Override
            public byte[] getServerKey() throws SaslException {
                if (serverKey == null) {
                    throw exception;
                }
                return serverKey;
            }

            @Override
            public int getIterationCount() throws SaslException {
                if (iterationCount < 0) {
                    throw exception;
                }
                return iterationCount;
            }
        };
    }

    private byte[] generateSalt() {
        byte[] tmpSalt = new byte[32];
        this._random.nextBytes(tmpSalt);
        return tmpSalt;
    }

    private static enum PasswordField {
        SALT,
        SALTED_PASSWORD,
        STORED_KEY,
        SERVER_KEY,
        ITERATION_COUNT;

    }
}

