/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.database.AbstractPasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.PlainUser;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5Negotiator;
import org.apache.qpid.server.security.auth.sasl.plain.PlainNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramNegotiator;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSourceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainPasswordFilePrincipalDatabase
extends AbstractPasswordFilePrincipalDatabase<PlainUser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlainPasswordFilePrincipalDatabase.class);
    private final List<String> _mechanisms = Collections.unmodifiableList(Arrays.asList("PLAIN", "CRAM-MD5", "SCRAM-SHA-1", "SCRAM-SHA-256"));
    private final ScramSaslServerSourceAdapter _scramSha1Adapter;
    private final ScramSaslServerSourceAdapter _scramSha256Adapter;

    public PlainPasswordFilePrincipalDatabase(PasswordCredentialManagingAuthenticationProvider<?> authenticationProvider) {
        super(authenticationProvider);
        PasswordSource passwordSource = this.getPasswordSource();
        int scramIterationCount = authenticationProvider.getContextValue(Integer.class, "qpid.auth.scram.iteration_count");
        this._scramSha1Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA1", "SHA-1", passwordSource);
        this._scramSha256Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA256", "SHA-256", passwordSource);
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specified users password");
        }
        return this.compareCharArray(pwd, password);
    }

    @Override
    protected PlainUser createUserFromPassword(Principal principal, char[] passwd) {
        return new PlainUser(principal.getName(), passwd, this.getAuthenticationProvider());
    }

    @Override
    protected PlainUser createUserFromFileData(String[] result) {
        return new PlainUser(result, this.getAuthenticationProvider());
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<String> getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings) {
        if ("CRAM-MD5".equals(mechanism)) {
            return new CramMd5Negotiator(this.getAuthenticationProvider(), saslSettings.getLocalFQDN(), this.getPasswordSource());
        }
        if ("PLAIN".equals(mechanism)) {
            return new PlainNegotiator(this.getAuthenticationProvider());
        }
        if ("SCRAM-SHA-1".equals(mechanism)) {
            return new ScramNegotiator(this.getAuthenticationProvider(), this._scramSha1Adapter, "SCRAM-SHA-1");
        }
        if ("SCRAM-SHA-256".equals(mechanism)) {
            return new ScramNegotiator(this.getAuthenticationProvider(), this._scramSha256Adapter, "SCRAM-SHA-256");
        }
        return null;
    }
}

