/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrustAnchorValidatingTrustManager
implements X509TrustManager {
    private static Logger LOGGER = LoggerFactory.getLogger(TrustAnchorValidatingTrustManager.class);
    private String _trustStoreName;
    private final X509TrustManager _x509TrustManager;
    private final Set<TrustAnchor> _trustAnchors;
    private final Set<Certificate> _otherCerts;

    TrustAnchorValidatingTrustManager(String trustStoreName, X509TrustManager x509TrustManager, Set<TrustAnchor> trustAnchors, Set<Certificate> otherCerts) {
        this._trustStoreName = trustStoreName;
        this._x509TrustManager = x509TrustManager;
        this._trustAnchors = trustAnchors;
        this._otherCerts = otherCerts;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        PKIXCertPathBuilderResult pkixCertPathBuilderResult;
        this._x509TrustManager.checkClientTrusted(x509Certificates, authType);
        X509Certificate peerCertificate = x509Certificates[0];
        try {
            pkixCertPathBuilderResult = this.getPkixCertPathBuilderResult(x509Certificates, this._trustAnchors, this._otherCerts);
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException("Unexpected error whilst validating trust-anchor", e);
        }
        X509Certificate trustAnchorCert = pkixCertPathBuilderResult.getTrustAnchor().getTrustedCert();
        try {
            trustAnchorCert.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            LOGGER.warn("Authentication failed for peer bearing certificate (subject DN '{}') as the trust anchor (subject DN '{}') within truststore '{}' is either expired or not yet valid. Validity range {} - {}", new Object[]{peerCertificate.getSubjectDN(), trustAnchorCert.getSubjectDN(), this._trustStoreName, trustAnchorCert.getNotBefore(), trustAnchorCert.getNotAfter()});
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this._x509TrustManager.checkServerTrusted(x509Certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this._x509TrustManager.getAcceptedIssuers();
    }

    private PKIXCertPathBuilderResult getPkixCertPathBuilderResult(X509Certificate[] x509Certificates, Set<TrustAnchor> trustAnchors, Set<Certificate> otherCerts) throws GeneralSecurityException {
        HashSet<Certificate> storeCerts = new HashSet<Certificate>();
        storeCerts.addAll(otherCerts);
        Iterator<X509Certificate> iterator = Arrays.asList(x509Certificates).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Peer certificate not found");
        }
        X509Certificate peerCertificate = iterator.next();
        while (iterator.hasNext()) {
            X509Certificate intermediate = iterator.next();
            storeCerts.add(intermediate);
        }
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(peerCertificate);
        storeCerts.add(peerCertificate);
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        pkixParams.setRevocationEnabled(false);
        CertStore intermediateCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(storeCerts));
        pkixParams.addCertStore(intermediateCertStore);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        return (PKIXCertPathBuilderResult)builder.build(pkixParams);
    }
}

