/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.OrderedQueueEntry;
import org.apache.qpid.server.queue.OrderedQueueEntryList;
import org.apache.qpid.server.queue.PriorityQueueImpl;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.store.MessageEnqueueRecord;

public abstract class PriorityQueueList
extends OrderedQueueEntryList {
    public static PriorityQueueList newInstance(PriorityQueueImpl queue) {
        return new PriorityQueueMasterList(queue, queue.getPriorities());
    }

    public PriorityQueueList(PriorityQueueImpl queue, OrderedQueueEntryList.HeadCreator headCreator) {
        super(queue, queue.getQueueStatistics(), headCreator);
    }

    static class PriorityQueueEntry
    extends OrderedQueueEntry {
        private PriorityQueueEntry(PriorityQueueList queueEntryList) {
            super(queueEntryList);
        }

        public PriorityQueueEntry(PriorityQueueEntrySubList queueEntryList, ServerMessage<?> message, MessageEnqueueRecord messageEnqueueRecord) {
            super(queueEntryList, message, messageEnqueueRecord);
        }

        @Override
        public int compareTo(QueueEntry o) {
            PriorityQueueEntry other = (PriorityQueueEntry)o;
            PriorityQueueEntrySubList pqel = (PriorityQueueEntrySubList)other.getQueueEntryList();
            int otherPriority = pqel.getListPriority();
            int thisPriority = ((PriorityQueueEntrySubList)this.getQueueEntryList()).getListPriority();
            if (thisPriority != otherPriority) {
                return thisPriority > otherPriority ? -1 : 1;
            }
            return super.compareTo(o);
        }
    }

    static class PriorityQueueEntrySubList
    extends PriorityQueueList {
        private static final OrderedQueueEntryList.HeadCreator HEAD_CREATOR = new OrderedQueueEntryList.HeadCreator(){

            @Override
            public PriorityQueueEntry createHead(QueueEntryList list) {
                return new PriorityQueueEntry((PriorityQueueList)list);
            }
        };
        private int _listPriority;

        public PriorityQueueEntrySubList(PriorityQueueImpl queue, int listPriority) {
            super(queue, HEAD_CREATOR);
            this._listPriority = listPriority;
        }

        @Override
        protected PriorityQueueEntry createQueueEntry(ServerMessage<?> message, MessageEnqueueRecord enqueueRecord) {
            return new PriorityQueueEntry(this, message, enqueueRecord);
        }

        public int getListPriority() {
            return this._listPriority;
        }

        @Override
        public QueueEntry getLeastSignificantOldestEntry() {
            return this.getOldestEntry();
        }
    }

    static class PriorityQueueMasterList
    extends PriorityQueueList {
        private static final OrderedQueueEntryList.HeadCreator DUMMY_HEAD_CREATOR = new OrderedQueueEntryList.HeadCreator(){

            @Override
            public PriorityQueueEntry createHead(QueueEntryList list) {
                return null;
            }
        };
        private final PriorityQueueImpl _queue;
        private final PriorityQueueEntrySubList[] _priorityLists;
        private final int _priorities;
        private final int _priorityOffset;

        public PriorityQueueMasterList(PriorityQueueImpl queue, int priorities) {
            super(queue, DUMMY_HEAD_CREATOR);
            this._queue = queue;
            this._priorityLists = new PriorityQueueEntrySubList[priorities];
            this._priorities = priorities;
            this._priorityOffset = 5 - (priorities + 1) / 2;
            for (int i = 0; i < priorities; ++i) {
                this._priorityLists[i] = new PriorityQueueEntrySubList(queue, i);
            }
        }

        @Override
        public int getPriorities() {
            return this._priorities;
        }

        public PriorityQueueImpl getQueue() {
            return this._queue;
        }

        @Override
        public PriorityQueueEntry add(ServerMessage message, MessageEnqueueRecord enqueueRecord) {
            int index = message.getMessageHeader().getPriority() - this._priorityOffset;
            if (index >= this._priorities) {
                index = this._priorities - 1;
            } else if (index < 0) {
                index = 0;
            }
            return (PriorityQueueEntry)this._priorityLists[index].add(message, enqueueRecord);
        }

        @Override
        protected PriorityQueueEntry createQueueEntry(ServerMessage<?> message, MessageEnqueueRecord enqueueRecord) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PriorityQueueEntry next(QueueEntry node) {
            PriorityQueueEntry next = (PriorityQueueEntry)node.getNextValidEntry();
            if (next == null) {
                PriorityQueueList nodeEntryList = (PriorityQueueList)((PriorityQueueEntry)node).getQueueEntryList();
                int index = this._priorityLists.length - 1;
                while (this._priorityLists[index] != nodeEntryList) {
                    --index;
                }
                while (next == null && index != 0) {
                    next = (PriorityQueueEntry)this._priorityLists[--index].getHead().getNextValidEntry();
                }
            }
            return next;
        }

        @Override
        public PriorityQueueEntryListIterator iterator() {
            return new PriorityQueueEntryListIterator();
        }

        @Override
        public PriorityQueueEntry getHead() {
            return (PriorityQueueEntry)this._priorityLists[this._priorities - 1].getHead();
        }

        @Override
        public PriorityQueueEntry getTail() {
            return (PriorityQueueEntry)this._priorityLists[0].getTail();
        }

        @Override
        public void entryDeleted(QueueEntry queueEntry) {
        }

        @Override
        public QueueEntry getOldestEntry() {
            QueueEntry oldest = null;
            for (PriorityQueueEntrySubList subList : this._priorityLists) {
                QueueEntry subListOldest = subList.getOldestEntry();
                if (oldest != null && (subListOldest == null || subListOldest.getMessage().getMessageNumber() >= oldest.getMessage().getMessageNumber())) continue;
                oldest = subListOldest;
            }
            return oldest;
        }

        @Override
        public QueueEntry getLeastSignificantOldestEntry() {
            for (PriorityQueueEntrySubList subList : this._priorityLists) {
                QueueEntry subListLast = subList.getLeastSignificantOldestEntry();
                if (subListLast == null) continue;
                return subListLast;
            }
            return null;
        }

        private final class PriorityQueueEntryListIterator
        implements QueueEntryIterator {
            private final QueueEntryIterator[] _iterators;
            private PriorityQueueEntry _lastNode;

            PriorityQueueEntryListIterator() {
                this._iterators = new QueueEntryIterator[PriorityQueueMasterList.this._priorityLists.length];
                for (int i = 0; i < PriorityQueueMasterList.this._priorityLists.length; ++i) {
                    this._iterators[i] = PriorityQueueMasterList.this._priorityLists[i].iterator();
                }
                this._lastNode = (PriorityQueueEntry)this._iterators[this._iterators.length - 1].getNode();
            }

            @Override
            public boolean atTail() {
                for (int i = 0; i < this._iterators.length; ++i) {
                    if (this._iterators[i].atTail()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public PriorityQueueEntry getNode() {
                return this._lastNode;
            }

            @Override
            public boolean advance() {
                for (int i = this._iterators.length - 1; i >= 0; --i) {
                    if (!this._iterators[i].advance()) continue;
                    this._lastNode = (PriorityQueueEntry)this._iterators[i].getNode();
                    return true;
                }
                return false;
            }
        }
    }
}

